/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.context;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\u00072\b\b\u0001\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J,\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J,\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J4\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J4\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J,\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/devti/vcs/context/DiffFormatter;", "", "<init>", "()V", "revisionRegex", "Lkotlin/text/Regex;", "lineTip", "", "postProcess", "diffString", "shouldSkipLine", "", "line", "handleNewFile", "Lkotlin/Pair;", "", "lines", "", "index", "handleRename", "handleImportChange", "length", "handleDelete", "handleModifyMarkers", "core"})
public final class DiffFormatter {
    @NotNull
    public static final DiffFormatter INSTANCE = new DiffFormatter();
    @NotNull
    private static final Regex revisionRegex = new Regex("\\(revision [^)]+\\)");
    @NotNull
    private static final String lineTip = "\\ No newline at end of file";

    private DiffFormatter() {
    }

    @NotNull
    public final String postProcess(@NotNull String diffString) {
        Intrinsics.checkNotNullParameter((Object)diffString, (String)"diffString");
        List lines = StringsKt.lines((CharSequence)diffString);
        int length = lines.size();
        ArrayList<Object> destination = new ArrayList<Object>();
        int index = 0;
        while (index < lines.size()) {
            String line = (String)lines.get(index);
            if (this.shouldSkipLine(line)) {
                ++index;
                continue;
            }
            Pair<String, Integer> newFileResult = this.handleNewFile(lines, index);
            if (newFileResult != null) {
                destination.add(newFileResult.getFirst());
                index = ((Number)newFileResult.getSecond()).intValue();
                continue;
            }
            Pair<String, Integer> renameResult = this.handleRename(lines, index);
            if (renameResult != null) {
                destination.add(renameResult.getFirst());
                index = ((Number)renameResult.getSecond()).intValue();
                continue;
            }
            Pair<String, Integer> importResult = this.handleImportChange(lines, index, length);
            if (importResult != null) {
                destination.add(importResult.getFirst());
                index = ((Number)importResult.getSecond()).intValue();
                continue;
            }
            Pair<String, Integer> deleteResult = this.handleDelete(lines, index, length);
            if (deleteResult != null) {
                destination.add(deleteResult.getFirst());
                index = ((Number)deleteResult.getSecond()).intValue();
                continue;
            }
            Pair<String, Integer> modifyResult = this.handleModifyMarkers(lines, index);
            if (modifyResult != null) {
                destination.add(modifyResult.getFirst());
                index = ((Number)modifyResult.getSecond()).intValue();
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"---", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"+++", (boolean)false, (int)2, null)) {
                String result = ((Object)StringsKt.trim((CharSequence)revisionRegex.replace((CharSequence)line, ""))).toString();
                if (((CharSequence)result).length() > 0) {
                    destination.add(result);
                }
            } else if (((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()).length() > 0) {
                destination.add(line);
            }
            ++index;
        }
        return CollectionsKt.joinToString$default((Iterable)destination, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean shouldSkipLine(String line) {
        return StringsKt.startsWith$default((String)line, (String)"diff --git ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"index:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"Index:", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)line, (Object)"===================================================================") || StringsKt.contains$default((CharSequence)line, (CharSequence)lineTip, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"---\t/dev/null", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"@@", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)"@@", (boolean)false, (int)2, null);
    }

    private final Pair<String, Integer> handleNewFile(List<String> lines, int index) {
        String string;
        String line = lines.get(index);
        if (!StringsKt.startsWith$default((String)line, (String)"new file mode", (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = (String)CollectionsKt.getOrNull(lines, (int)(index + 1));
        if (string2 == null) {
            return null;
        }
        String nextLine = string2;
        if (!StringsKt.startsWith$default((String)nextLine, (String)"--- /dev/null", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = (String)CollectionsKt.getOrNull(lines, (int)(index + 2));
        if (string3 == null) {
            return null;
        }
        String nextNextLine = string3;
        String string4 = nextNextLine.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String withoutHead = string4;
        int tabIndex = StringsKt.indexOf$default((CharSequence)withoutHead, (String)"\t", (int)0, (boolean)false, (int)6, null);
        if (tabIndex > 0) {
            String string5 = withoutHead.substring(0, tabIndex);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string = withoutHead;
        }
        String withoutFooter = string;
        return new Pair((Object)("new file " + withoutFooter), (Object)(index + 3));
    }

    private final Pair<String, Integer> handleRename(List<String> lines, int index) {
        String line = lines.get(index);
        if (!StringsKt.startsWith$default((String)line, (String)"rename from", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = (String)CollectionsKt.getOrNull(lines, (int)(index + 1));
        if (string == null) {
            return null;
        }
        String nextLine = string;
        if (!StringsKt.startsWith$default((String)nextLine, (String)"rename to", (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = line.substring(12);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String from = string2;
        String string3 = nextLine.substring(10);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String to = string3;
        return new Pair((Object)("rename file from " + from + " to " + to), (Object)(index + 4));
    }

    private final Pair<String, Integer> handleImportChange(List<String> lines, int index, int length) {
        int tryToFindIndex;
        String line = lines.get(index);
        if (!StringsKt.startsWith$default((String)line, (String)" import", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = (String)CollectionsKt.getOrNull(lines, (int)(index + 1));
        if (string == null) {
            return null;
        }
        String nextLine = string;
        if (!StringsKt.startsWith$default((String)nextLine, (String)" import", (boolean)false, (int)2, null)) {
            return null;
        }
        String oldImportLine = "";
        String newImportLine = "";
        ArrayList<String> importLines = new ArrayList<String>();
        importLines.add(line);
        importLines.add(nextLine);
        for (tryToFindIndex = index + 2; tryToFindIndex < length; ++tryToFindIndex) {
            String tryLine = lines.get(tryToFindIndex);
            if (StringsKt.startsWith$default((String)tryLine, (String)"Index:", (boolean)false, (int)2, null)) break;
            if (StringsKt.startsWith$default((String)tryLine, (String)" import", (boolean)false, (int)2, null)) {
                importLines.add(tryLine);
                continue;
            }
            if (StringsKt.startsWith$default((String)tryLine, (String)"-import ", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)tryLine.substring(8), (String)"substring(...)");
                importLines.add(tryLine);
                continue;
            }
            if (!StringsKt.startsWith$default((String)tryLine, (String)"+import ", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)tryLine.substring(8), (String)"substring(...)");
            importLines.add(tryLine);
        }
        if (((CharSequence)oldImportLine).length() > 0 && ((CharSequence)newImportLine).length() > 0 && importLines.size() == tryToFindIndex - index) {
            return new Pair((Object)("change import from " + oldImportLine + " to " + newImportLine), (Object)tryToFindIndex);
        }
        return null;
    }

    private final Pair<String, Integer> handleDelete(List<String> lines, int index, int length) {
        int newIndex;
        String string;
        String line = lines.get(index);
        if (!StringsKt.startsWith$default((String)line, (String)"deleted file mode", (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = (String)CollectionsKt.getOrNull(lines, (int)(index + 1));
        if (string2 == null) {
            return null;
        }
        String nextLine = string2;
        if (!StringsKt.startsWith$default((String)nextLine, (String)"--- a/", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = nextLine.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String withoutHead = string3;
        int tabIndex = StringsKt.indexOf$default((CharSequence)withoutHead, (String)"\t", (int)0, (boolean)false, (int)6, null);
        if (tabIndex > 0) {
            String string4 = withoutHead.substring(0, tabIndex);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = withoutHead;
        }
        String withoutFooter = string;
        for (newIndex = index + 2; newIndex < length && (String)CollectionsKt.getOrNull(lines, (int)newIndex) != null; ++newIndex) {
            String nextNextLine;
            if (!StringsKt.startsWith$default((String)nextNextLine, (String)"Index:", (boolean)false, (int)2, null)) continue;
            ++newIndex;
            break;
        }
        return new Pair((Object)("delete file " + withoutFooter), (Object)newIndex);
    }

    private final Pair<String, Integer> handleModifyMarkers(List<String> lines, int index) {
        String line = lines.get(index);
        if (!StringsKt.startsWith$default((String)line, (String)"---", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)line, (String)"+++", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = (String)CollectionsKt.getOrNull(lines, (int)(index + 1));
        if (string == null) {
            return null;
        }
        String nextLine = string;
        if (!StringsKt.startsWith$default((String)nextLine, (String)"+++", (boolean)false, (int)2, null)) {
            return null;
        }
        String substringBefore = StringsKt.substringBefore$default((String)line, (String)"(revision", null, (int)2, null);
        String string2 = substringBefore.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String startLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        int endIndex = StringsKt.indexOf$default((CharSequence)nextLine, (String)"(date", (int)0, (boolean)false, (int)6, null);
        if (endIndex == -1) {
            endIndex = StringsKt.indexOf$default((CharSequence)nextLine, (String)"(revision", (int)0, (boolean)false, (int)6, null);
        }
        if (endIndex == -1) {
            endIndex = nextLine.length();
        }
        String string3 = nextLine.substring(6, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String withoutEnd = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (Intrinsics.areEqual((Object)startLine, (Object)withoutEnd)) {
            return new Pair((Object)("modify file " + startLine), (Object)(index + 2));
        }
        return null;
    }
}

