/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.context;

import cc.unitmesh.devti.vcs.context.DiffStrategy;
import cc.unitmesh.devti.vcs.context.FilePriority;
import cc.unitmesh.devti.vcs.context.FullDiffStrategy;
import cc.unitmesh.devti.vcs.context.MetadataOnlyStrategy;
import cc.unitmesh.devti.vcs.context.PrioritizedChange;
import cc.unitmesh.devti.vcs.context.SummaryDiffStrategy;
import cc.unitmesh.devti.vcs.context.TokenBudget;
import cc.unitmesh.devti.vcs.context.TokenCounter;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010J6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/vcs/context/ContextWindowManager;", "", "tokenBudget", "Lcc/unitmesh/devti/vcs/context/TokenBudget;", "tokenCounter", "Lcc/unitmesh/devti/vcs/context/TokenCounter;", "<init>", "(Lcc/unitmesh/devti/vcs/context/TokenBudget;Lcc/unitmesh/devti/vcs/context/TokenCounter;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "allocateChanges", "Lcc/unitmesh/devti/vcs/context/ContextWindowManager$AllocationResult;", "prioritizedChanges", "", "Lcc/unitmesh/devti/vcs/context/PrioritizedChange;", "diffContents", "", "", "tryAllocateChange", "", "change", "diffContent", "fullDiffChanges", "", "summaryChanges", "selectStrategy", "Lcc/unitmesh/devti/vcs/context/DiffStrategy;", "AllocationResult", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nContextWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextWindowManager.kt\ncc/unitmesh/devti/vcs/context/ContextWindowManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,148:1\n11#2:149\n*S KotlinDebug\n*F\n+ 1 ContextWindowManager.kt\ncc/unitmesh/devti/vcs/context/ContextWindowManager\n*L\n12#1:149\n*E\n"})
public final class ContextWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenBudget tokenBudget;
    @NotNull
    private final TokenCounter tokenCounter;
    @NotNull
    private final Logger logger;

    public ContextWindowManager(@NotNull TokenBudget tokenBudget, @NotNull TokenCounter tokenCounter) {
        Intrinsics.checkNotNullParameter((Object)tokenBudget, (String)"tokenBudget");
        Intrinsics.checkNotNullParameter((Object)tokenCounter, (String)"tokenCounter");
        this.tokenBudget = tokenBudget;
        this.tokenCounter = tokenCounter;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ContextWindowManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public /* synthetic */ ContextWindowManager(TokenBudget tokenBudget, TokenCounter tokenCounter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tokenCounter = TokenCounter.Companion.getDEFAULT();
        }
        this(tokenBudget, tokenCounter);
    }

    @NotNull
    public final AllocationResult allocateChanges(@NotNull List<PrioritizedChange> prioritizedChanges, @NotNull Map<PrioritizedChange, String> diffContents) {
        Intrinsics.checkNotNullParameter(prioritizedChanges, (String)"prioritizedChanges");
        Intrinsics.checkNotNullParameter(diffContents, (String)"diffContents");
        List fullDiffChanges = new ArrayList();
        List summaryChanges = new ArrayList();
        List excludedChanges = new ArrayList();
        this.tokenBudget.reset();
        for (PrioritizedChange change : prioritizedChanges) {
            if (WhenMappings.$EnumSwitchMapping$0[change.getPriority().ordinal()] == 1) {
                excludedChanges.add(change);
                continue;
            }
            boolean allocated = this.tryAllocateChange(change, diffContents.get(change), fullDiffChanges, summaryChanges);
            if (allocated) continue;
            excludedChanges.add(change);
        }
        this.logger.info("Context allocation: " + fullDiffChanges.size() + " full, " + summaryChanges.size() + " summary, " + excludedChanges.size() + " excluded. Tokens used: " + this.tokenBudget.getUsed() + "/" + this.tokenBudget.getMaxTokens());
        return new AllocationResult(fullDiffChanges, summaryChanges, excludedChanges, this.tokenBudget.getUsed());
    }

    private final boolean tryAllocateChange(PrioritizedChange change, String diffContent, List<PrioritizedChange> fullDiffChanges, List<PrioritizedChange> summaryChanges) {
        MetadataOnlyStrategy metadataStrategy;
        String metadata;
        int metadataTokens;
        int tokens;
        if (change.getPriority().getLevel() >= FilePriority.HIGH.getLevel() && diffContent != null && this.tokenBudget.allocate(tokens = this.tokenCounter.countTokens(diffContent))) {
            fullDiffChanges.add(change);
            return true;
        }
        SummaryDiffStrategy summaryStrategy = new SummaryDiffStrategy();
        String summary = summaryStrategy.generateDiff(change, diffContent);
        int summaryTokens = this.tokenCounter.countTokens(summary);
        if (this.tokenBudget.allocate(summaryTokens)) {
            summaryChanges.add(change);
            return true;
        }
        if (change.getPriority() == FilePriority.CRITICAL && this.tokenBudget.allocate(metadataTokens = this.tokenCounter.countTokens(metadata = (metadataStrategy = new MetadataOnlyStrategy()).generateDiff(change, null)))) {
            summaryChanges.add(change);
            return true;
        }
        return false;
    }

    @NotNull
    public final DiffStrategy selectStrategy(@NotNull PrioritizedChange change, @Nullable String diffContent) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (diffContent == null) {
            return new MetadataOnlyStrategy();
        }
        int tokens = this.tokenCounter.countTokens(diffContent);
        return change.getPriority().getLevel() >= FilePriority.HIGH.getLevel() && this.tokenBudget.hasCapacity(tokens) ? (DiffStrategy)new FullDiffStrategy() : (change.getPriority().getLevel() >= FilePriority.MEDIUM.getLevel() ? (DiffStrategy)new SummaryDiffStrategy() : (DiffStrategy)new MetadataOnlyStrategy());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003JC\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/vcs/context/ContextWindowManager$AllocationResult;", "", "fullDiffChanges", "", "Lcc/unitmesh/devti/vcs/context/PrioritizedChange;", "summaryChanges", "excludedChanges", "totalTokensUsed", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;I)V", "getFullDiffChanges", "()Ljava/util/List;", "getSummaryChanges", "getExcludedChanges", "getTotalTokensUsed", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class AllocationResult {
        @NotNull
        private final List<PrioritizedChange> fullDiffChanges;
        @NotNull
        private final List<PrioritizedChange> summaryChanges;
        @NotNull
        private final List<PrioritizedChange> excludedChanges;
        private final int totalTokensUsed;

        public AllocationResult(@NotNull List<PrioritizedChange> fullDiffChanges, @NotNull List<PrioritizedChange> summaryChanges, @NotNull List<PrioritizedChange> excludedChanges, int totalTokensUsed) {
            Intrinsics.checkNotNullParameter(fullDiffChanges, (String)"fullDiffChanges");
            Intrinsics.checkNotNullParameter(summaryChanges, (String)"summaryChanges");
            Intrinsics.checkNotNullParameter(excludedChanges, (String)"excludedChanges");
            this.fullDiffChanges = fullDiffChanges;
            this.summaryChanges = summaryChanges;
            this.excludedChanges = excludedChanges;
            this.totalTokensUsed = totalTokensUsed;
        }

        @NotNull
        public final List<PrioritizedChange> getFullDiffChanges() {
            return this.fullDiffChanges;
        }

        @NotNull
        public final List<PrioritizedChange> getSummaryChanges() {
            return this.summaryChanges;
        }

        @NotNull
        public final List<PrioritizedChange> getExcludedChanges() {
            return this.excludedChanges;
        }

        public final int getTotalTokensUsed() {
            return this.totalTokensUsed;
        }

        @NotNull
        public final List<PrioritizedChange> component1() {
            return this.fullDiffChanges;
        }

        @NotNull
        public final List<PrioritizedChange> component2() {
            return this.summaryChanges;
        }

        @NotNull
        public final List<PrioritizedChange> component3() {
            return this.excludedChanges;
        }

        public final int component4() {
            return this.totalTokensUsed;
        }

        @NotNull
        public final AllocationResult copy(@NotNull List<PrioritizedChange> fullDiffChanges, @NotNull List<PrioritizedChange> summaryChanges, @NotNull List<PrioritizedChange> excludedChanges, int totalTokensUsed) {
            Intrinsics.checkNotNullParameter(fullDiffChanges, (String)"fullDiffChanges");
            Intrinsics.checkNotNullParameter(summaryChanges, (String)"summaryChanges");
            Intrinsics.checkNotNullParameter(excludedChanges, (String)"excludedChanges");
            return new AllocationResult(fullDiffChanges, summaryChanges, excludedChanges, totalTokensUsed);
        }

        public static /* synthetic */ AllocationResult copy$default(AllocationResult allocationResult, List list, List list2, List list3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = allocationResult.fullDiffChanges;
            }
            if ((n2 & 2) != 0) {
                list2 = allocationResult.summaryChanges;
            }
            if ((n2 & 4) != 0) {
                list3 = allocationResult.excludedChanges;
            }
            if ((n2 & 8) != 0) {
                n = allocationResult.totalTokensUsed;
            }
            return allocationResult.copy(list, list2, list3, n);
        }

        @NotNull
        public String toString() {
            return "AllocationResult(fullDiffChanges=" + this.fullDiffChanges + ", summaryChanges=" + this.summaryChanges + ", excludedChanges=" + this.excludedChanges + ", totalTokensUsed=" + this.totalTokensUsed + ")";
        }

        public int hashCode() {
            int result = ((Object)this.fullDiffChanges).hashCode();
            result = result * 31 + ((Object)this.summaryChanges).hashCode();
            result = result * 31 + ((Object)this.excludedChanges).hashCode();
            result = result * 31 + Integer.hashCode(this.totalTokensUsed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AllocationResult)) {
                return false;
            }
            AllocationResult allocationResult = (AllocationResult)other;
            if (!Intrinsics.areEqual(this.fullDiffChanges, allocationResult.fullDiffChanges)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.summaryChanges, allocationResult.summaryChanges)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.excludedChanges, allocationResult.excludedChanges)) {
                return false;
            }
            return this.totalTokensUsed == allocationResult.totalTokensUsed;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/vcs/context/ContextWindowManager$Companion;", "", "<init>", "()V", "custom", "Lcc/unitmesh/devti/vcs/context/ContextWindowManager;", "maxTokens", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContextWindowManager custom(int maxTokens) {
            return new ContextWindowManager(TokenBudget.Companion.custom(maxTokens), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilePriority.values().length];
            try {
                nArray[FilePriority.EXCLUDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

