/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.vcs.context.ContextWindowManager;
import cc.unitmesh.devti.vcs.context.DiffFormatter;
import cc.unitmesh.devti.vcs.context.FilePriority;
import cc.unitmesh.devti.vcs.context.FilePriorityCalculator;
import cc.unitmesh.devti.vcs.context.FullDiffStrategy;
import cc.unitmesh.devti.vcs.context.PrioritizedChange;
import cc.unitmesh.devti.vcs.context.SummaryDiffStrategy;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.project.ProjectKt;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ,\u0010\u0011\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/vcs/DiffSimplifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "simplify", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "ignoreFilePatterns", "Ljava/nio/file/PathMatcher;", "simplifyWithContext", "maxTokens", "", "generateDiffContents", "", "Lcc/unitmesh/devti/vcs/context/PrioritizedChange;", "prioritizedChanges", "basePath", "buildDiffOutput", "allocation", "Lcc/unitmesh/devti/vcs/context/ContextWindowManager$AllocationResult;", "diffContents", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDiffSimplifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffSimplifier.kt\ncc/unitmesh/devti/vcs/DiffSimplifier\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n11#2:167\n766#3:168\n857#3,2:169\n1549#3:171\n1620#3,3:172\n1855#3,2:175\n1855#3,2:177\n1855#3,2:179\n*S KotlinDebug\n*F\n+ 1 DiffSimplifier.kt\ncc/unitmesh/devti/vcs/DiffSimplifier\n*L\n19#1:167\n92#1:168\n92#1:169,2\n102#1:171\n102#1:172,3\n123#1:175,2\n144#1:177,2\n151#1:179,2\n*E\n"})
public final class DiffSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public DiffSimplifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffSimplifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String simplify(@NotNull List<? extends Change> changes, @NotNull List<? extends PathMatcher> ignoreFilePatterns) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(ignoreFilePatterns, (String)"ignoreFilePatterns");
        return this.simplifyWithContext(changes, ignoreFilePatterns, 8000);
    }

    @NotNull
    public final String simplifyWithContext(@NotNull List<? extends Change> changes, @NotNull List<? extends PathMatcher> ignoreFilePatterns, int maxTokens) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(ignoreFilePatterns, (String)"ignoreFilePatterns");
        String originChanges = "";
        try {
            String result;
            String string = this.project.getBasePath();
            if (string == null) {
                throw new RuntimeException("Project base path is null.");
            }
            String basePath = string;
            FilePriorityCalculator calculator = new FilePriorityCalculator(ignoreFilePatterns);
            List<PrioritizedChange> prioritizedChanges = calculator.calculateAndSort(changes);
            if (prioritizedChanges.isEmpty()) {
                return "";
            }
            Map<PrioritizedChange, String> diffContents = this.generateDiffContents(prioritizedChanges, basePath);
            ContextWindowManager windowManager = ContextWindowManager.Companion.custom(maxTokens);
            ContextWindowManager.AllocationResult allocation = windowManager.allocateChanges(prioritizedChanges, diffContents);
            originChanges = result = this.buildDiffOutput(allocation, diffContents);
            return DiffFormatter.INSTANCE.postProcess(result);
        }
        catch (Exception e) {
            if (((CharSequence)originChanges).length() > 0) {
                this.logger.warn("Error calculating diff: " + originChanges, (Throwable)e);
            }
            AutoDevNotifications.INSTANCE.error(this.project, "Error calculating diff: " + e.getMessage());
            return originChanges;
        }
    }

    public static /* synthetic */ String simplifyWithContext$default(DiffSimplifier diffSimplifier, List list, List list2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8000;
        }
        return diffSimplifier.simplifyWithContext(list, list2, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PrioritizedChange, String> generateDiffContents(List<PrioritizedChange> prioritizedChanges, String basePath) {
        void $this$filterTo$iv$iv;
        Map diffContents = new LinkedHashMap();
        Iterable $this$filter$iv = prioritizedChanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrioritizedChange it = (PrioritizedChange)element$iv$iv;
            boolean bl = false;
            if (!(it.getPriority().getLevel() >= FilePriority.HIGH.getLevel())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List highPriorityChanges = (List)destination$iv$iv;
        if (highPriorityChanges.isEmpty()) {
            return diffContents;
        }
        try {
            void $this$mapTo$iv$iv;
            StringWriter writer = new StringWriter();
            Iterable $this$map$iv = highPriorityChanges;
            boolean $i$f$map = false;
            Iterable $i$f$filterTo2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PrioritizedChange prioritizedChange = (PrioritizedChange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getChange());
            }
            List changes = (List)destination$iv$iv2;
            List list = IdeaTextPatchBuilder.buildPatch((Project)this.project, (Collection)changes, (Path)Path.of(basePath, new String[0]), (boolean)false, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"buildPatch(...)");
            List patches = list;
            UnifiedDiffWriter.write((Project)this.project, (Path)ProjectKt.getStateStore((Project)this.project).getProjectBasePath(), (Collection)patches, (Writer)writer, (String)"\n", null, (List)CollectionsKt.emptyList());
            String string = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String fullDiff = string;
            Iterable $this$forEach$iv = highPriorityChanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrioritizedChange prioritizedChange = (PrioritizedChange)element$iv;
                boolean bl = false;
                diffContents.put(prioritizedChange, fullDiff);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error generating diff contents", (Throwable)e);
        }
        return diffContents;
    }

    private final String buildDiffOutput(ContextWindowManager.AllocationResult allocation, Map<PrioritizedChange, String> diffContents) {
        StringBuilder output = new StringBuilder();
        FullDiffStrategy fullDiffStrategy = new FullDiffStrategy();
        Iterable $this$forEach$iv = allocation.getFullDiffChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrioritizedChange change = (PrioritizedChange)element$iv;
            boolean bl = false;
            String diff = fullDiffStrategy.generateDiff(change, diffContents.get(change));
            output.append(diff).append("\n");
        }
        SummaryDiffStrategy summaryStrategy = new SummaryDiffStrategy();
        Iterable $this$forEach$iv2 = allocation.getSummaryChanges();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PrioritizedChange change = (PrioritizedChange)element$iv;
            boolean bl = false;
            String summary = summaryStrategy.generateDiff(change, diffContents.get(change));
            output.append(summary).append("\n");
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/devti/vcs/DiffSimplifier$Companion;", "", "<init>", "()V", "postProcess", "", "diffString", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use DiffFormatter.postProcess instead", replaceWith=@ReplaceWith(expression="DiffFormatter.postProcess(diffString)", imports={}))
        @NotNull
        public final String postProcess(@NotNull String diffString) {
            Intrinsics.checkNotNullParameter((Object)diffString, (String)"diffString");
            return DiffFormatter.INSTANCE.postProcess(diffString);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

