/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.util.parser;

import cc.unitmesh.devti.util.parser.CodeVisitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcc/unitmesh/devti/util/parser/MarkdownCodeHelper;", "", "<init>", "()V", "parseCodeFromString", "", "", "markdown", "removeAllMarkdownCode", "markdownContent", "extractCodeFenceLanguage", "node", "Lorg/intellij/markdown/ast/ASTNode;", "core"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\ncc/unitmesh/devti/util/parser/MarkdownCodeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1011#2,2:117\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\ncc/unitmesh/devti/util/parser/MarkdownCodeHelper\n*L\n84#1:117,2\n*E\n"})
public final class MarkdownCodeHelper {
    @NotNull
    public static final MarkdownCodeHelper INSTANCE = new MarkdownCodeHelper();

    private MarkdownCodeHelper() {
    }

    @NotNull
    public final List<String> parseCodeFromString(@NotNull String markdown) {
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        List extensions = CollectionsKt.listOf((Object)TablesExtension.create());
        Parser parser = Parser.builder().extensions((Iterable)extensions).build();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"build(...)");
        Parser parser2 = parser;
        Node node = parser2.parse(markdown);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"parse(...)");
        Node node2 = node;
        CodeVisitor visitor2 = new CodeVisitor();
        node2.accept((Visitor)visitor2);
        if (visitor2.getCode().isEmpty()) {
            return CollectionsKt.listOf((Object)markdown);
        }
        return visitor2.getCode();
    }

    @NotNull
    public final String removeAllMarkdownCode(@NotNull String markdownContent) {
        Intrinsics.checkNotNullParameter((Object)markdownContent, (String)"markdownContent");
        if (((CharSequence)markdownContent).length() == 0) {
            return markdownContent;
        }
        GFMFlavourDescriptor flavour = new GFMFlavourDescriptor(false, false, false, 7, null);
        ASTNode parsedTree = new MarkdownParser((MarkdownFlavourDescriptor)flavour).buildMarkdownTreeFromString(markdownContent);
        List codeBlockReplacements = new ArrayList();
        ASTNodeKt.accept((ASTNode)parsedTree, (org.intellij.markdown.ast.visitors.Visitor)((org.intellij.markdown.ast.visitors.Visitor)new RecursiveVisitor(markdownContent, codeBlockReplacements){
            final /* synthetic */ String $markdownContent;
            final /* synthetic */ List<Pair<IntRange, String>> $codeBlockReplacements;
            {
                this.$markdownContent = $markdownContent;
                this.$codeBlockReplacements = $codeBlockReplacements;
            }

            public void visitNode(ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                IElementType iElementType = node.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    String language = MarkdownCodeHelper.INSTANCE.extractCodeFenceLanguage(node, this.$markdownContent);
                    String replacement = "```" + language + "\n// you can skip this part of the code.\n```";
                    this.$codeBlockReplacements.add((Pair<IntRange, String>)TuplesKt.to((Object)new IntRange(node.getStartOffset(), node.getEndOffset()), (Object)replacement));
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK)) {
                    String replacement = "```\n// you can skip this part of the code.\n```";
                    this.$codeBlockReplacements.add((Pair<IntRange, String>)TuplesKt.to((Object)new IntRange(node.getStartOffset(), node.getEndOffset()), (Object)replacement));
                } else {
                    super.visitNode(node);
                }
            }
        }));
        List $this$sortByDescending$iv = codeBlockReplacements;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
                }
            });
        }
        StringBuilder result = new StringBuilder(markdownContent);
        for (Pair pair : codeBlockReplacements) {
            IntRange range = (IntRange)pair.component1();
            String replacement = (String)pair.component2();
            result.replace(range.getFirst(), range.getLast(), replacement);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String extractCodeFenceLanguage(@NotNull ASTNode node, @NotNull String markdownContent) {
        String firstLine;
        MatchResult languageMatch;
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)markdownContent, (String)"markdownContent");
        String nodeText = ((Object)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)markdownContent)).toString();
        String string = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)nodeText));
        if (string == null) {
            string = "";
        }
        if ((object = (languageMatch = Regex.find$default((Regex)new Regex("^```(.*)$"), (CharSequence)((Object)StringsKt.trim((CharSequence)(firstLine = string))).toString(), (int)0, (int)2, null))) == null || (object = object.getGroupValues()) == null || (object = (String)CollectionsKt.getOrNull((List)object, (int)1)) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            object = "";
        }
        return object;
    }
}

