/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.util;

import cc.unitmesh.devti.vcs.gitignore.GitIgnoreUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\u00052\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\f\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\r\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\u0003\u001a\n\u0010\u0014\u001a\u00020\b*\u00020\u0003\u001a\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u000b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\u0016H\u0007\u001a\u001b\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u000b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\u0016H\u0007\u001a:\u0010\u0017\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\f\u001a\u00020\b2#\u0010\u0018\u001a\u001f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u0019\u00a2\u0006\u0002\b\u001aH\u0082\b\u001a\u001e\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001d2\u0006\u0010\f\u001a\u00020\b\u001a\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0007\u001a \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u0012\u0010!\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\f\u001a\u00020\b\"\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"isInProject", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findFile", "filename", "", "findFileByPath", "path", "canBeAdded", "relativePath", "isIgnoredByVcs", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "validOrNull", "isFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "readText", "findFileOrDirectory", "Lorg/jetbrains/annotations/SystemIndependent;", "getResolvedVirtualFile", "getChild", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "relativizeToClosestAncestor", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "findAncestor", "path1", "path2", "getResolvedPath", "core"})
@SourceDebugExtension(value={"SMAP\nProjectFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFileUtil.kt\ncc/unitmesh/devti/util/ProjectFileUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n117#1,4:179\n121#1,12:187\n1549#2:183\n1620#2,3:184\n1549#2:199\n1620#2,3:200\n*S KotlinDebug\n*F\n+ 1 ProjectFileUtil.kt\ncc/unitmesh/devti/util/ProjectFileUtilKt\n*L\n95#1:179,4\n95#1:187,12\n95#1:183\n95#1:184,3\n120#1:199\n120#1:200,3\n*E\n"})
public final class ProjectFileUtilKt {
    public static final boolean isInProject(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ActionsKt.runReadAction(() -> ProjectFileUtilKt.isInProject$lambda$0(project, virtualFile)) != null;
    }

    public static final boolean isInProject(@NotNull Project $this$isInProject, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isInProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return ProjectFileIndex.getInstance((Project)$this$isInProject).isInContent(virtualFile);
    }

    @Nullable
    public static final VirtualFile findFile(@NotNull Project $this$findFile, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$findFile);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile.findFileByRelativePath(filename);
    }

    @Nullable
    public static final VirtualFile findFileByPath(@NotNull Project $this$findFileByPath, @NotNull String path) {
        Path projectPath;
        Intrinsics.checkNotNullParameter((Object)$this$findFileByPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$findFileByPath);
        Path path2 = projectPath = virtualFile != null ? virtualFile.toNioPath() : null;
        Path realpath = path2 != null ? path2.resolve(path) : null;
        Path path3 = realpath;
        return VirtualFileManager.getInstance().findFileByUrl("file://" + (path3 != null ? path3.toAbsolutePath() : null));
    }

    public static final boolean canBeAdded(@NotNull VirtualFile $this$canBeAdded, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeAdded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!$this$canBeAdded.isValid() || $this$canBeAdded.isDirectory()) {
            return false;
        }
        if ($this$canBeAdded.getFileType().isBinary() || FileUtilRt.isTooLarge((long)$this$canBeAdded.getLength())) {
            return false;
        }
        if (FileTypeManager.getInstance().isFileIgnored($this$canBeAdded)) {
            return false;
        }
        return !ProjectFileUtilKt.isIgnoredByVcs(project, $this$canBeAdded);
    }

    @NotNull
    public static final String relativePath(@NotNull VirtualFile $this$relativePath, @NotNull Project project) {
        String relativePath;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!$this$relativePath.isValid()) {
            String string3 = $this$relativePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            return string3;
        }
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        Intrinsics.checkNotNull((Object)virtualFile);
        File projectDir = virtualFile.toNioPath().toFile();
        try {
            string2 = FileUtil.getRelativePath((File)projectDir, (File)$this$relativePath.toNioPath().toFile());
        }
        catch (Exception e) {
            string2 = null;
        }
        if ((string = (relativePath = string2)) == null) {
            String string4 = $this$relativePath.getPath();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        return string;
    }

    public static final boolean isIgnoredByVcs(@Nullable Project project, @Nullable VirtualFile file) {
        boolean bl;
        if (project == null || file == null) {
            return false;
        }
        try {
            bl = GitIgnoreUtil.INSTANCE.isIgnored(project, file);
        }
        catch (Exception e) {
            VcsIgnoreManager ignoreManager = VcsIgnoreManager.getInstance((Project)project);
            bl = ignoreManager.isPotentiallyIgnoredFile(file);
        }
        return bl;
    }

    @Nullable
    public static final VirtualFile virtualFile(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getFile(editor.getDocument());
    }

    @Nullable
    public static final VirtualFile validOrNull(@NotNull VirtualFile $this$validOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$validOrNull, (String)"<this>");
        return $this$validOrNull.isValid() ? $this$validOrNull : null;
    }

    public static final boolean isFile(@NotNull VirtualFile $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        return $this$isFile.isValid() && !$this$isFile.isDirectory();
    }

    @NotNull
    public static final String readText(@NotNull VirtualFile $this$readText) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        String string = VfsUtilCore.loadText((VirtualFile)$this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFileOrDirectory(@NotNull VirtualFile $this$findFileOrDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFileOrDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findFileOrDirectory;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = ProjectFileUtilKt.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = (VirtualFile)pair.component1();
        Path normalizedRelativePath$iv = (Path)pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator = ((Iterable)names$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                void name;
                int i$iv = n++;
                String name$iv = (String)iterator.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex((List)names$iv)) {
                    // empty if block
                }
                String string = name$iv;
                VirtualFile $this$findFileOrDirectory_u24lambda_u241 = virtualFile$iv;
                boolean bl = false;
                if ($this$findFileOrDirectory_u24lambda_u241.findChild((String)name) != null) continue;
                return null;
            }
        }
        return virtualFile$iv;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFile(@NotNull VirtualFile $this$findFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = ProjectFileUtilKt.findFileOrDirectory($this$findFile, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (!ProjectFileUtilKt.isFile(file)) {
            throw new IOException(StringsKt.trimMargin$default((String)("\n      |Expected file instead of directory: " + file + "\n      |  basePath = " + $this$findFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null));
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getResolvedVirtualFile(VirtualFile $this$getResolvedVirtualFile, String relativePath, Function3<? super VirtualFile, ? super String, ? super Boolean, ? extends VirtualFile> getChild) {
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = ProjectFileUtilKt.relativizeToClosestAncestor($this$getResolvedVirtualFile, relativePath);
        VirtualFile baseVirtualFile = (VirtualFile)pair.component1();
        Path normalizedRelativePath = (Path)pair.component2();
        VirtualFile virtualFile = baseVirtualFile;
        if (((CharSequence)((Object)normalizedRelativePath).toString()).length() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = normalizedRelativePath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(it.toString());
            }
            List names = (List)destination$iv$iv;
            Iterator iterator = ((Iterable)names).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                String name = (String)iterator.next();
                if (!virtualFile.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default((String)("\n          |Expected directory instead of file: " + virtualFile + "\n          |  basePath = " + $this$getResolvedVirtualFile.getPath() + "\n          |  relativePath = " + relativePath + "\n        "), null, (int)1, null));
                }
                virtualFile = (VirtualFile)getChild.invoke((Object)virtualFile, (Object)name, (Object)(i == CollectionsKt.getLastIndex((List)names) ? 1 : 0));
            }
        }
        return virtualFile;
    }

    @NotNull
    public static final Pair<Path, Path> relativizeToClosestAncestor(@NotNull Path $this$relativizeToClosestAncestor, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$relativizeToClosestAncestor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalizedPath = ProjectFileUtilKt.getResolvedPath($this$relativizeToClosestAncestor, relativePath);
        Path path = ProjectFileUtilKt.findAncestor($this$relativizeToClosestAncestor, normalizedPath);
        if (path == null) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default((String)("\n      |Cannot resolve normalized base path for: " + normalizedPath + "\n      |  basePath = " + $this$relativizeToClosestAncestor + "\n      |  relativePath = " + relativePath + "\n    "), null, (int)1, null);
            throw new IllegalStateException(string.toString());
        }
        Path normalizedBasePath = path;
        Path normalizedRelativePath = normalizedBasePath.relativize(normalizedPath);
        return TuplesKt.to((Object)normalizedBasePath, (Object)normalizedRelativePath);
    }

    @Contract(pure=true)
    @Nullable
    public static final Path findAncestor(@NotNull Path path1, @NotNull Path path2) {
        Path ancestor;
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        for (ancestor = path1; ancestor != null && !path2.startsWith(ancestor); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    private static final Pair<VirtualFile, Path> relativizeToClosestAncestor(VirtualFile $this$relativizeToClosestAncestor, String relativePath) {
        Path basePath = Paths.get($this$relativizeToClosestAncestor.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)basePath);
        Pair<Path, Path> pair = ProjectFileUtilKt.relativizeToClosestAncestor(basePath, relativePath);
        Path normalizedBasePath = (Path)pair.component1();
        Path normalizedRelativePath = (Path)pair.component2();
        Ref.ObjectRef baseVirtualFile = new Ref.ObjectRef();
        baseVirtualFile.element = $this$relativizeToClosestAncestor;
        int n = basePath.getNameCount() - normalizedBasePath.getNameCount();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (((VirtualFile)baseVirtualFile.element).getParent() == null) {
                Object cfr_ignored_0 = baseVirtualFile.element;
                Ref.ObjectRef objectRef = baseVirtualFile;
                boolean bl2 = false;
                Ref.ObjectRef objectRef2 = objectRef;
                String string = StringsKt.trimMargin$default((String)("\n        |Cannot resolve base virtual file for " + baseVirtualFile.element + "\n        |  basePath = " + $this$relativizeToClosestAncestor.getPath() + "\n        |  relativePath = " + relativePath + "\n      "), null, (int)1, null);
                throw new IllegalStateException(string.toString());
            }
            baseVirtualFile.element = baseVirtualFile.element;
        }
        return TuplesKt.to((Object)baseVirtualFile.element, (Object)normalizedRelativePath);
    }

    @NotNull
    public static final Path getResolvedPath(@NotNull Path $this$getResolvedPath, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getResolvedPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path path = $this$getResolvedPath.resolve(relativePath).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }

    private static final PsiFile isInProject$lambda$0(Project $project, VirtualFile $virtualFile) {
        return PsiManager.getInstance((Project)$project).findFile($virtualFile);
    }
}

