/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.util;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/util/PatchConverter;", "", "<init>", "()V", "getAbsolutePath", "Ljava/io/File;", "baseDir", "relativePath", "", "createChange", "Lcom/intellij/openapi/vcs/changes/Change;", "project", "Lcom/intellij/openapi/project/Project;", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "loadLocalContent", "beforeFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "core"})
@SourceDebugExtension(value={"SMAP\nPatchConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchConverter.kt\ncc/unitmesh/devti/util/PatchConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n11#2:124\n11#2:125\n*S KotlinDebug\n*F\n+ 1 PatchConverter.kt\ncc/unitmesh/devti/util/PatchConverter\n*L\n33#1:124\n43#1:125\n*E\n"})
public final class PatchConverter {
    @NotNull
    public static final PatchConverter INSTANCE = new PatchConverter();

    private PatchConverter() {
    }

    @NotNull
    public final File getAbsolutePath(@NotNull File baseDir, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file = null;
        try {
            file = new File(baseDir, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PatchConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info((Throwable)e);
            file = new File(baseDir, relativePath);
        }
        File file2 = file;
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @NotNull
    public final Change createChange(@NotNull Project project, @NotNull TextFilePatch patch) {
        String string;
        String beforePath;
        String string2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        String basePath = project.getBasePath();
        if (basePath == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PatchConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Project base path is null, using current directory");
        }
        if ((string2 = basePath) == null) {
            string2 = System.getProperty("user.dir");
        }
        File baseDir = new File(string2);
        String string3 = patch.getBeforeName();
        if (string3 == null) {
            string3 = beforePath = "";
        }
        if ((string = patch.getAfterName()) == null) {
            string = "";
        }
        String afterPath = string;
        FileStatus fileStatus = patch.isNewFile() ? FileStatus.ADDED : (patch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
        File before = this.getAbsolutePath(baseDir, beforePath);
        FilePath filePath = VcsUtil.getFilePath((File)before, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath beforeFilePath = filePath;
        File after = this.getAbsolutePath(baseDir, afterPath);
        FilePath filePath2 = VcsUtil.getFilePath((File)after, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath afterFilePath = filePath2;
        ContentRevision beforeRevision = null;
        if (fileStatus != FileStatus.ADDED) {
            beforeRevision = (ContentRevision)new CurrentContentRevision(beforeFilePath){

                public VcsRevisionNumber getRevisionNumber() {
                    return (VcsRevisionNumber)new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                }
            };
        }
        ContentRevision afterRevision = null;
        if (fileStatus != FileStatus.DELETED) {
            afterRevision = (ContentRevision)new CurrentContentRevision(beforeFilePath, afterFilePath, patch){
                final /* synthetic */ FilePath $beforeFilePath;
                final /* synthetic */ FilePath $afterFilePath;
                final /* synthetic */ TextFilePatch $patch;
                {
                    this.$beforeFilePath = $beforeFilePath;
                    this.$afterFilePath = $afterFilePath;
                    this.$patch = $patch;
                    super($beforeFilePath);
                }

                public VcsRevisionNumber getRevisionNumber() {
                    return (VcsRevisionNumber)new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                }

                public VirtualFile getVirtualFile() {
                    return this.$afterFilePath.getVirtualFile();
                }

                public FilePath getFile() {
                    return this.$afterFilePath;
                }

                public String getContent() {
                    String localContent;
                    GenericPatchApplier.AppliedPatch appliedPatch;
                    if (this.$patch.isNewFile()) {
                        return this.$patch.getSingleHunkPatchText();
                    }
                    if (this.$patch.isDeletedFile()) {
                        return null;
                    }
                    String string = PatchConverter.access$loadLocalContent(PatchConverter.INSTANCE, this.$beforeFilePath);
                    if (string == null) {
                        string = "";
                    }
                    if ((appliedPatch = GenericPatchApplier.apply((CharSequence)(localContent = string), (List)this.$patch.getHunks())) != null) {
                        return appliedPatch.patchedText;
                    }
                    return this.$patch.getSingleHunkPatchText();
                }
            };
        }
        return new Change(beforeRevision, afterRevision, fileStatus);
    }

    private final String loadLocalContent(FilePath beforeFilePath) throws VcsException {
        return (String)ReadAction.compute(() -> PatchConverter.loadLocalContent$lambda$0(beforeFilePath));
    }

    private static final String loadLocalContent$lambda$0(FilePath $beforeFilePath) {
        VirtualFile file = $beforeFilePath.getVirtualFile();
        if (file == null) {
            return null;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc == null) {
            return null;
        }
        return doc.getText();
    }

    public static final /* synthetic */ String access$loadLocalContent(PatchConverter $this, FilePath beforeFilePath) {
        return $this.loadLocalContent(beforeFilePath);
    }
}

