/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.util;

import cc.unitmesh.devti.AutoDevBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/util/InsertUtil;", "", "<init>", "()V", "insertStringAndSaveChange", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "", "document", "Lcom/intellij/openapi/editor/Document;", "startOffset", "", "withReformat", "", "insertStreamingToDoc", "char", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentOffset", "replaceText", "element", "Lcom/intellij/psi/PsiElement;", "output", "core"})
public final class InsertUtil {
    @NotNull
    public static final InsertUtil INSTANCE = new InsertUtil();

    private InsertUtil() {
    }

    public final void insertStringAndSaveChange(@NotNull Project project, @NotNull String content, @NotNull Document document, int startOffset, boolean withReformat) {
        block2: {
            PsiFile psiFile2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            if (startOffset < 0 || startOffset > document.getTextLength()) {
                return;
            }
            document.insertString(startOffset, (CharSequence)content);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            if (!withReformat) {
                return;
            }
            PsiFile psiFile3 = psiFile2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile3 == null) break block2;
            PsiFile file = psiFile3;
            boolean bl = false;
            TextRange reformatRange = new TextRange(startOffset, startOffset + content.length());
            CodeStyleManager.getInstance((Project)project).reformatText(file, (Collection)CollectionsKt.listOf((Object)reformatRange));
        }
    }

    public final void insertStreamingToDoc(@NotNull Project project, @NotNull String string, @NotNull Editor editor, int currentOffset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)string, (String)"char");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        WriteCommandAction.runWriteCommandAction((Project)project, (String)AutoDevBundle.message("intentions.chat.code.complete.name", new Object[0]), (String)"intentions.write.action", () -> InsertUtil.insertStreamingToDoc$lambda$1(project, string, editor, currentOffset), (PsiFile[])new PsiFile[0]);
        editor.getCaretModel().moveToOffset(currentOffset + string.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public final void replaceText(@NotNull Project project, @NotNull Editor editor, @Nullable PsiElement element, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret primaryCaret = caret;
        int start2 = ((Number)ActionsKt.runReadAction(() -> InsertUtil.replaceText$lambda$2(primaryCaret))).intValue();
        int end = ((Number)ActionsKt.runReadAction(() -> InsertUtil.replaceText$lambda$3(primaryCaret))).intValue();
        Object object = ActionsKt.runReadAction(() -> InsertUtil.replaceText$lambda$4(editor));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Document document = (Document)object;
        WriteCommandAction.runWriteCommandAction((Project)project, () -> InsertUtil.replaceText$lambda$5(document, start2, end, output));
    }

    private static final void insertStreamingToDoc$lambda$1(Project $project, String $char, Editor $editor, int $currentOffset) {
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        INSTANCE.insertStringAndSaveChange($project, $char, document, $currentOffset, false);
    }

    private static final int replaceText$lambda$2(Caret $primaryCaret) {
        return $primaryCaret.getSelectionStart();
    }

    private static final int replaceText$lambda$3(Caret $primaryCaret) {
        return $primaryCaret.getSelectionEnd();
    }

    private static final Document replaceText$lambda$4(Editor $editor) {
        return $editor.getDocument();
    }

    private static final void replaceText$lambda$5(Document $document, int $start, int $end, String $output) {
        $document.replaceString($start, $end, (CharSequence)$output);
    }
}

