/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.template;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.devti.custom.team.TeamPromptsBuilder;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import cc.unitmesh.devti.template.TemplateNotFoundError;
import cc.unitmesh.devti.template.context.EmptyContext;
import cc.unitmesh.devti.template.context.TemplateContext;
import cc.unitmesh.template.TemplateRoleSplitter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0003J\u001a\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0001J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcc/unitmesh/devti/template/TemplateRender;", "", "pathPrefix", "", "<init>", "(Ljava/lang/String;)V", "velocityContext", "Lorg/apache/velocity/VelocityContext;", "splitter", "Lcc/unitmesh/template/TemplateRoleSplitter;", "context", "Lcc/unitmesh/devti/template/context/TemplateContext;", "getContext", "()Lcc/unitmesh/devti/template/context/TemplateContext;", "setContext", "(Lcc/unitmesh/devti/template/context/TemplateContext;)V", "actions", "getActions", "()Ljava/lang/Object;", "setActions", "(Ljava/lang/Object;)V", "getTemplate", "filename", "templateCache", "", "retrieveDefaultTemplate", "getDefaultFilePath", "buildMsgs", "", "Lcc/unitmesh/cf/core/llms/LlmMsg$ChatMessage;", "prompt", "renderTemplate", "template", "customContext", "addVariable", "", "key", "value", "core"})
@SourceDebugExtension(value={"SMAP\nTemplateRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateRender.kt\ncc/unitmesh/devti/template/TemplateRender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1549#2:129\n1620#2,3:130\n*S KotlinDebug\n*F\n+ 1 TemplateRender.kt\ncc/unitmesh/devti/template/TemplateRender\n*L\n91#1:129\n91#1:130,3\n*E\n"})
public final class TemplateRender {
    @NotNull
    private final String pathPrefix;
    @NotNull
    private final VelocityContext velocityContext;
    @NotNull
    private final TemplateRoleSplitter splitter;
    @NotNull
    private TemplateContext context;
    @NotNull
    private Object actions;
    @NotNull
    private final Map<String, String> templateCache;

    public TemplateRender(@NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        this.pathPrefix = pathPrefix;
        this.velocityContext = new VelocityContext();
        this.splitter = new TemplateRoleSplitter();
        this.context = new EmptyContext();
        this.actions = "";
        this.templateCache = new LinkedHashMap();
    }

    @NotNull
    public final TemplateContext getContext() {
        return this.context;
    }

    public final void setContext(@NotNull TemplateContext templateContext) {
        Intrinsics.checkNotNullParameter((Object)templateContext, (String)"<set-?>");
        this.context = templateContext;
    }

    @NotNull
    public final Object getActions() {
        return this.actions;
    }

    public final void setActions(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.actions = object;
    }

    @NotNull
    public final String getTemplate(@NotNull String filename) {
        String overrideTemplate;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project != null) {
            Project it = project;
            boolean bl = false;
            string2 = new TeamPromptsBuilder(it).overrideTemplate(this.pathPrefix, filename);
        } else {
            string2 = null;
        }
        if ((string = (overrideTemplate = string2)) == null) {
            string = this.retrieveDefaultTemplate(filename);
        }
        return string;
    }

    private final String retrieveDefaultTemplate(String filename) {
        if (this.templateCache.containsKey(filename)) {
            String string = this.templateCache.get(filename);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String path = this.getDefaultFilePath(filename);
        URL uRL = this.getClass().getClassLoader().getResource(path);
        if (uRL == null) {
            throw new TemplateNotFoundError(path);
        }
        URL resourceUrl = uRL;
        byte[] bytes = TextStreamsKt.readBytes((URL)resourceUrl);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        String string = new String(bytes, charset2);
        this.templateCache.put(filename, string);
        return string;
    }

    private final String getDefaultFilePath(String filename) {
        char[] cArray = new char[]{'/'};
        String languagePrefix = StringsKt.trimEnd((String)("genius/" + AutoDevSettingsState.Companion.getLanguage() + this.pathPrefix), (char[])cArray);
        String path = languagePrefix + "/" + filename;
        if (this.getClass().getClassLoader().getResource(path) != null) {
            return path;
        }
        char[] cArray2 = new char[]{'/'};
        String defaultLanguagePrefix = StringsKt.trimEnd((String)("genius/en/" + this.pathPrefix), (char[])cArray2);
        return defaultLanguagePrefix + "/" + filename;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LlmMsg.ChatMessage> buildMsgs(@NotNull String prompt2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Map msgs = this.splitter.split(prompt2);
        List messages = CollectionsKt.toMutableList((Collection)LlmMsg.Companion.fromMap(msgs));
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TemplateRender.class.getClassLoader());
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LlmMsg.ChatMessage chatMessage = (LlmMsg.ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.velocityContext.put("context", (Object)this.context);
            StringWriter sw = new StringWriter();
            Velocity.evaluate((Context)((Context)this.velocityContext), (Writer)sw, (String)("#" + this.getClass().getName()), (String)it.getContent());
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            it.setContent(string);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        return messages;
    }

    @NotNull
    public final String renderTemplate(@NotNull String template, @Nullable Object customContext) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TemplateRender.class.getClassLoader());
        Object object = customContext != null ? this.velocityContext.put("context", customContext) : this.velocityContext.put("context", (Object)this.context);
        StringWriter sw = new StringWriter();
        Velocity.evaluate((Context)((Context)this.velocityContext), (Writer)sw, (String)("#" + this.getClass().getName()), (String)template);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        return result;
    }

    public static /* synthetic */ String renderTemplate$default(TemplateRender templateRender, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return templateRender.renderTemplate(string, object);
    }

    public final void addVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.velocityContext.put(key, (Object)value);
    }
}

