/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.plan;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevColors;
import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.gui.AutoDevToolWindowFactory;
import cc.unitmesh.devti.gui.chat.ChatCodingService;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.observer.plan.AgentPlanStep;
import cc.unitmesh.devti.observer.plan.CodeFileLink;
import cc.unitmesh.devti.observer.plan.TaskStatus;
import cc.unitmesh.devti.sketch.SketchToolWindow;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0002J\u0012\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcc/unitmesh/devti/sketch/ui/plan/TaskStepPanel;", "Lcom/intellij/ui/components/JBPanel;", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcc/unitmesh/devti/observer/plan/AgentPlanStep;", "onStatusChange", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/observer/plan/AgentPlanStep;Lkotlin/jvm/functions/Function0;)V", "taskLabel", "Ljavax/swing/JTextPane;", "doc", "Ljavax/swing/text/StyledDocument;", "linkMap", "", "Lkotlin/ranges/IntRange;", "", "statusLabel", "Ljavax/swing/JLabel;", "MAX_TEXT_LENGTH", "", "createStatusIcon", "Ljavax/swing/JComponent;", "createTaskTextPane", "updateTaskLabel", "getStyleForStatus", "Ljavax/swing/text/AttributeSet;", "status", "Lcc/unitmesh/devti/observer/plan/TaskStatus;", "setupContextMenu", "executeTask", "isRerun", "", "updateStatusLabel", "refreshPanel", "getStatusText", "getStatusColor", "Lcom/intellij/ui/JBColor;", "core"})
@SourceDebugExtension(value={"SMAP\nTaskStepPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskStepPanel.kt\ncc/unitmesh/devti/sketch/ui/plan/TaskStepPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,375:1\n1855#2,2:376\n215#3,2:378\n*S KotlinDebug\n*F\n+ 1 TaskStepPanel.kt\ncc/unitmesh/devti/sketch/ui/plan/TaskStepPanel\n*L\n200#1:376,2\n266#1:378,2\n*E\n"})
public final class TaskStepPanel
extends JBPanel<TaskStepPanel> {
    @NotNull
    private final Project project;
    @NotNull
    private final AgentPlanStep task;
    @NotNull
    private final Function0<Unit> onStatusChange;
    @NotNull
    private final JTextPane taskLabel;
    @NotNull
    private final StyledDocument doc;
    @NotNull
    private final Map<IntRange, String> linkMap;
    @Nullable
    private JLabel statusLabel;
    private final int MAX_TEXT_LENGTH;

    /*
     * WARNING - void declaration
     */
    public TaskStepPanel(@NotNull Project project, @NotNull AgentPlanStep task2, @NotNull Function0<Unit> onStatusChange) {
        void $this$_init__u24lambda_u243;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(onStatusChange, (String)"onStatusChange");
        this.project = project;
        this.task = task2;
        this.onStatusChange = onStatusChange;
        this.linkMap = new LinkedHashMap();
        this.MAX_TEXT_LENGTH = 100;
        this.setLayout(new BorderLayout());
        this.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        this.setBorder((Border)JBUI.Borders.empty((int)3, (int)2));
        JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel(new FlowLayout(0, 2, 0));
        boolean bl = false;
        $this$_init__u24lambda_u240.setOpaque(false);
        JPanel leftPanel = jPanel;
        JComponent statusIcon = this.createStatusIcon();
        leftPanel.add(statusIcon);
        this.taskLabel = this.createTaskTextPane();
        StyledDocument styledDocument = this.taskLabel.getStyledDocument();
        Intrinsics.checkNotNullExpressionValue((Object)styledDocument, (String)"getStyledDocument(...)");
        this.doc = styledDocument;
        this.updateTaskLabel();
        JComponent $this$_init__u24lambda_u241 = bl = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$_init__u24lambda_u241.add((Component)this.taskLabel, "Center");
        JPanel centerPanel = bl;
        JPanel $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241 = new JPanel(new FlowLayout(2, 2, 0));
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setOpaque(false);
        JPanel rightPanel = $this$_init__u24lambda_u241;
        $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241 = new JLabel(this.getStatusText(this.task.getStatus()));
        TaskStepPanel taskStepPanel = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u243.setForeground((Color)this.getStatusColor(this.task.getStatus()));
        $this$_init__u24lambda_u243.setFont($this$_init__u24lambda_u243.getFont().deriveFont(0, 9.0f));
        $this$_init__u24lambda_u243.setBorder((Border)JBUI.Borders.empty((int)1, (int)3));
        taskStepPanel.statusLabel = $this$_init__u24lambda_u241;
        rightPanel.add(this.statusLabel);
        if (this.task.getStatus() == TaskStatus.TODO) {
            JButton $this$_init__u24lambda_u245 = var9_11 = new JButton(AutoDevIcons.RUN);
            boolean bl5 = false;
            $this$_init__u24lambda_u245.setPreferredSize(new Dimension(20, 20));
            $this$_init__u24lambda_u245.setMargin((Insets)JBUI.emptyInsets());
            $this$_init__u24lambda_u245.setBorderPainted(false);
            $this$_init__u24lambda_u245.setContentAreaFilled(false);
            $this$_init__u24lambda_u245.setToolTipText("Execute this step");
            $this$_init__u24lambda_u245.addActionListener(arg_0 -> TaskStepPanel.lambda$5$lambda$4(this, arg_0));
            JButton executeButton = var9_11;
            rightPanel.add(executeButton);
        } else if (this.task.getStatus() == TaskStatus.FAILED) {
            JButton $this$_init__u24lambda_u247 = var9_11 = new JButton(AutoDevIcons.RERUN);
            boolean bl6 = false;
            $this$_init__u24lambda_u247.setPreferredSize(new Dimension(24, 24));
            $this$_init__u24lambda_u247.setMargin((Insets)JBUI.emptyInsets());
            $this$_init__u24lambda_u247.setBorderPainted(false);
            $this$_init__u24lambda_u247.setContentAreaFilled(false);
            $this$_init__u24lambda_u247.setToolTipText("Rerun");
            $this$_init__u24lambda_u247.addActionListener(arg_0 -> TaskStepPanel.lambda$7$lambda$6(this, arg_0));
            JButton retryButton = var9_11;
            rightPanel.add(retryButton);
        }
        this.add(leftPanel, "West");
        this.add(centerPanel, "Center");
        this.add(rightPanel, "East");
        this.setupContextMenu();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, Math.min(this.getPreferredSize().height, 28)));
    }

    private final JComponent createStatusIcon() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.task.getStatus().ordinal()]) {
            case 1 -> {
                JLabel var1_1;
                JLabel $this$createStatusIcon_u24lambda_u248 = var1_1 = new JLabel(AutoDevIcons.CHECKED);
                boolean $i$a$-apply-TaskStepPanel$createStatusIcon$1 = false;
                $this$createStatusIcon_u24lambda_u248.setPreferredSize(new Dimension(20, 16));
                $this$createStatusIcon_u24lambda_u248.setBorder((Border)JBUI.Borders.empty());
                yield var1_1;
            }
            case 2 -> {
                JLabel var1_2;
                JLabel $this$createStatusIcon_u24lambda_u249 = var1_2 = new JLabel(AutoDevIcons.ERROR);
                boolean $i$a$-apply-TaskStepPanel$createStatusIcon$2 = false;
                $this$createStatusIcon_u24lambda_u249.setPreferredSize(new Dimension(20, 16));
                $this$createStatusIcon_u24lambda_u249.setBorder((Border)JBUI.Borders.empty());
                yield var1_2;
            }
            case 3 -> {
                JLabel var1_3;
                JLabel $this$createStatusIcon_u24lambda_u2410 = var1_3 = new JLabel(AutoDevIcons.BUILD);
                boolean $i$a$-apply-TaskStepPanel$createStatusIcon$3 = false;
                $this$createStatusIcon_u24lambda_u2410.setPreferredSize(new Dimension(20, 16));
                $this$createStatusIcon_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty());
                yield var1_3;
            }
            case 4 -> {
                JCheckBox var1_4;
                JCheckBox $this$createStatusIcon_u24lambda_u2412 = var1_4 = new JCheckBox();
                boolean $i$a$-apply-TaskStepPanel$createStatusIcon$4 = false;
                $this$createStatusIcon_u24lambda_u2412.setBorder((Border)JBUI.Borders.empty());
                $this$createStatusIcon_u24lambda_u2412.setPreferredSize(new Dimension(20, 16));
                $this$createStatusIcon_u24lambda_u2412.setSelected(this.task.getCompleted());
                $this$createStatusIcon_u24lambda_u2412.addActionListener(arg_0 -> TaskStepPanel.createStatusIcon$lambda$12$lambda$11(this, $this$createStatusIcon_u24lambda_u2412, arg_0));
                $this$createStatusIcon_u24lambda_u2412.setBorderPainted(false);
                $this$createStatusIcon_u24lambda_u2412.setContentAreaFilled(false);
                yield var1_4;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final JTextPane createTaskTextPane() {
        JTextPane jTextPane;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme editorColorsScheme = editorColorsManager.getSchemeForCurrentUITheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getSchemeForCurrentUITheme(...)");
        EditorColorsScheme currentScheme = editorColorsScheme;
        String editorFontName = currentScheme.getEditorFontName();
        int editorFontSize = currentScheme.getEditorFontSize() - 1;
        JTextPane $this$createTaskTextPane_u24lambda_u2413 = jTextPane = new JTextPane();
        boolean bl = false;
        $this$createTaskTextPane_u24lambda_u2413.setEditable(false);
        $this$createTaskTextPane_u24lambda_u2413.setOpaque(false);
        $this$createTaskTextPane_u24lambda_u2413.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        $this$createTaskTextPane_u24lambda_u2413.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
        $this$createTaskTextPane_u24lambda_u2413.setFont(new Font(editorFontName, 0, editorFontSize));
        $this$createTaskTextPane_u24lambda_u2413.setForeground(UIUtil.getLabelForeground());
        $this$createTaskTextPane_u24lambda_u2413.addMouseListener(new MouseAdapter($this$createTaskTextPane_u24lambda_u2413, this){
            final /* synthetic */ JTextPane $this_apply;
            final /* synthetic */ TaskStepPanel this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int offset = this.$this_apply.viewToModel2D(e.getPoint());
                for (Map.Entry<K, V> entry : TaskStepPanel.access$getLinkMap$p(this.this$0).entrySet()) {
                    IntRange range = (IntRange)entry.getKey();
                    String filePath = (String)entry.getValue();
                    int n = range.getFirst();
                    boolean bl = offset <= range.getLast() ? n <= offset : false;
                    if (!bl) continue;
                    String realPath = TaskStepPanel.access$getProject$p(this.this$0).getBasePath() + "/" + filePath;
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(realPath);
                    if (virtualFile == null) break;
                    FileEditorManager.getInstance((Project)TaskStepPanel.access$getProject$p(this.this$0)).openFile(virtualFile, true);
                    break;
                }
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.setCursor(new Cursor(0));
            }
        });
        return jTextPane;
    }

    private final void updateTaskLabel() {
        boolean needsTruncation;
        this.doc.remove(0, this.doc.getLength());
        this.linkMap.clear();
        Object text = null;
        text = this.task.getStep();
        int currentPos = 0;
        this.taskLabel.setToolTipText((String)text);
        boolean bl = needsTruncation = ((String)text).length() > this.MAX_TEXT_LENGTH && this.task.getCodeFileLinks().isEmpty();
        if (needsTruncation && this.task.getCodeFileLinks().isEmpty()) {
            String truncatedText = StringsKt.take((String)text, (int)this.MAX_TEXT_LENGTH) + "...";
            this.doc.insertString(0, truncatedText, this.getStyleForStatus(this.task.getStatus()));
            return;
        }
        Iterable $this$forEach$iv = this.task.getCodeFileLinks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleAttributeSet simpleAttributeSet;
            String beforeLink;
            CodeFileLink link = (CodeFileLink)element$iv;
            boolean bl2 = false;
            String linkPattern = "[" + link.getDisplayText() + "](" + link.getFilePath() + ")";
            int linkIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)text), (String)linkPattern, (int)0, (boolean)false, (int)6, null);
            if (linkIndex < 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((String)text).substring(0, linkIndex), (String)"substring(...)");
            this.doc.insertString(currentPos, beforeLink, this.getStyleForStatus(this.task.getStatus()));
            currentPos += beforeLink.length();
            SimpleAttributeSet $this$updateTaskLabel_u24lambda_u2415_u24lambda_u2414 = simpleAttributeSet = new SimpleAttributeSet();
            boolean bl3 = false;
            StyleConstants.setForeground($this$updateTaskLabel_u24lambda_u2415_u24lambda_u2414, (Color)AutoDevColors.INSTANCE.getLINK_COLOR());
            StyleConstants.setUnderline($this$updateTaskLabel_u24lambda_u2415_u24lambda_u2414, true);
            SimpleAttributeSet linkStyle = simpleAttributeSet;
            this.doc.insertString(currentPos, link.getDisplayText(), linkStyle);
            this.linkMap.put(new IntRange(currentPos, currentPos + link.getDisplayText().length()), link.getFilePath());
            currentPos += link.getDisplayText().length();
            Intrinsics.checkNotNullExpressionValue((Object)((String)text).substring(linkIndex + linkPattern.length()), (String)"substring(...)");
        }
        if (((CharSequence)text).length() > 0) {
            if (((String)text).length() > this.MAX_TEXT_LENGTH) {
                text = StringsKt.take((String)text, (int)this.MAX_TEXT_LENGTH) + "...";
            }
            this.doc.insertString(currentPos, (String)text, this.getStyleForStatus(this.task.getStatus()));
        }
    }

    private final AttributeSet getStyleForStatus(TaskStatus status) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                StyleConstants.setStrikeThrough(style, true);
                StyleConstants.setForeground(style, (Color)AutoDevColors.INSTANCE.getCOMPLETED_TEXT());
                break;
            }
            case 2: {
                StyleConstants.setForeground(style, (Color)AutoDevColors.INSTANCE.getFAILED_TEXT());
                break;
            }
            case 3: {
                StyleConstants.setForeground(style, (Color)AutoDevColors.INSTANCE.getIN_PROGRESS_TEXT());
                StyleConstants.setItalic(style, true);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return style;
    }

    private final void setupContextMenu() {
        Map statusMenuItems;
        JPopupMenu taskPopupMenu = new JPopupMenu();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Mark as Completed [\u2713]", (Object)((Object)TaskStatus.COMPLETED)), TuplesKt.to((Object)"Mark as In Progress [*]", (Object)((Object)TaskStatus.IN_PROGRESS)), TuplesKt.to((Object)"Mark as Failed [!]", (Object)((Object)TaskStatus.FAILED)), TuplesKt.to((Object)"Mark as Todo [ ]", (Object)((Object)TaskStatus.TODO))};
        Map $this$forEach$iv = statusMenuItems = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String label = (String)entry.getKey();
            TaskStatus status = (TaskStatus)((Object)entry.getValue());
            JMenuItem menuItem = new JMenuItem(label);
            menuItem.addActionListener(arg_0 -> TaskStepPanel.setupContextMenu$lambda$17$lambda$16(this, status, arg_0));
            taskPopupMenu.add(menuItem);
        }
        this.taskLabel.setComponentPopupMenu(taskPopupMenu);
    }

    private final void executeTask(boolean isRerun) {
        AgentPlanStep.updateStatus$default(this.task, TaskStatus.IN_PROGRESS, false, 2, null);
        this.updateTaskLabel();
        this.updateStatusLabel();
        this.onStatusChange.invoke();
        String message = isRerun ? AutoDevBundle.message("sketch.plan.rerun.task", new Object[0]) : AutoDevBundle.message("sketch.plan.finish.task", new Object[0]);
        AutoDevToolWindowFactory.Companion.sendToSketchToolWindow(this.project, ChatActionType.SKETCH, (Function2<? super SketchToolWindow, ? super ChatCodingService, Unit>)((Function2)(arg_0, arg_1) -> TaskStepPanel.executeTask$lambda$18(message, this, arg_0, arg_1)));
        this.refreshPanel();
    }

    static /* synthetic */ void executeTask$default(TaskStepPanel taskStepPanel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        taskStepPanel.executeTask(bl);
    }

    private final void updateStatusLabel() {
        block1: {
            JLabel jLabel = this.statusLabel;
            if (jLabel != null) {
                jLabel.setText(this.getStatusText(this.task.getStatus()));
            }
            JLabel jLabel2 = this.statusLabel;
            if (jLabel2 == null) break block1;
            jLabel2.setForeground((Color)this.getStatusColor(this.task.getStatus()));
        }
    }

    private final void refreshPanel() {
        JPanel jPanel;
        JPanel jPanel2;
        this.removeAll();
        JPanel $this$refreshPanel_u24lambda_u2419 = jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        boolean bl = false;
        $this$refreshPanel_u24lambda_u2419.setOpaque(false);
        $this$refreshPanel_u24lambda_u2419.add(this.createStatusIcon());
        JPanel leftPanel = jPanel2;
        JPanel $this$refreshPanel_u24lambda_u2420 = $this$refreshPanel_u24lambda_u2419 = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$refreshPanel_u24lambda_u2420.setOpaque(false);
        $this$refreshPanel_u24lambda_u2420.add((Component)this.taskLabel, "Center");
        JPanel centerPanel = $this$refreshPanel_u24lambda_u2419;
        JPanel $this$refreshPanel_u24lambda_u2425 = jPanel = new JPanel(new FlowLayout(2, 5, 0));
        boolean bl3 = false;
        $this$refreshPanel_u24lambda_u2425.setOpaque(false);
        $this$refreshPanel_u24lambda_u2425.add(this.statusLabel);
        switch (WhenMappings.$EnumSwitchMapping$0[this.task.getStatus().ordinal()]) {
            case 4: {
                JButton jButton;
                JButton $this$refreshPanel_u24lambda_u2425_u24lambda_u2422 = jButton = new JButton(AutoDevIcons.RUN);
                boolean bl4 = false;
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.setPreferredSize(new Dimension(24, 24));
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.setMargin((Insets)JBUI.emptyInsets());
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.setBorderPainted(false);
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.setContentAreaFilled(false);
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.setToolTipText("Execute this step");
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2422.addActionListener(arg_0 -> TaskStepPanel.refreshPanel$lambda$25$lambda$22$lambda$21(this, arg_0));
                JButton executeButton = jButton;
                Object object = $this$refreshPanel_u24lambda_u2425.add(executeButton);
                break;
            }
            case 2: {
                JButton jButton;
                JButton $this$refreshPanel_u24lambda_u2425_u24lambda_u2424 = jButton = new JButton(AutoDevIcons.RERUN);
                boolean bl5 = false;
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.setPreferredSize(new Dimension(24, 24));
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.setMargin((Insets)JBUI.emptyInsets());
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.setBorderPainted(false);
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.setContentAreaFilled(false);
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.setToolTipText("Rerun");
                $this$refreshPanel_u24lambda_u2425_u24lambda_u2424.addActionListener(arg_0 -> TaskStepPanel.refreshPanel$lambda$25$lambda$24$lambda$23(this, arg_0));
                JButton retryButton = jButton;
                Object object = $this$refreshPanel_u24lambda_u2425.add(retryButton);
                break;
            }
            default: {
                Object object = Unit.INSTANCE;
            }
        }
        JPanel rightPanel = jPanel;
        this.add(leftPanel, "West");
        this.add(centerPanel, "Center");
        this.add(rightPanel, "East");
        this.revalidate();
        this.repaint();
    }

    private final String getStatusText(TaskStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> "Completed";
            case 2 -> "Failed";
            case 3 -> "In Progress";
            case 4 -> "To Do";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final JBColor getStatusColor(TaskStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> AutoDevColors.INSTANCE.getCOMPLETED_STATUS();
            case 2 -> AutoDevColors.INSTANCE.getFAILED_STATUS();
            case 3 -> AutoDevColors.INSTANCE.getIN_PROGRESS_STATUS();
            case 4 -> AutoDevColors.INSTANCE.getTODO_STATUS();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void lambda$5$lambda$4(TaskStepPanel this$0, ActionEvent it) {
        TaskStepPanel.executeTask$default(this$0, false, 1, null);
    }

    private static final void lambda$7$lambda$6(TaskStepPanel this$0, ActionEvent it) {
        this$0.executeTask(true);
    }

    private static final void createStatusIcon$lambda$12$lambda$11(TaskStepPanel this$0, JCheckBox $this_apply, ActionEvent it) {
        this$0.task.setCompleted($this_apply.isSelected());
        AgentPlanStep.updateStatus$default(this$0.task, $this_apply.isSelected() ? TaskStatus.COMPLETED : TaskStatus.TODO, false, 2, null);
        this$0.updateTaskLabel();
        this$0.updateStatusLabel();
        this$0.onStatusChange.invoke();
    }

    private static final void setupContextMenu$lambda$17$lambda$16(TaskStepPanel this$0, TaskStatus $status, ActionEvent it) {
        AgentPlanStep.updateStatus$default(this$0.task, $status, false, 2, null);
        this$0.updateTaskLabel();
        this$0.updateStatusLabel();
        this$0.onStatusChange.invoke();
        this$0.refreshPanel();
    }

    private static final Unit executeTask$lambda$18(String $message, TaskStepPanel this$0, SketchToolWindow ui, ChatCodingService chatCodingService) {
        Intrinsics.checkNotNullParameter((Object)((Object)ui), (String)"ui");
        Intrinsics.checkNotNullParameter((Object)chatCodingService, (String)"<unused var>");
        ui.sendInput($message + this$0.task.getStep());
        return Unit.INSTANCE;
    }

    private static final void refreshPanel$lambda$25$lambda$22$lambda$21(TaskStepPanel this$0, ActionEvent it) {
        TaskStepPanel.executeTask$default(this$0, false, 1, null);
    }

    private static final void refreshPanel$lambda$25$lambda$24$lambda$23(TaskStepPanel this$0, ActionEvent it) {
        this$0.executeTask(true);
    }

    public static final /* synthetic */ Map access$getLinkMap$p(TaskStepPanel $this) {
        return $this.linkMap;
    }

    public static final /* synthetic */ Project access$getProject$p(TaskStepPanel $this) {
        return $this.project;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskStatus.values().length];
            try {
                nArray[TaskStatus.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.IN_PROGRESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.TODO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

