/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.plan;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevColors;
import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.gui.AutoDevToolWindowFactory;
import cc.unitmesh.devti.gui.chat.ChatCodingService;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.observer.plan.AgentPlanStep;
import cc.unitmesh.devti.observer.plan.AgentTaskEntry;
import cc.unitmesh.devti.observer.plan.TaskStatus;
import cc.unitmesh.devti.sketch.SketchToolWindow;
import cc.unitmesh.devti.sketch.ui.plan.TaskStepPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcc/unitmesh/devti/sketch/ui/plan/TaskSectionPanel;", "Lcom/intellij/ui/components/JBPanel;", "project", "Lcom/intellij/openapi/project/Project;", "index", "", "planItem", "Lcc/unitmesh/devti/observer/plan/AgentTaskEntry;", "onStatusChange", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;ILcc/unitmesh/devti/observer/plan/AgentTaskEntry;Lkotlin/jvm/functions/Function0;)V", "stepsPanel", "isExpanded", "", "expandButton", "Ljavax/swing/JButton;", "statusLabel", "Ljavax/swing/JLabel;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "MAX_TITLE_LENGTH", "createHeaderPanel", "Ljavax/swing/JPanel;", "toggleStepsVisibility", "visible", "refreshStepsPanel", "executeSection", "updateSectionStatus", "updateProgressAndStatus", "getStatusText", "", "status", "Lcc/unitmesh/devti/observer/plan/TaskStatus;", "getStatusColor", "Lcom/intellij/ui/JBColor;", "core"})
@SourceDebugExtension(value={"SMAP\nTaskSectionPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSectionPanel.kt\ncc/unitmesh/devti/sketch/ui/plan/TaskSectionPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1855#2,2:226\n*S KotlinDebug\n*F\n+ 1 TaskSectionPanel.kt\ncc/unitmesh/devti/sketch/ui/plan/TaskSectionPanel\n*L\n164#1:226,2\n*E\n"})
public final class TaskSectionPanel
extends JBPanel<JBPanel<?>> {
    @NotNull
    private final Project project;
    private final int index;
    @NotNull
    private final AgentTaskEntry planItem;
    @NotNull
    private final Function0<Unit> onStatusChange;
    @NotNull
    private final JBPanel<JBPanel<?>> stepsPanel;
    private boolean isExpanded;
    @Nullable
    private JButton expandButton;
    @Nullable
    private JLabel statusLabel;
    @NotNull
    private final JBScrollPane scrollPane;
    private final int MAX_TITLE_LENGTH;

    /*
     * WARNING - void declaration
     */
    public TaskSectionPanel(@NotNull Project project, int index, @NotNull AgentTaskEntry planItem, @NotNull Function0<Unit> onStatusChange) {
        void $this$_init__u24lambda_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)planItem, (String)"planItem");
        Intrinsics.checkNotNullParameter(onStatusChange, (String)"onStatusChange");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.index = index;
        this.planItem = planItem;
        this.onStatusChange = onStatusChange;
        this.stepsPanel = new JBPanel();
        this.isExpanded = true;
        this.MAX_TITLE_LENGTH = 50;
        this.setLayout(new BorderLayout());
        this.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()), (Border)JBUI.Borders.empty((int)4, (int)0)));
        JPanel headerPanel2 = this.createHeaderPanel();
        this.add(headerPanel2, "North");
        this.stepsPanel.setLayout((LayoutManager)new BoxLayout((Container)this.stepsPanel, 1));
        this.stepsPanel.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        this.stepsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.refreshStepsPanel();
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this.stepsPanel);
        TaskSectionPanel taskSectionPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setBorder(BorderFactory.createEmptyBorder());
        $this$_init__u24lambda_u240.setOpaque(false);
        $this$_init__u24lambda_u240.getViewport().setOpaque(false);
        $this$_init__u24lambda_u240.setHorizontalScrollBarPolicy(31);
        $this$_init__u24lambda_u240.setVerticalScrollBarPolicy(20);
        taskSectionPanel.scrollPane = jBScrollPane;
        this.add((Component)this.scrollPane, "Center");
        this.toggleStepsVisibility(this.isExpanded);
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createHeaderPanel() {
        void $this$createHeaderPanel_u24lambda_u247;
        JComponent jComponent;
        JLabel jLabel;
        void $this$createHeaderPanel_u24lambda_u244;
        JBPanel jBPanel = new JBPanel((LayoutManager)new BorderLayout());
        Object $this$createHeaderPanel_u24lambda_u241 = jBPanel;
        boolean bl = false;
        $this$createHeaderPanel_u24lambda_u241.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        $this$createHeaderPanel_u24lambda_u241.setBorder(JBUI.Borders.empty((int)2));
        JBPanel headerPanel2 = jBPanel;
        Object $this$createHeaderPanel_u24lambda_u242 = $this$createHeaderPanel_u24lambda_u241 = new JPanel(new FlowLayout(0, 5, 0));
        boolean bl2 = false;
        ((JComponent)$this$createHeaderPanel_u24lambda_u242).setOpaque(false);
        Object leftPanel = $this$createHeaderPanel_u24lambda_u241;
        $this$createHeaderPanel_u24lambda_u242 = $this$createHeaderPanel_u24lambda_u241 = new JButton(this.isExpanded ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
        TaskSectionPanel taskSectionPanel = this;
        boolean bl3 = false;
        $this$createHeaderPanel_u24lambda_u244.setPreferredSize(new Dimension(20, 20));
        $this$createHeaderPanel_u24lambda_u244.setMargin((Insets)JBUI.emptyInsets());
        $this$createHeaderPanel_u24lambda_u244.setBorderPainted(false);
        $this$createHeaderPanel_u24lambda_u244.setContentAreaFilled(false);
        $this$createHeaderPanel_u24lambda_u244.setToolTipText(this.isExpanded ? "Collapse section" : "Expand section");
        $this$createHeaderPanel_u24lambda_u244.addActionListener(arg_0 -> TaskSectionPanel.createHeaderPanel$lambda$4$lambda$3(this, (JButton)$this$createHeaderPanel_u24lambda_u244, arg_0));
        taskSectionPanel.expandButton = $this$createHeaderPanel_u24lambda_u241;
        ((Container)leftPanel).add(this.expandButton);
        JLabel statusIcon = switch (WhenMappings.$EnumSwitchMapping$0[this.planItem.getStatus().ordinal()]) {
            case 1 -> new JLabel(AutoDevIcons.CHECKED);
            case 2 -> new JLabel(AutoDevIcons.ERROR);
            case 3 -> new JLabel((Icon)AutoDevIcons.LOADING);
            case 4 -> new JLabel(AutoDevIcons.BUILD);
            default -> throw new NoWhenBranchMatchedException();
        };
        ((Container)leftPanel).add(statusIcon);
        String fullTitle = this.index + 1 + ". " + this.planItem.getTitle();
        String displayTitle = this.planItem.getTitle().length() > this.MAX_TITLE_LENGTH ? this.index + 1 + ". " + StringsKt.take((String)this.planItem.getTitle(), (int)this.MAX_TITLE_LENGTH) + "..." : fullTitle;
        JLabel $this$createHeaderPanel_u24lambda_u245 = jLabel = new JLabel(displayTitle);
        boolean bl4 = false;
        $this$createHeaderPanel_u24lambda_u245.setFont($this$createHeaderPanel_u24lambda_u245.getFont().deriveFont(1));
        $this$createHeaderPanel_u24lambda_u245.setToolTipText(fullTitle);
        JLabel titleLabel = jLabel;
        ((Container)leftPanel).add(titleLabel);
        JPanel $this$createHeaderPanel_u24lambda_u246 = jComponent = new JPanel(new FlowLayout(2, 5, 0));
        boolean bl5 = false;
        $this$createHeaderPanel_u24lambda_u246.setOpaque(false);
        JPanel rightPanel = jComponent;
        $this$createHeaderPanel_u24lambda_u246 = jComponent = new JLabel(this.getStatusText(this.planItem.getStatus()));
        taskSectionPanel = this;
        boolean bl6 = false;
        $this$createHeaderPanel_u24lambda_u247.setForeground((Color)this.getStatusColor(this.planItem.getStatus()));
        $this$createHeaderPanel_u24lambda_u247.setFont($this$createHeaderPanel_u24lambda_u247.getFont().deriveFont(1, 11.0f));
        $this$createHeaderPanel_u24lambda_u247.setBorder(JBUI.Borders.empty((int)2));
        $this$createHeaderPanel_u24lambda_u247.setPreferredSize(new Dimension(80, 16));
        taskSectionPanel.statusLabel = jComponent;
        rightPanel.add(this.statusLabel);
        switch (WhenMappings.$EnumSwitchMapping$0[this.planItem.getStatus().ordinal()]) {
            case 4: {
                JButton jButton;
                JButton $this$createHeaderPanel_u24lambda_u249 = jButton = new JButton(AutoDevBundle.message("planner.task.execute", new Object[0]));
                boolean bl7 = false;
                $this$createHeaderPanel_u24lambda_u249.setFont((Font)JBFont.medium());
                $this$createHeaderPanel_u24lambda_u249.addActionListener(arg_0 -> TaskSectionPanel.createHeaderPanel$lambda$9$lambda$8(this, arg_0));
                JButton executeButton = jButton;
                Object object = rightPanel.add(executeButton);
                break;
            }
            case 2: {
                JButton jButton;
                JButton $this$createHeaderPanel_u24lambda_u2411 = jButton = new JButton(AutoDevIcons.REPAIR);
                boolean bl8 = false;
                $this$createHeaderPanel_u24lambda_u2411.setFont((Font)JBFont.medium());
                $this$createHeaderPanel_u24lambda_u2411.addActionListener(arg_0 -> TaskSectionPanel.createHeaderPanel$lambda$11$lambda$10(this, arg_0));
                JButton retryButton = jButton;
                Object object = rightPanel.add(retryButton);
                break;
            }
            default: {
                Object object = Unit.INSTANCE;
            }
        }
        headerPanel2.add((Component)leftPanel, (Object)"West");
        headerPanel2.add((Component)rightPanel, (Object)"East");
        return (JPanel)headerPanel2;
    }

    private final void toggleStepsVisibility(boolean visible) {
        this.scrollPane.setVisible(visible);
        this.stepsPanel.setVisible(visible);
    }

    private final void refreshStepsPanel() {
        this.stepsPanel.removeAll();
        Iterable $this$forEach$iv = this.planItem.getSteps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentPlanStep step = (AgentPlanStep)element$iv;
            boolean bl = false;
            TaskStepPanel taskStepPanel = new TaskStepPanel(this.project, step, (Function0<Unit>)((Function0)() -> TaskSectionPanel.refreshStepsPanel$lambda$13$lambda$12(this)));
            this.stepsPanel.add((Component)((Object)taskStepPanel));
            this.stepsPanel.add(Box.createVerticalStrut(2));
        }
    }

    private final void executeSection() {
        this.planItem.updateStatus(TaskStatus.IN_PROGRESS);
        this.updateProgressAndStatus();
        AutoDevToolWindowFactory.Companion.sendToSketchToolWindow(this.project, ChatActionType.SKETCH, (Function2<? super SketchToolWindow, ? super ChatCodingService, Unit>)((Function2)(arg_0, arg_1) -> TaskSectionPanel.executeSection$lambda$15(this, arg_0, arg_1)));
        this.refreshStepsPanel();
        this.revalidate();
        this.repaint();
    }

    public final void updateSectionStatus() {
        this.planItem.updateCompletionStatus();
        this.updateProgressAndStatus();
    }

    private final void updateProgressAndStatus() {
        JLabel jLabel = this.statusLabel;
        if (jLabel != null) {
            jLabel.setText(this.getStatusText(this.planItem.getStatus()));
        }
        JLabel jLabel2 = this.statusLabel;
        if (jLabel2 != null) {
            jLabel2.setForeground((Color)this.getStatusColor(this.planItem.getStatus()));
        }
        this.removeAll();
        this.add(this.createHeaderPanel(), "North");
        this.add((Component)this.stepsPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    private final String getStatusText(TaskStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> AutoDevBundle.message("planner.task.status.completed", new Object[0]);
            case 2 -> AutoDevBundle.message("planner.task.status.failed", new Object[0]);
            case 3 -> AutoDevBundle.message("planner.task.status.in_progress", new Object[0]);
            case 4 -> AutoDevBundle.message("planner.task.status.todo", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final JBColor getStatusColor(TaskStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> AutoDevColors.INSTANCE.getCOMPLETED_STATUS();
            case 2 -> AutoDevColors.INSTANCE.getFAILED_STATUS();
            case 3 -> AutoDevColors.INSTANCE.getIN_PROGRESS_STATUS();
            case 4 -> AutoDevColors.INSTANCE.getTODO_STATUS();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void createHeaderPanel$lambda$4$lambda$3(TaskSectionPanel this$0, JButton $this_apply, ActionEvent e) {
        this$0.isExpanded = !this$0.isExpanded;
        $this_apply.setIcon(this$0.isExpanded ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
        $this_apply.setToolTipText(this$0.isExpanded ? "Collapse section" : "Expand section");
        this$0.toggleStepsVisibility(this$0.isExpanded);
        e.setSource($this_apply);
    }

    private static final void createHeaderPanel$lambda$9$lambda$8(TaskSectionPanel this$0, ActionEvent it) {
        this$0.executeSection();
    }

    private static final void createHeaderPanel$lambda$11$lambda$10(TaskSectionPanel this$0, ActionEvent it) {
        this$0.executeSection();
    }

    private static final Unit refreshStepsPanel$lambda$13$lambda$12(TaskSectionPanel this$0) {
        this$0.updateSectionStatus();
        this$0.updateProgressAndStatus();
        this$0.onStatusChange.invoke();
        return Unit.INSTANCE;
    }

    private static final CharSequence executeSection$lambda$15$lambda$14(AgentPlanStep it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "   - " + it.getStep();
    }

    private static final Unit executeSection$lambda$15(TaskSectionPanel this$0, SketchToolWindow ui, ChatCodingService chatCodingService) {
        Intrinsics.checkNotNullParameter((Object)((Object)ui), (String)"ui");
        Intrinsics.checkNotNullParameter((Object)chatCodingService, (String)"<unused var>");
        String content = this$0.planItem.getTitle() + "\n" + CollectionsKt.joinToString$default((Iterable)this$0.planItem.getSteps(), (CharSequence)"\n", null, null, (int)0, null, TaskSectionPanel::executeSection$lambda$15$lambda$14, (int)30, null);
        ui.sendInput(AutoDevBundle.message("sketch.plan.finish.task", new Object[0]) + content);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskStatus.values().length];
            try {
                nArray[TaskStatus.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.IN_PROGRESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskStatus.TODO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

