/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.plan;

import cc.unitmesh.devti.gui.AutoDevPlannerToolWindowFactory;
import cc.unitmesh.devti.gui.planner.AutoDevPlannerToolWindow;
import cc.unitmesh.devti.observer.agent.AgentStateService;
import cc.unitmesh.devti.observer.plan.AgentPlanStep;
import cc.unitmesh.devti.observer.plan.AgentTaskEntry;
import cc.unitmesh.devti.observer.plan.MarkdownPlanParser;
import cc.unitmesh.devti.sketch.ui.ExtensionLangSketch;
import cc.unitmesh.devti.sketch.ui.plan.PlanToolbarFactory;
import cc.unitmesh.devti.sketch.ui.plan.TaskSectionPanel;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u001eH\u0002J\u0006\u0010&\u001a\u00020\u001eJ\u0006\u0010'\u001a\u00020\u001eJ\b\u0010(\u001a\u00020\u001eH\u0002J\u0014\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+J\u0006\u0010,\u001a\u00020\u001eJ\b\u0010-\u001a\u00020\u0006H\u0016J\b\u0010.\u001a\u00020\u0006H\u0016J\u0018\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u000bH\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\u001eH\u0002J\b\u00105\u001a\u00020#H\u0016J\b\u00106\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcc/unitmesh/devti/sketch/ui/plan/PlanLangSketch;", "Lcom/intellij/ui/components/JBPanel;", "Lcc/unitmesh/devti/sketch/ui/ExtensionLangSketch;", "project", "Lcom/intellij/openapi/project/Project;", "content", "", "agentTaskItems", "", "Lcc/unitmesh/devti/observer/plan/AgentTaskEntry;", "isInToolwindow", "", "autoPinEnabled", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;ZZ)V", "contentPanel", "Ljavax/swing/JPanel;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "setScrollPane", "(Lcom/intellij/ui/components/JBScrollPane;)V", "toolbarFactory", "Lcc/unitmesh/devti/sketch/ui/plan/PlanToolbarFactory;", "hasUpdated", "isCompressed", "compressedPanel", "fullContentPanel", "setupUI", "", "setupCompressedPanel", "setupFullContentPanel", "addCompressButtonToToolbar", "toolbar", "Ljavax/swing/JComponent;", "showFullContent", "showCompressedContent", "toggleCompression", "renderPlan", "updateCompressedPanelInfo", "updatePlan", "newPlanItems", "", "savePlanToService", "getExtensionName", "getViewText", "updateViewText", "text", "complete", "onComplete", "code", "autoPinToToolWindow", "getComponent", "dispose", "core"})
@SourceDebugExtension(value={"SMAP\nPlanLangSketch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanLangSketch.kt\ncc/unitmesh/devti/sketch/ui/plan/PlanLangSketch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,292:1\n1#2:293\n1864#3,3:294\n1855#3:308\n1855#3,2:309\n1856#3:311\n1855#3,2:312\n4098#4,11:297\n4098#4,11:314\n*S KotlinDebug\n*F\n+ 1 PlanLangSketch.kt\ncc/unitmesh/devti/sketch/ui/plan/PlanLangSketch\n*L\n184#1:294,3\n224#1:308\n225#1:309,2\n224#1:311\n232#1:312,2\n205#1:297,11\n276#1:314,11\n*E\n"})
public final class PlanLangSketch
extends JBPanel<PlanLangSketch>
implements ExtensionLangSketch {
    @NotNull
    private final Project project;
    @NotNull
    private String content;
    @NotNull
    private List<AgentTaskEntry> agentTaskItems;
    private final boolean isInToolwindow;
    private final boolean autoPinEnabled;
    @NotNull
    private final JPanel contentPanel;
    @Nullable
    private JBScrollPane scrollPane;
    @NotNull
    private final PlanToolbarFactory toolbarFactory;
    private boolean hasUpdated;
    private boolean isCompressed;
    @Nullable
    private JPanel compressedPanel;
    @Nullable
    private JPanel fullContentPanel;

    public PlanLangSketch(@NotNull Project project, @NotNull String content, @NotNull List<AgentTaskEntry> agentTaskItems, boolean isInToolwindow, boolean autoPinEnabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(agentTaskItems, (String)"agentTaskItems");
        super((LayoutManager)new BorderLayout(JBUI.scale((int)0), 0));
        this.project = project;
        this.content = content;
        this.agentTaskItems = agentTaskItems;
        this.isInToolwindow = isInToolwindow;
        this.autoPinEnabled = autoPinEnabled;
        this.contentPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)0)));
        this.toolbarFactory = new PlanToolbarFactory(this.project);
        this.setupUI();
        this.renderPlan();
        if (this.autoPinEnabled && !this.isInToolwindow) {
            this.showCompressedContent();
            SwingUtilities.invokeLater(() -> PlanLangSketch._init_$lambda$0(this));
        }
    }

    public /* synthetic */ PlanLangSketch(Project project, String string, List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(project, string, list, bl, bl2);
    }

    @Nullable
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final void setScrollPane(@Nullable JBScrollPane jBScrollPane) {
        this.scrollPane = jBScrollPane;
    }

    private final void setupUI() {
        this.setupCompressedPanel();
        this.setupFullContentPanel();
        this.showFullContent();
        this.setMinimumSize(new Dimension(200, 0));
    }

    /*
     * WARNING - void declaration
     */
    private final void setupCompressedPanel() {
        JLabel jLabel;
        JBLabel jBLabel;
        JPanel jPanel;
        void $this$setupCompressedPanel_u24lambda_u245;
        JPanel jPanel2;
        JPanel jPanel3 = jPanel2 = new JPanel(new BorderLayout());
        PlanLangSketch planLangSketch = this;
        boolean bl = false;
        $this$setupCompressedPanel_u24lambda_u245.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        $this$setupCompressedPanel_u24lambda_u245.setBorder(JBUI.Borders.compound((Border)((Border)JBUI.Borders.empty((int)0, (int)4)), (Border)JBUI.Borders.customLine((Color)JBUI.CurrentTheme.ToolWindow.borderColor(), (int)1)));
        JPanel $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244 = jPanel = new JPanel(new FlowLayout(0, 5, 5));
        boolean bl2 = false;
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        JBLabel $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241 = jBLabel = new JBLabel(AllIcons.General.ArrowRight);
        boolean bl3 = false;
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241.setCursor(Cursor.getPredefinedCursor(12));
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241.setToolTipText("Click to expand plan details");
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ PlanLangSketch this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.toggleCompression();
            }
        });
        JBLabel expandIcon2 = jBLabel;
        JBLabel $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u242 = $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241 = new JBLabel(AllIcons.Toolbar.Pin);
        boolean bl4 = false;
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u242.setToolTipText("Plan is pinned to tool window");
        JBLabel pinIcon = $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u241;
        JLabel $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u243 = jLabel = new JLabel();
        boolean bl5 = false;
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u243.setFont($this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u243.getFont().deriveFont($this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u243.getFont().getStyle() | 1));
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244_u24lambda_u243.setText(this.autoPinEnabled ? "Plan pinned (" + this.agentTaskItems.size() + " tasks)" : "Plan (" + this.agentTaskItems.size() + " tasks)");
        JLabel titleLabel = jLabel;
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244.add((Component)expandIcon2);
        if (this.autoPinEnabled) {
            $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244.add((Component)pinIcon);
        }
        $this$setupCompressedPanel_u24lambda_u245_u24lambda_u244.add(titleLabel);
        JPanel titlePanel2 = jPanel;
        $this$setupCompressedPanel_u24lambda_u245.add((Component)titlePanel2, "Center");
        $this$setupCompressedPanel_u24lambda_u245.setPreferredSize(new Dimension($this$setupCompressedPanel_u24lambda_u245.getPreferredSize().width, 30));
        planLangSketch.compressedPanel = jPanel2;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupFullContentPanel() {
        void $this$setupFullContentPanel_u24lambda_u247;
        Object $this$setupFullContentPanel_u24lambda_u246;
        Object object;
        if (!this.isInToolwindow) {
            JComponent toolbar = this.toolbarFactory.createToolbar((JComponent)((Object)this));
            this.addCompressButtonToToolbar(toolbar);
        }
        JBScrollPane jBScrollPane = object = new JBScrollPane((Component)this.contentPanel);
        PlanLangSketch planLangSketch = this;
        boolean bl = false;
        $this$setupFullContentPanel_u24lambda_u246.setVerticalScrollBarPolicy(22);
        $this$setupFullContentPanel_u24lambda_u246.setHorizontalScrollBarPolicy(31);
        $this$setupFullContentPanel_u24lambda_u246.setBorder((Border)JBUI.Borders.empty());
        $this$setupFullContentPanel_u24lambda_u246.getViewport().setOpaque(false);
        $this$setupFullContentPanel_u24lambda_u246.getViewport().setView(this.contentPanel);
        planLangSketch.scrollPane = object;
        $this$setupFullContentPanel_u24lambda_u246 = object = new JPanel(new BorderLayout());
        planLangSketch = this;
        boolean bl2 = false;
        $this$setupFullContentPanel_u24lambda_u247.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        if (!this.isInToolwindow) {
            JComponent toolbar = this.toolbarFactory.createToolbar((JComponent)((Object)this));
            $this$setupFullContentPanel_u24lambda_u247.add((Component)toolbar, "North");
            $this$setupFullContentPanel_u24lambda_u247.setBorder(JBUI.Borders.compound((Border)((Border)JBUI.Borders.empty((int)0, (int)4)), (Border)JBUI.Borders.customLine((Color)JBUI.CurrentTheme.ToolWindow.borderColor(), (int)1)));
        }
        $this$setupFullContentPanel_u24lambda_u247.add((Component)this.scrollPane, "Center");
        planLangSketch.fullContentPanel = object;
    }

    private final void addCompressButtonToToolbar(JComponent toolbar) {
    }

    private final void showFullContent() {
        this.removeAll();
        JPanel jPanel = this.fullContentPanel;
        if (jPanel != null) {
            JPanel it = jPanel;
            boolean bl = false;
            this.add(it, "Center");
        }
        this.isCompressed = false;
        this.revalidate();
        this.repaint();
    }

    private final void showCompressedContent() {
        this.removeAll();
        JPanel jPanel = this.compressedPanel;
        if (jPanel != null) {
            JPanel it = jPanel;
            boolean bl = false;
            this.add(it, "Center");
        }
        this.isCompressed = true;
        this.revalidate();
        this.repaint();
    }

    public final void toggleCompression() {
        if (this.isCompressed) {
            this.showFullContent();
        } else {
            this.showCompressedContent();
            if (!this.isInToolwindow) {
                this.autoPinToToolWindow();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void renderPlan() {
        this.contentPanel.removeAll();
        Iterable $this$forEachIndexed$iv = this.agentTaskItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void planItem;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AgentTaskEntry agentTaskEntry = (AgentTaskEntry)item$iv;
            int index = n;
            boolean bl = false;
            TaskSectionPanel taskSectionPanel = new TaskSectionPanel(this.project, index, (AgentTaskEntry)planItem, (Function0<Unit>)((Function0)() -> PlanLangSketch.renderPlan$lambda$11$lambda$10(this)));
            this.contentPanel.add((Component)((Object)taskSectionPanel));
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.updateCompressedPanelInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCompressedPanelInfo() {
        block3: {
            JPanel titlePanel2;
            JPanel jPanel = this.compressedPanel;
            if (jPanel == null) break block3;
            JPanel panel2 = jPanel;
            boolean bl = false;
            Component component2 = panel2.getComponent(0);
            JPanel jPanel2 = titlePanel2 = component2 instanceof JPanel ? (JPanel)component2 : null;
            if (jPanel2 != null) {
                JLabel titleLabel;
                void $this$filterIsInstanceTo$iv$iv;
                JPanel tp = jPanel2;
                boolean bl2 = false;
                Component[] componentArray = tp.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$filterIsInstance$iv = componentArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JLabel)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                JLabel jLabel = titleLabel = (JLabel)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
                if (jLabel != null) {
                    jLabel.setText(this.autoPinEnabled ? "Plan pinned (" + this.agentTaskItems.size() + " tasks)" : "Plan (" + this.agentTaskItems.size() + " tasks)");
                }
            }
        }
    }

    public final void updatePlan(@NotNull List<AgentTaskEntry> newPlanItems) {
        Intrinsics.checkNotNullParameter(newPlanItems, (String)"newPlanItems");
        if (newPlanItems.isEmpty()) {
            this.contentPanel.removeAll();
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            return;
        }
        Map taskStateMap = new LinkedHashMap();
        Iterable $this$forEach$iv = this.agentTaskItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentTaskEntry planItem = (AgentTaskEntry)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = planItem.getSteps();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AgentPlanStep task2 = (AgentPlanStep)element$iv2;
                boolean bl2 = false;
                taskStateMap.put(task2.getStep(), new Pair((Object)task2.getCompleted(), (Object)task2.getStatus()));
            }
        }
        this.agentTaskItems.clear();
        $this$forEach$iv = newPlanItems;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentTaskEntry newItem = (AgentTaskEntry)element$iv;
            boolean bl = false;
            this.agentTaskItems.add(newItem);
            newItem.updateCompletionStatus();
        }
        this.renderPlan();
    }

    public final void savePlanToService() {
        ((AgentStateService)this.project.getService(AgentStateService.class)).updatePlan(this.agentTaskItems);
    }

    @Override
    @NotNull
    public String getExtensionName() {
        return "ThoughtPlan";
    }

    @Override
    @NotNull
    public String getViewText() {
        return this.content;
    }

    @Override
    public void updateViewText(@NotNull String text, boolean complete) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.content = text;
        List<AgentTaskEntry> agentPlans = MarkdownPlanParser.INSTANCE.parse(text);
        this.updatePlan(agentPlans);
    }

    @Override
    public void onComplete(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.hasUpdated) {
            return;
        }
        if (!this.isInToolwindow) {
            List agentPlans = CollectionsKt.toMutableList((Collection)MarkdownPlanParser.INSTANCE.parse(this.content));
            this.updatePlan(agentPlans);
            this.savePlanToService();
            if (!this.autoPinEnabled) {
                this.autoPinToToolWindow();
            }
            this.hasUpdated = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void autoPinToToolWindow() {
        AutoDevPlannerToolWindow autoDevPlannerToolWindow;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(AutoDevPlannerToolWindowFactory.Companion.getPlANNER_ID());
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        Component[] componentArray = toolWindow2.getContentManager().getComponent().getComponents();
        if (componentArray != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Component[] $this$filterIsInstance$iv = componentArray;
            boolean $i$f$filterIsInstance = false;
            Component[] componentArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AutoDevPlannerToolWindow)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            autoDevPlannerToolWindow = (AutoDevPlannerToolWindow)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        } else {
            autoDevPlannerToolWindow = null;
        }
        AutoDevPlannerToolWindow codingPanel = autoDevPlannerToolWindow;
        toolWindow2.activate(() -> PlanLangSketch.autoPinToToolWindow$lambda$17(this, codingPanel));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this);
    }

    public void dispose() {
    }

    @Override
    public void updateLanguage(@Nullable Language language, @Nullable String originLanguage) {
        ExtensionLangSketch.DefaultImpls.updateLanguage(this, language, originLanguage);
    }

    @Override
    public void addOrUpdateRenderView(@NotNull JComponent component2) {
        ExtensionLangSketch.DefaultImpls.addOrUpdateRenderView(this, component2);
    }

    @Override
    public boolean hasRenderView() {
        return ExtensionLangSketch.DefaultImpls.hasRenderView(this);
    }

    @Override
    public void onDoneStream(@NotNull String allText) {
        ExtensionLangSketch.DefaultImpls.onDoneStream(this, allText);
    }

    @Override
    @Nullable
    public ActionToolbar setupActionBar(@NotNull Project project, @NotNull Editor editor, boolean isPackageFile, boolean showBottomBorder) {
        return ExtensionLangSketch.DefaultImpls.setupActionBar(this, project, editor, isPackageFile, showBottomBorder);
    }

    @Override
    @Nullable
    public ActionToolbar collectActionBar(boolean isDeclarePackageFile) {
        return ExtensionLangSketch.DefaultImpls.collectActionBar(this, isDeclarePackageFile);
    }

    private static final void _init_$lambda$0(PlanLangSketch this$0) {
        this$0.autoPinToToolWindow();
    }

    private static final Unit renderPlan$lambda$11$lambda$10(PlanLangSketch this$0) {
        this$0.contentPanel.revalidate();
        this$0.contentPanel.repaint();
        return Unit.INSTANCE;
    }

    private static final void autoPinToToolWindow$lambda$17(PlanLangSketch this$0, AutoDevPlannerToolWindow $codingPanel) {
        block0: {
            AgentStateService agentStateService = (AgentStateService)this$0.project.getService(AgentStateService.class);
            List<AgentTaskEntry> currentPlan = agentStateService.getPlan();
            String planString = MarkdownPlanParser.INSTANCE.formatPlanToMarkdown(currentPlan);
            AutoDevPlannerToolWindow autoDevPlannerToolWindow = $codingPanel;
            if (autoDevPlannerToolWindow == null) break block0;
            autoDevPlannerToolWindow.switchToPlanView(planString);
        }
    }
}

