/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.patch;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.observer.agent.AgentStateService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import cc.unitmesh.devti.sketch.ui.patch.DiffRepair;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import cc.unitmesh.devti.util.DirUtil;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J&\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J&\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J0\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/sketch/ui/patch/PatchProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "applyPatch", "Lcom/intellij/openapi/diff/impl/patch/apply/GenericPatchApplier$AppliedPatch;", "originalCode", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "isFailure", "", "appliedPatch", "applyPatchToFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onSuccess", "Lkotlin/Function0;", "handleLightVirtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "handleRegularFile", "performAutoRepair", "oldCode", "onRepaired", "Lkotlin/Function2;", "registerPatchChange", "core"})
@SourceDebugExtension(value={"SMAP\nPatchProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchProcessor.kt\ncc/unitmesh/devti/sketch/ui/patch/PatchProcessor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,148:1\n11#2:149\n*S KotlinDebug\n*F\n+ 1 PatchProcessor.kt\ncc/unitmesh/devti/sketch/ui/patch/PatchProcessor\n*L\n27#1:149\n*E\n"})
public final class PatchProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public PatchProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PatchProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public final GenericPatchApplier.AppliedPatch applyPatch(@NotNull String originalCode, @NotNull TextFilePatch patch) {
        GenericPatchApplier.AppliedPatch appliedPatch;
        Intrinsics.checkNotNullParameter((Object)originalCode, (String)"originalCode");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        try {
            appliedPatch = GenericPatchApplier.apply((CharSequence)originalCode, (List)patch.getHunks());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[1];
            String string = patch.getBeforeFileName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            this.logger.warn(AutoDevBundle.message("sketch.patch.failed.apply", objectArray), (Throwable)e);
            appliedPatch = null;
        }
        return appliedPatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFailure(@Nullable GenericPatchApplier.AppliedPatch appliedPatch) {
        GenericPatchApplier.AppliedPatch appliedPatch2 = appliedPatch;
        if ((appliedPatch2 != null ? appliedPatch2.status : null) == ApplyPatchStatus.SUCCESS) return false;
        GenericPatchApplier.AppliedPatch appliedPatch3 = appliedPatch;
        if ((appliedPatch3 != null ? appliedPatch3.status : null) == ApplyPatchStatus.ALREADY_APPLIED) return false;
        GenericPatchApplier.AppliedPatch appliedPatch4 = appliedPatch;
        if ((appliedPatch4 != null ? appliedPatch4.status : null) == ApplyPatchStatus.PARTIAL) return false;
        return true;
    }

    public final void applyPatchToFile(@NotNull VirtualFile file, @Nullable GenericPatchApplier.AppliedPatch appliedPatch, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        if (appliedPatch == null || this.isFailure(appliedPatch)) {
            this.logger.error("Cannot apply failed patch to file: " + file.getPath());
            return;
        }
        if (file instanceof LightVirtualFile) {
            this.handleLightVirtualFile((LightVirtualFile)file, appliedPatch, onSuccess);
        } else {
            this.handleRegularFile(file, appliedPatch, onSuccess);
        }
    }

    public static /* synthetic */ void applyPatchToFile$default(PatchProcessor patchProcessor, VirtualFile virtualFile, GenericPatchApplier.AppliedPatch appliedPatch, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = PatchProcessor::applyPatchToFile$lambda$0;
        }
        patchProcessor.applyPatchToFile(virtualFile, appliedPatch, (Function0<Unit>)function0);
    }

    private final void handleLightVirtualFile(LightVirtualFile file, GenericPatchApplier.AppliedPatch appliedPatch, Function0<Unit> onSuccess) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String filePath = StringsKt.substringBeforeLast$default((String)string2, (String)fileName, null, (int)2, null);
        try {
            ActionsKt.runReadAction(() -> PatchProcessor.handleLightVirtualFile$lambda$2(this, filePath, appliedPatch, onSuccess, fileName));
        }
        catch (Exception e) {
            this.logger.error("Failed to create file: " + file.getPath(), (Throwable)e);
        }
    }

    private final void handleRegularFile(VirtualFile file, GenericPatchApplier.AppliedPatch appliedPatch, Function0<Unit> onSuccess) {
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            Object[] objectArray = new Object[]{file.getPath()};
            this.logger.error(AutoDevBundle.message("sketch.patch.document.null", objectArray));
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.project, () -> PatchProcessor.handleRegularFile$lambda$4(this, document, appliedPatch, file, onSuccess), "ApplyPatch", null);
    }

    public final void performAutoRepair(@NotNull String oldCode, @NotNull TextFilePatch patch, @NotNull Function2<? super TextFilePatch, ? super String, Unit> onRepaired) {
        String string;
        Intrinsics.checkNotNullParameter((Object)oldCode, (String)"oldCode");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter(onRepaired, (String)"onRepaired");
        if (patch.getHunks().size() > 1) {
            List list = patch.getHunks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHunks(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, PatchProcessor::performAutoRepair$lambda$5, (int)30, null);
        } else {
            string = patch.getSingleHunkPatchText();
        }
        String failurePatch = string;
        Intrinsics.checkNotNull((Object)failurePatch);
        DiffRepair.INSTANCE.applyDiffRepairSuggestionSync(this.project, oldCode, failurePatch, (Function1<? super String, Unit>)((Function1)arg_0 -> PatchProcessor.performAutoRepair$lambda$7(oldCode, onRepaired, arg_0)));
    }

    public final void registerPatchChange(@NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        if (((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getEnableDiffViewer()) {
            ((AgentStateService)this.project.getService(AgentStateService.class)).addToChange(patch);
        }
    }

    private static final Unit applyPatchToFile$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final VirtualFile handleLightVirtualFile$lambda$2$lambda$1(VirtualFile $directory, PatchProcessor this$0, String $fileName) {
        return $directory.createChildData((Object)this$0, $fileName);
    }

    private static final Unit handleLightVirtualFile$lambda$2(PatchProcessor this$0, String $filePath, GenericPatchApplier.AppliedPatch $appliedPatch, Function0 $onSuccess, String $fileName) {
        VirtualFile virtualFile = this$0.project.getBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getBaseDir(...)");
        VirtualFile directory = DirUtil.INSTANCE.getOrCreateDirectory(virtualFile, $filePath);
        Object object = ActionsKt.runWriteAction(() -> PatchProcessor.handleLightVirtualFile$lambda$2$lambda$1(directory, this$0, $fileName));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        VirtualFile vfile = (VirtualFile)object;
        String string = $appliedPatch.patchedText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"patchedText");
        SingleFileDiffSketchKt.writeText(vfile, string);
        FileEditorManager.getInstance((Project)this$0.project).openFile(vfile, true);
        $onSuccess.invoke();
        return Unit.INSTANCE;
    }

    private static final void handleRegularFile$lambda$4$lambda$3(Document $document, GenericPatchApplier.AppliedPatch $appliedPatch, VirtualFile $file, PatchProcessor this$0, Function0 $onSuccess) {
        $document.setText((CharSequence)$appliedPatch.patchedText);
        if ($file instanceof DiffVirtualFileBase) {
            FileEditorManager.getInstance((Project)this$0.project).closeFile($file);
        } else {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this$0.project).openFile($file, true);
            Intrinsics.checkNotNull((Object)fileEditorArray);
        }
        $onSuccess.invoke();
    }

    private static final void handleRegularFile$lambda$4(PatchProcessor this$0, Document $document, GenericPatchApplier.AppliedPatch $appliedPatch, VirtualFile $file, Function0 $onSuccess) {
        WriteCommandAction.runWriteCommandAction((Project)this$0.project, () -> PatchProcessor.handleRegularFile$lambda$4$lambda$3($document, $appliedPatch, $file, this$0, $onSuccess));
    }

    private static final CharSequence performAutoRepair$lambda$5(PatchHunk it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit performAutoRepair$lambda$7(String $oldCode, Function2 $onRepaired, String fixedCode) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fixedCode, (String)"fixedCode");
            TextFilePatch textFilePatch = SingleFileDiffSketchKt.createPatchFromCode($oldCode, fixedCode);
            if (textFilePatch == null) break block0;
            TextFilePatch repairedPatch = textFilePatch;
            boolean bl = false;
            $onRepaired.invoke((Object)repairedPatch, (Object)fixedCode);
        }
        return Unit.INSTANCE;
    }
}

