/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.patch;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.sketch.ui.ExtensionLangSketch;
import cc.unitmesh.devti.sketch.ui.patch.DiffLangSketchKt;
import cc.unitmesh.devti.sketch.ui.patch.DiffRepair;
import cc.unitmesh.devti.sketch.ui.patch.MyApplyPatchFromClipboardDialog;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketch;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0015J\b\u0010\"\u001a\u00020\u0015H\u0002J\u0006\u0010#\u001a\u00020\u0015J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020 H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcc/unitmesh/devti/sketch/ui/patch/DiffLangSketch;", "Lcc/unitmesh/devti/sketch/ui/ExtensionLangSketch;", "myProject", "Lcom/intellij/openapi/project/Project;", "patchContent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "mainPanel", "Ljavax/swing/JPanel;", "myHeaderPanel", "shelfExecutor", "Lcom/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor;", "myReader", "Lcom/intellij/openapi/diff/impl/patch/PatchReader;", "filePatches", "", "initializeUI", "", "createDiffPanel", "Lcc/unitmesh/devti/sketch/ui/patch/SingleFileDiffSketch;", "createErrorSketch", "getChunkText", "createSingleFileDiffSketch", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryGetEditor", "Lcom/intellij/openapi/editor/Editor;", "createHeaderAction", "Ljavax/swing/JComponent;", "handleAcceptAction", "handleRejectAction", "handleViewDiffAction", "getExtensionName", "getViewText", "updateViewText", "text", "complete", "", "getComponent", "dispose", "core"})
@SourceDebugExtension(value={"SMAP\nDiffLangSketch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffLangSketch.kt\ncc/unitmesh/devti/sketch/ui/patch/DiffLangSketch\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n11#2:299\n1747#3,3:300\n1603#3,9:303\n1855#3:312\n1856#3:314\n1612#3:315\n1855#3,2:316\n1#4:313\n*S KotlinDebug\n*F\n+ 1 DiffLangSketch.kt\ncc/unitmesh/devti/sketch/ui/patch/DiffLangSketch\n*L\n63#1:299\n84#1:300,3\n247#1:303,9\n247#1:312\n247#1:314\n247#1:315\n121#1:316,2\n247#1:313\n*E\n"})
public final class DiffLangSketch
implements ExtensionLangSketch {
    @NotNull
    private final Project myProject;
    @NotNull
    private String patchContent;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final JPanel myHeaderPanel;
    @NotNull
    private final ApplyPatchDefaultExecutor shelfExecutor;
    @Nullable
    private final PatchReader myReader;
    @NotNull
    private final List<TextFilePatch> filePatches;

    /*
     * WARNING - void declaration
     */
    public DiffLangSketch(@NotNull Project myProject, @NotNull String patchContent) {
        Object object;
        DiffLangSketch diffLangSketch;
        PatchReader patchReader;
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
        this.mainPanel = new JPanel((LayoutManager)new VerticalLayout(2));
        this.myHeaderPanel = new JPanel(new BorderLayout());
        this.myProject = myProject;
        this.patchContent = patchContent;
        this.shelfExecutor = new ApplyPatchDefaultExecutor(myProject);
        Object object2 = patchReader = new PatchReader((CharSequence)patchContent);
        DiffLangSketch diffLangSketch2 = this;
        boolean $i$a$-also-DiffLangSketch$22 = false;
        try {
            void it;
            it.parseAllPatches();
        }
        catch (Exception e) {
            AutoDevNotifications.INSTANCE.error(myProject, "Failed to parse patch: " + e.getMessage());
        }
        diffLangSketch2.myReader = patchReader;
        diffLangSketch2 = this;
        try {
            diffLangSketch = diffLangSketch2;
            PatchReader patchReader2 = this.myReader;
            object2 = patchReader2 != null ? patchReader2.getTextPatches() : null;
        }
        catch (Exception $i$a$-also-DiffLangSketch$22) {
            void e;
            diffLangSketch = diffLangSketch2;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DiffLangSketch.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse patch: " + e.getMessage());
            object2 = new ArrayList();
        }
        if ((object = object2) == null) {
            object = new ArrayList();
        }
        diffLangSketch.filePatches = object;
        this.initializeUI();
    }

    public DiffLangSketch(@NotNull Project myProject, @NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        this.mainPanel = new JPanel((LayoutManager)new VerticalLayout(2));
        this.myHeaderPanel = new JPanel(new BorderLayout());
        this.myProject = myProject;
        StringWriter writer = new StringWriter();
        UnifiedDiffWriter.write((Project)myProject, (Collection)CollectionsKt.listOf((Object)patch), (Writer)writer, (String)"\n", null);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.patchContent = string;
        this.shelfExecutor = new ApplyPatchDefaultExecutor(myProject);
        this.myReader = null;
        Object[] objectArray = new TextFilePatch[]{patch};
        this.filePatches = CollectionsKt.mutableListOf((Object[])objectArray);
        this.initializeUI();
    }

    private final void initializeUI() {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    if (this.filePatches.size() > 1) break block8;
                    Iterable $this$any$iv = this.filePatches;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            TextFilePatch it = (TextFilePatch)element$iv;
                            boolean bl2 = false;
                            if (!(it.getBeforeName() == null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            JComponent header2 = this.createHeaderAction();
            this.myHeaderPanel.add((Component)header2, "East");
            this.mainPanel.add(this.myHeaderPanel);
        }
        Border[] borderArray = new Border[]{JBUI.Borders.empty((int)0, (int)4)};
        this.mainPanel.setBorder(JBUI.Borders.compound((Border[])borderArray));
        ApplicationManager.getApplication().invokeLater(() -> DiffLangSketch.initializeUI$lambda$5(this));
    }

    private final SingleFileDiffSketch createDiffPanel(TextFilePatch patch) {
        SingleFileDiffSketch singleFileDiffSketch;
        if (patch.getBeforeName() != null) {
            String string = patch.getBeforeName();
            Intrinsics.checkNotNull((Object)string);
            VirtualFile virtualFile = ProjectFileUtilKt.findFile(this.myProject, string);
            if (virtualFile == null) {
                String string2 = patch.getBeforeName();
                Intrinsics.checkNotNull((Object)string2);
                virtualFile = (VirtualFile)new LightVirtualFile(string2, (CharSequence)"");
            }
            VirtualFile originFile = virtualFile;
            singleFileDiffSketch = this.createSingleFileDiffSketch(originFile, patch);
        } else if (patch.getAfterName() != null) {
            String string = patch.getAfterName();
            Intrinsics.checkNotNull((Object)string);
            VirtualFile virtualFile = ProjectFileUtilKt.findFile(this.myProject, string);
            if (virtualFile == null) {
                String string3 = patch.getAfterName();
                Intrinsics.checkNotNull((Object)string3);
                virtualFile = (VirtualFile)new LightVirtualFile(string3, (CharSequence)"");
            }
            VirtualFile virtualFile2 = virtualFile;
            singleFileDiffSketch = this.createSingleFileDiffSketch(virtualFile2, patch);
        } else {
            singleFileDiffSketch = this.createErrorSketch(patch);
        }
        return singleFileDiffSketch;
    }

    private final SingleFileDiffSketch createErrorSketch(TextFilePatch patch) {
        String string = patch.getBeforeName();
        if (string == null) {
            string = "";
        }
        String fileName = string;
        LightVirtualFile virtualFile = new LightVirtualFile(fileName, (CharSequence)this.getChunkText(patch));
        return this.createSingleFileDiffSketch((VirtualFile)virtualFile, patch);
    }

    private final String getChunkText(TextFilePatch patch) {
        if (patch.getHunks().size() > 1) {
            List list = patch.getHunks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHunks(...)");
            return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, DiffLangSketch::getChunkText$lambda$6, (int)30, null);
        }
        String string = patch.getSingleHunkPatchText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSingleHunkPatchText(...)");
        return string;
    }

    private final SingleFileDiffSketch createSingleFileDiffSketch(VirtualFile virtualFile, TextFilePatch patch) {
        SingleFileDiffSketch singleFileDiffSketch;
        SingleFileDiffSketch $this$createSingleFileDiffSketch_u24lambda_u247 = singleFileDiffSketch = new SingleFileDiffSketch(this.myProject, virtualFile, patch, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((DiffLangSketch)this.receiver).handleViewDiffAction();
            }
        }));
        boolean bl = false;
        $this$createSingleFileDiffSketch_u24lambda_u247.onComplete("");
        return singleFileDiffSketch;
    }

    private final Editor tryGetEditor() {
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Editor defaultEditor = editor;
        Regex fileRegex = new Regex("/patch:(.*)");
        MatchResult matchResult = Regex.find$default((Regex)fileRegex, (CharSequence)this.patchContent, (int)0, (int)2, null);
        Object object = matchResult;
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = "";
        }
        Object filePath = object;
        VirtualFile virtualFile = ProjectFileUtilKt.findFile(this.myProject, (String)filePath);
        if (virtualFile == null) {
            return defaultEditor;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileEditor fileEditor2 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(virtualFile2);
        TextEditor fileEditor3 = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
        TextEditor textEditor = fileEditor3;
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
            textEditor = defaultEditor;
        }
        return textEditor;
    }

    private final JComponent createHeaderAction() {
        JButton jButton;
        JButton $this$createHeaderAction_u24lambda_u249 = jButton = new JButton(AllIcons.Actions.SetDefault);
        boolean bl = false;
        $this$createHeaderAction_u24lambda_u249.setToolTipText(AutoDevBundle.message("sketch.patch.action.accept.tooltip", new Object[0]));
        $this$createHeaderAction_u24lambda_u249.addActionListener(arg_0 -> DiffLangSketch.createHeaderAction$lambda$9$lambda$8(this, arg_0));
        JButton acceptButton = jButton;
        JButton $this$createHeaderAction_u24lambda_u2411 = $this$createHeaderAction_u24lambda_u249 = new JButton(AllIcons.Actions.Rollback);
        boolean bl2 = false;
        $this$createHeaderAction_u24lambda_u2411.setToolTipText(AutoDevBundle.message("sketch.patch.action.reject.tooltip", new Object[0]));
        $this$createHeaderAction_u24lambda_u2411.addActionListener(arg_0 -> DiffLangSketch.createHeaderAction$lambda$11$lambda$10(this, arg_0));
        JButton rejectButton = $this$createHeaderAction_u24lambda_u249;
        JButton $this$createHeaderAction_u24lambda_u2413 = $this$createHeaderAction_u24lambda_u2411 = new JButton(AllIcons.Actions.ListChanges);
        boolean bl3 = false;
        $this$createHeaderAction_u24lambda_u2413.setToolTipText(AutoDevBundle.message("sketch.patch.action.viewDiff.tooltip", new Object[0]));
        $this$createHeaderAction_u24lambda_u2413.addActionListener(arg_0 -> DiffLangSketch.createHeaderAction$lambda$13$lambda$12(this, arg_0));
        JButton viewDiffButton = $this$createHeaderAction_u24lambda_u2411;
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 0));
        panel2.add(acceptButton);
        panel2.add(rejectButton);
        panel2.add(viewDiffButton);
        return panel2;
    }

    public final void handleAcceptAction() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)commandProcessor, (String)"getInstance(...)");
        CommandProcessor commandProcessor2 = commandProcessor;
        commandProcessor2.executeCommand(this.myProject, () -> DiffLangSketch.handleAcceptAction$lambda$14(commandProcessor2, this), "ApplyPatch", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION, false);
    }

    private final void handleRejectAction() {
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        FileEditor fileEditor2 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
        if (fileEditor2 == null) {
            return;
        }
        FileEditor fileEditor3 = fileEditor2;
        if (undoManager.isUndoAvailable(fileEditor3)) {
            undoManager.undo(fileEditor3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleViewDiffAction() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.filePatches;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextFilePatch it = (TextFilePatch)element$iv$iv;
            boolean bl2 = false;
            if (it.getBeforeName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List beforeNames = (List)destination$iv$iv;
        if (beforeNames.size() > 1) {
            new MyApplyPatchFromClipboardDialog(this.myProject, this.patchContent).show();
            return;
        }
        DiffLangSketchKt.showSingleDiff(this.myProject, this.patchContent, (Function0<Unit>)((Function0)() -> DiffLangSketch.handleViewDiffAction$lambda$16(this)));
    }

    @Override
    @NotNull
    public String getExtensionName() {
        return "patch";
    }

    @Override
    @NotNull
    public String getViewText() {
        return this.patchContent;
    }

    @Override
    public void updateViewText(@NotNull String text, boolean complete) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.patchContent = text;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void dispose() {
    }

    @Override
    public void updateLanguage(@Nullable Language language, @Nullable String originLanguage) {
        ExtensionLangSketch.DefaultImpls.updateLanguage(this, language, originLanguage);
    }

    @Override
    public void addOrUpdateRenderView(@NotNull JComponent component2) {
        ExtensionLangSketch.DefaultImpls.addOrUpdateRenderView(this, component2);
    }

    @Override
    public boolean hasRenderView() {
        return ExtensionLangSketch.DefaultImpls.hasRenderView(this);
    }

    @Override
    public void onDoneStream(@NotNull String allText) {
        ExtensionLangSketch.DefaultImpls.onDoneStream(this, allText);
    }

    @Override
    public void onComplete(@NotNull String code) {
        ExtensionLangSketch.DefaultImpls.onComplete(this, code);
    }

    @Override
    @Nullable
    public ActionToolbar setupActionBar(@NotNull Project project, @NotNull Editor editor, boolean isPackageFile, boolean showBottomBorder) {
        return ExtensionLangSketch.DefaultImpls.setupActionBar(this, project, editor, isPackageFile, showBottomBorder);
    }

    @Override
    @Nullable
    public ActionToolbar collectActionBar(boolean isDeclarePackageFile) {
        return ExtensionLangSketch.DefaultImpls.collectActionBar(this, isDeclarePackageFile);
    }

    private static final void initializeUI$lambda$5$lambda$3$lambda$2(JButton $this_apply, DiffLangSketch this$0, Editor $editor, ActionEvent it) {
        $this_apply.setIcon((Icon)AutoDevIcons.LOADING);
        Project project = this$0.myProject;
        String string = $editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        DiffRepair.applyDiffRepairSuggestion$default(DiffRepair.INSTANCE, project, $editor, string, this$0.patchContent, null, 16, null);
    }

    private static final void initializeUI$lambda$5(DiffLangSketch this$0) {
        if (this$0.filePatches.isEmpty()) {
            JButton jButton;
            String msg2 = "PatchProcessor: no valid patches found, please check the patch content";
            AutoDevNotifications.INSTANCE.warn(this$0.myProject, msg2);
            JButton $this$initializeUI_u24lambda_u245_u24lambda_u243 = jButton = new JButton("Repair");
            boolean bl = false;
            $this$initializeUI_u24lambda_u245_u24lambda_u243.setIcon(AllIcons.Actions.IntentionBulb);
            $this$initializeUI_u24lambda_u245_u24lambda_u243.setToolTipText("Try to repair the patch content");
            Editor editor = this$0.tryGetEditor();
            if (editor == null) {
                AutoDevNotifications.INSTANCE.error(this$0.myProject, "Failed to get editor");
            } else {
                $this$initializeUI_u24lambda_u245_u24lambda_u243.addActionListener(arg_0 -> DiffLangSketch.initializeUI$lambda$5$lambda$3$lambda$2($this$initializeUI_u24lambda_u245_u24lambda_u243, this$0, editor, arg_0));
            }
            JButton repairButton = jButton;
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.add(repairButton);
            this$0.mainPanel.add(panel2);
            return;
        }
        Iterable $this$forEach$iv = this$0.filePatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextFilePatch patch = (TextFilePatch)element$iv;
            boolean bl = false;
            SingleFileDiffSketch diffPanel = this$0.createDiffPanel(patch);
            if (diffPanel == null) continue;
            this$0.mainPanel.add(diffPanel.getComponent());
            this$0.mainPanel.revalidate();
        }
    }

    private static final CharSequence getChunkText$lambda$6(PatchHunk it) {
        return it.toString();
    }

    private static final void createHeaderAction$lambda$9$lambda$8(DiffLangSketch this$0, ActionEvent it) {
        this$0.handleAcceptAction();
    }

    private static final void createHeaderAction$lambda$11$lambda$10(DiffLangSketch this$0, ActionEvent it) {
        this$0.handleRejectAction();
    }

    private static final void createHeaderAction$lambda$13$lambda$12(DiffLangSketch this$0, ActionEvent it) {
        this$0.handleViewDiffAction();
    }

    private static final void handleAcceptAction$lambda$14(CommandProcessor $commandProcessor, DiffLangSketch this$0) {
        $commandProcessor.markCurrentCommandAsGlobal(this$0.myProject);
        List matchedPatches = new MatchPatchPaths(this$0.myProject).execute(this$0.filePatches, true);
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress patchInProgress : matchedPatches) {
            patchGroups.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
        }
        if (this$0.filePatches.isEmpty()) {
            AutoDevNotifications.INSTANCE.error(this$0.myProject, "PatchProcessor: no patches found");
            return;
        }
        Set pathsFromGroups = ApplyPatchDefaultExecutor.pathsFromGroups((MultiMap)patchGroups);
        PatchReader patchReader = this$0.myReader;
        ThrowableComputable additionalInfo = patchReader != null ? patchReader.getAdditionalInfo(pathsFromGroups) : null;
        this$0.shelfExecutor.apply(this$0.filePatches, patchGroups, null, "LlmGen.diff", additionalInfo);
    }

    private static final Unit handleViewDiffAction$lambda$16(DiffLangSketch this$0) {
        this$0.handleAcceptAction();
        return Unit.INSTANCE;
    }
}

