/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.code.processor;

import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.command.EditFileCommand;
import cc.unitmesh.devti.command.EditRequest;
import cc.unitmesh.devti.command.EditResult;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import cc.unitmesh.devti.sketch.ui.patch.DiffLangSketch;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J4\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J6\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/sketch/ui/code/processor/EditFileCommandProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "processEditFileCommand", "Ljavax/swing/JPanel;", "currentText", "", "onDiffSketchCreated", "Lkotlin/Function1;", "Lcc/unitmesh/devti/sketch/ui/patch/DiffLangSketch;", "", "createEditButton", "Ljavax/swing/JButton;", "isAutoSketchMode", "", "executeEditFileCommand", "button", "panel", "handleExecutionResult", "result", "Lcc/unitmesh/devti/command/EditResult;", "createDiffLangSketch", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "executeEditFileCommandAsync", "callback", "core"})
@SourceDebugExtension(value={"SMAP\nEditFileCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditFileCommandProcessor.kt\ncc/unitmesh/devti/sketch/ui/code/processor/EditFileCommandProcessor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n11#2:158\n*S KotlinDebug\n*F\n+ 1 EditFileCommandProcessor.kt\ncc/unitmesh/devti/sketch/ui/code/processor/EditFileCommandProcessor\n*L\n24#1:158\n*E\n"})
public final class EditFileCommandProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public EditFileCommandProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditFileCommandProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final JPanel processEditFileCommand(@NotNull String currentText, @NotNull Function1<? super DiffLangSketch, Unit> onDiffSketchCreated) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)currentText, (String)"currentText");
        Intrinsics.checkNotNullParameter(onDiffSketchCreated, (String)"onDiffSketchCreated");
        boolean isAutoSketchMode = AutoSketchMode.Companion.getInstance(this.project).isEnable();
        JButton button2 = this.createEditButton(isAutoSketchMode);
        JPanel $this$processEditFileCommand_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$processEditFileCommand_u24lambda_u240.setLayout(new BoxLayout($this$processEditFileCommand_u24lambda_u240, 0));
        $this$processEditFileCommand_u24lambda_u240.add(button2);
        JPanel panel2 = jPanel;
        if (isAutoSketchMode) {
            this.executeEditFileCommand(currentText, button2, panel2, onDiffSketchCreated);
        } else {
            button2.addActionListener(arg_0 -> EditFileCommandProcessor.processEditFileCommand$lambda$1(this, currentText, button2, panel2, onDiffSketchCreated, arg_0));
        }
        return panel2;
    }

    private final JButton createEditButton(boolean isAutoSketchMode) {
        JButton jButton;
        if (isAutoSketchMode) {
            JButton jButton2;
            JButton $this$createEditButton_u24lambda_u242 = jButton2 = new JButton("Auto Executing...", (Icon)AutoDevIcons.LOADING);
            boolean bl = false;
            $this$createEditButton_u24lambda_u242.setEnabled(false);
            $this$createEditButton_u24lambda_u242.setPreferredSize((Dimension)JBUI.size((int)150, (int)30));
            jButton = jButton2;
        } else {
            JButton jButton3;
            JButton $this$createEditButton_u24lambda_u243 = jButton3 = new JButton("Execute Edit File", AllIcons.Actions.Execute);
            boolean bl = false;
            $this$createEditButton_u24lambda_u243.setPreferredSize((Dimension)JBUI.size((int)120, (int)30));
            jButton = jButton3;
        }
        return jButton;
    }

    private final void executeEditFileCommand(String currentText, JButton button2, JPanel panel2, Function1<? super DiffLangSketch, Unit> onDiffSketchCreated) {
        boolean isAutoSketchMode = AutoSketchMode.Companion.getInstance(this.project).isEnable();
        button2.setEnabled(false);
        button2.setText(isAutoSketchMode ? "Auto Executing..." : "Executing...");
        button2.setIcon((Icon)AutoDevIcons.LOADING);
        this.executeEditFileCommandAsync(this.project, currentText, (Function1<? super EditResult, Unit>)((Function1)arg_0 -> EditFileCommandProcessor.executeEditFileCommand$lambda$5(this, button2, panel2, onDiffSketchCreated, arg_0)));
    }

    private final void handleExecutionResult(EditResult result, JButton button2, JPanel panel2, Function1<? super DiffLangSketch, Unit> onDiffSketchCreated) {
        EditResult editResult = result;
        if (editResult instanceof EditResult.Success) {
            DiffLangSketch diffSketch = this.createDiffLangSketch(((EditResult.Success)result).getPatch());
            onDiffSketchCreated.invoke((Object)diffSketch);
            panel2.remove(button2);
            panel2.revalidate();
            panel2.repaint();
        } else if (editResult instanceof EditResult.Error) {
            button2.setText("Failed");
            button2.setIcon(AllIcons.General.Error);
            AutoDevNotifications.INSTANCE.warn(this.project, ((EditResult.Error)result).getMessage());
        } else if (editResult == null) {
            button2.setText("Failed");
            button2.setIcon(AllIcons.General.Error);
            AutoDevNotifications.INSTANCE.warn(this.project, "Unknown error occurred");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final DiffLangSketch createDiffLangSketch(TextFilePatch patch) {
        return new DiffLangSketch(this.project, patch);
    }

    public final void executeEditFileCommandAsync(@NotNull Project project, @NotNull String currentText, @NotNull Function1<? super EditResult, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentText, (String)"currentText");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            List<CodeFence> codeFences = CodeFence.Companion.parseAll(currentText);
            if (codeFences.isEmpty()) {
                callback.invoke((Object)EditResult.Companion.error("No edit_file commands found in content"));
                return;
            }
            EditFileCommand editFileCommand = new EditFileCommand(project);
            for (CodeFence codeFence : codeFences) {
                EditRequest editRequest = editFileCommand.parseEditRequest(codeFence.getText());
                if (editRequest == null) continue;
                EditResult result = editFileCommand.executeEdit(editRequest);
                EditResult editResult = result;
                if (editResult instanceof EditResult.Success) {
                    ActionsKt.runInEdt$default(null, () -> EditFileCommandProcessor.executeEditFileCommandAsync$lambda$6(project, result), (int)1, null);
                    callback.invoke((Object)result);
                    return;
                }
                if (editResult instanceof EditResult.Error) {
                    this.logger.error("\u7f16\u8f91\u5931\u8d25: " + ((EditResult.Error)result).getMessage());
                    callback.invoke((Object)result);
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
            callback.invoke((Object)EditResult.Companion.error("No valid edit_file commands found"));
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            callback.invoke((Object)EditResult.Companion.error("Execution failed: " + e.getMessage()));
        }
    }

    private static final void processEditFileCommand$lambda$1(EditFileCommandProcessor this$0, String $currentText, JButton $button, JPanel $panel, Function1 $onDiffSketchCreated, ActionEvent it) {
        this$0.executeEditFileCommand($currentText, $button, $panel, (Function1<? super DiffLangSketch, Unit>)$onDiffSketchCreated);
    }

    private static final Unit executeEditFileCommand$lambda$5$lambda$4(EditFileCommandProcessor this$0, EditResult $result, JButton $button, JPanel $panel, Function1 $onDiffSketchCreated) {
        this$0.handleExecutionResult($result, $button, $panel, (Function1<? super DiffLangSketch, Unit>)$onDiffSketchCreated);
        return Unit.INSTANCE;
    }

    private static final Unit executeEditFileCommand$lambda$5(EditFileCommandProcessor this$0, JButton $button, JPanel $panel, Function1 $onDiffSketchCreated, EditResult result) {
        ActionsKt.runInEdt$default(null, () -> EditFileCommandProcessor.executeEditFileCommand$lambda$5$lambda$4(this$0, result, $button, $panel, $onDiffSketchCreated), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit executeEditFileCommandAsync$lambda$6(Project $project, EditResult $result) {
        FileEditorManager.getInstance((Project)$project).openFile(((EditResult.Success)$result).getTargetFile(), true);
        return Unit.INSTANCE;
    }
}

