/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.code;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/sketch/ui/code/MarkdownWebViewer;", "", "<init>", "()V", "createBaseComponent", "Ljavax/swing/JEditorPane;", "core"})
public final class MarkdownWebViewer {
    @NotNull
    public static final MarkdownWebViewer INSTANCE = new MarkdownWebViewer();

    private MarkdownWebViewer() {
    }

    @NotNull
    public final JEditorPane createBaseComponent() {
        JEditorPane jEditorPane;
        JEditorPane jEditorPane2 = new JEditorPane();
        jEditorPane2.setContentType("text/html");
        HTMLEditorKit htmlEditorKit = new HTMLEditorKitBuilder().build();
        Color color = JBUI.CurrentTheme.ToolWindow.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        Color backgroundColor = color;
        String string = ColorUtil.toHex((Color)backgroundColor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String bg = string;
        String editorFontName = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getEditorFontName();
        int editorFontSize = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getEditorFontSize();
        String fontFamilyAndSize = "font-family:'" + editorFontName + "'; font-size:" + editorFontSize + "pt;";
        String cssRules = StringsKt.trimIndent((String)("\n            body { " + fontFamilyAndSize + " margin: 2px 0px; line-height: 1.5; }\n            \n            /* Headings */\n            h1 { font-size: 1.6em; font-weight: bold; }\n            h2 { font-size: 1.4em; font-weight: bold; }\n            h3 { font-size: 1.2em; font-weight: bold; }\n            h4, h5, h6 { font-size: 1.1em; font-weight: bold; }\n            \n            pre { background-color: #" + bg + "; border-radius: 4px; padding: 8px; overflow-x: auto; margin: 1em 0; }\n            code { font-family: 'JetBrains Mono', Consolas, monospace; background-color: #" + bg + "; padding: 2px 4px; border-radius: 3px; font-size: 0.9em; }\n            \n            /* Lists */\n            ul, ol { margin-top: 0.5em; margin-bottom: 0.5em; padding-left: 2em; }\n            li { margin: 0.3em 0; }\n            \n            /* Blockquotes */\n            blockquote { border-left: 4px solid #ddd; padding-left: 1em; margin-left: 0; margin-right: 0; color: #777; }\n            \n            /* Tables */\n            table { border-collapse: collapse; width: 100%; margin: 1em 0; }\n            th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }\n            th { background-color: #f2f2f2; }\n            \n            /* Links */\n            a { color: #2196F3; text-decoration: none; }\n            a:hover { text-decoration: underline; }\n            \n            /* Horizontal rule */\n            hr { border: 0; height: 1px; background-color: #" + bg + "; margin: 1em 0; }\n            \n            /* Inline elements */\n            strong, b { font-weight: bold; }\n            em, i { font-style: italic; }\n        "));
        htmlEditorKit.getStyleSheet().addRule(cssRules);
        JEditorPane it = jEditorPane = jEditorPane2;
        boolean bl = false;
        it.setEditorKit(htmlEditorKit);
        it.setEditable(false);
        it.putClientProperty("JEditorPane.honorDisplayProperties", true);
        it.setOpaque(false);
        it.setBorder(null);
        String string2 = StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)"", (String)" "));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeXmlEntities(...)");
        String xmlEntities = string2;
        it.putClientProperty("AccessibleName", "");
        it.setText("");
        if (jEditorPane2.getCaret() != null) {
            jEditorPane2.setCaretPosition(0);
            Caret caret = jEditorPane2.getCaret();
            DefaultCaret defaultCaret = caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
            if (defaultCaret != null) {
                defaultCaret.setUpdatePolicy(1);
            }
        }
        jEditorPane2.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        return jEditorPane2;
    }
}

