/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.ui.code;

import cc.unitmesh.devti.AutoDevSnippetFile;
import cc.unitmesh.devti.sketch.ui.code.CodeHighlightSketchKt;
import cc.unitmesh.devti.util.DispoableUtilKt;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/sketch/ui/code/EditorUtil;", "", "<init>", "()V", "LINE_NO_REGEX", "Lkotlin/text/Regex;", "createCodeViewerEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "ideaLanguage", "Lcom/intellij/lang/Language;", "fileName", "disposable", "Lcom/intellij/openapi/Disposable;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "isShowLineNo", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/Disposable;Ljava/lang/Boolean;)Lcom/intellij/openapi/editor/ex/EditorEx;", "configEditor", "editor", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Boolean;)Lcom/intellij/openapi/editor/ex/EditorEx;", "core"})
@SourceDebugExtension(value={"SMAP\nEditorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorUtil.kt\ncc/unitmesh/devti/sketch/ui/code/EditorUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1855#2,2:165\n1549#2:167\n1620#2,3:168\n*S KotlinDebug\n*F\n+ 1 EditorUtil.kt\ncc/unitmesh/devti/sketch/ui/code/EditorUtil\n*L\n51#1:165,2\n59#1:167\n59#1:168,3\n*E\n"})
public final class EditorUtil {
    @NotNull
    public static final EditorUtil INSTANCE = new EditorUtil();
    @NotNull
    private static final Regex LINE_NO_REGEX = new Regex("^\\d+:");

    private EditorUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EditorEx createCodeViewerEditor(@NotNull Project project, @NotNull String text, @Nullable Language ideaLanguage, @Nullable String fileName, @NotNull Disposable disposable) {
        Object object;
        Language language;
        Language language2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        String editorText = text;
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)"\r\n", (boolean)false, (int)2, null)) {
            editorText = StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        }
        if ((language2 = ideaLanguage) == null) {
            language2 = (Language)PlainTextLanguage.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(language = language2).getDisplayName(), (Object)PlainTextLanguage.INSTANCE.getDisplayName())) {
            String string = language.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            object = CodeFence.Companion.lookupFileExt(string);
        } else {
            object = language.getAssociatedFileType();
            if (object == null || (object = object.getDefaultExtension()) == null) {
                object = "Unknown";
            }
        }
        Object ext = object;
        boolean isShowLineNo = false;
        isShowLineNo = true;
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)editorText);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (LINE_NO_REGEX.matches((CharSequence)it)) continue;
            isShowLineNo = false;
        }
        if (isShowLineNo) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            Iterable $this$map$iv = StringsKt.lines((CharSequence)editorText);
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CharSequence charSequence = (CharSequence)it;
                Regex regex = LINE_NO_REGEX;
                String string2 = "";
                collection.add(regex.replace(charSequence, string2));
            }
            List newLines = (List)destination$iv$iv;
            editorText = CollectionsKt.joinToString$default((Iterable)newLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        VirtualFile file = fileName != null ? (VirtualFile)new LightVirtualFile(fileName, language, (CharSequence)editorText) : (VirtualFile)new LightVirtualFile(AutoDevSnippetFile.INSTANCE.naming((String)ext), language, (CharSequence)editorText);
        Document document = CodeHighlightSketchKt.findDocument(file);
        if (document == null) {
            throw new IllegalStateException("Document not found");
        }
        Document document2 = document;
        return this.createCodeViewerEditor(project, file, document2, disposable, isShowLineNo);
    }

    @NotNull
    public final EditorEx createCodeViewerEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @NotNull Disposable disposable, @Nullable Boolean isShowLineNo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Object object = ReadAction.compute(() -> EditorUtil.createCodeViewerEditor$lambda$2(project, document));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        EditorEx editor = (EditorEx)object;
        AtomicBoolean isReleased = new AtomicBoolean(false);
        DispoableUtilKt.whenDisposed(disposable, (Function0<Unit>)((Function0)() -> EditorUtil.createCodeViewerEditor$lambda$3(isReleased, editor)));
        editor.setFile(file);
        return this.configEditor(editor, project, file, isShowLineNo);
    }

    public static /* synthetic */ EditorEx createCodeViewerEditor$default(EditorUtil editorUtil, Project project, VirtualFile virtualFile, Document document, Disposable disposable, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return editorUtil.createCodeViewerEditor(project, virtualFile, document, disposable, bl);
    }

    @NotNull
    public final EditorEx configEditor(@NotNull EditorEx editor, @NotNull Project project, @NotNull VirtualFile file, @Nullable Boolean isShowLineNo) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        editor.setCaretEnabled(true);
        EditorHighlighter highlighter = ((EditorHighlighterFactory)ApplicationManager.getApplication().getService(EditorHighlighterFactory.class)).createEditorHighlighter(project, file);
        try {
            editor.setHighlighter(highlighter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        ((EditorMarkupModel)markupModel).setErrorStripeVisible(false);
        EditorSettings it = editorSettings = editor.getSettings();
        boolean bl = false;
        it.setDndEnabled(false);
        it.setLineNumbersShown(Intrinsics.areEqual((Object)isShowLineNo, (Object)true));
        it.setAdditionalLinesCount(0);
        it.setLineMarkerAreaShown(false);
        it.setFoldingOutlineShown(false);
        it.setRightMarginShown(false);
        it.setShowIntentionBulb(false);
        it.setUseSoftWraps(true);
        it.setRefrainFromScrolling(true);
        it.setAdditionalPageAtBottom(false);
        it.setCaretRowShown(false);
        EditorSettings editorSettings2 = editorSettings;
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings2, (String)"also(...)");
        EditorSettings settings = editorSettings2;
        editor.getScrollPane().getVerticalScrollBar().setVisible(false);
        editor.getScrollPane().getHorizontalScrollBar().setVisible(false);
        editor.getScrollPane().setBackground(editor.getBackgroundColor());
        editor.addFocusListener(new FocusChangeListener(settings, editor){
            final /* synthetic */ EditorSettings $settings;
            final /* synthetic */ EditorEx $editor;
            {
                this.$settings = $settings;
                this.$editor = $editor;
            }

            public void focusGained(Editor focusEditor) {
                Intrinsics.checkNotNullParameter((Object)focusEditor, (String)"focusEditor");
                this.$settings.setCaretRowShown(true);
            }

            public void focusLost(Editor focusEditor) {
                Intrinsics.checkNotNullParameter((Object)focusEditor, (String)"focusEditor");
                if (focusEditor.isDisposed()) {
                    return;
                }
                if (this.$editor.isDisposed()) {
                    return;
                }
                this.$settings.setCaretRowShown(false);
                this.$editor.getMarkupModel().removeAllHighlighters();
            }
        });
        return editor;
    }

    private static final EditorEx createCodeViewerEditor$lambda$2(Project $project, Document $document) {
        if ($project.isDisposed()) {
            throw new IllegalStateException("Project is disposed");
        }
        Editor editor = EditorFactory.getInstance().createViewer($document, $project, EditorKind.PREVIEW);
        editor = editor instanceof EditorEx ? (EditorEx)editor : null;
        return editor;
    }

    private static final Unit createCodeViewerEditor$lambda$3(AtomicBoolean $isReleased, EditorEx $editor) {
        if ($isReleased.compareAndSet(false, true)) {
            try {
                if (!$editor.isDisposed()) {
                    EditorFactory.getInstance().releaseEditor((Editor)$editor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }
}

