/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.run;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcc/unitmesh/devti/sketch/run/ShellUtil;", "", "<init>", "()V", "listWslShell", "", "", "detectShells", "addIfExists", "", "shells", "", "filePath", "core"})
@SourceDebugExtension(value={"SMAP\nShellUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellUtil.kt\ncc/unitmesh/devti/sketch/run/ShellUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1603#2,9:80\n1855#2:89\n1856#2:91\n1612#2:92\n1#3:90\n*S KotlinDebug\n*F\n+ 1 ShellUtil.kt\ncc/unitmesh/devti/sketch/run/ShellUtil\n*L\n19#1:80,9\n19#1:89\n19#1:91\n19#1:92\n19#1:90\n*E\n"})
public final class ShellUtil {
    @NotNull
    public static final ShellUtil INSTANCE = new ShellUtil();

    private ShellUtil() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> listWslShell() {
        void $this$mapNotNullTo$iv$iv;
        if (WSLDistribution.findWslExe() == null) {
            return CollectionsKt.emptyList();
        }
        List list = WslDistributionManager.getInstance().getInstalledDistributions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstalledDistributions(...)");
        List distributions = list;
        Iterable $this$mapNotNull$iv = distributions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WSLDistribution it = (WSLDistribution)element$iv$iv;
            boolean bl2 = false;
            if (it.getShellPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> detectShells() {
        List shells = new ArrayList();
        if (SystemInfo.isUnix) {
            this.addIfExists(shells, "/bin/bash");
            this.addIfExists(shells, "/usr/bin/bash");
            this.addIfExists(shells, "/usr/local/bin/bash");
            this.addIfExists(shells, "/opt/homebrew/bin/bash");
            this.addIfExists(shells, "/bin/zsh");
            this.addIfExists(shells, "/usr/bin/zsh");
            this.addIfExists(shells, "/usr/local/bin/zsh");
            this.addIfExists(shells, "/opt/homebrew/bin/zsh");
            this.addIfExists(shells, "/bin/fish");
            this.addIfExists(shells, "/usr/bin/fish");
            this.addIfExists(shells, "/usr/local/bin/fish");
            this.addIfExists(shells, "/opt/homebrew/bin/fish");
            this.addIfExists(shells, "/opt/homebrew/bin/pwsh");
        } else if (SystemInfo.isWindows) {
            String cmderRoot;
            File gitBash;
            File pwsh;
            File cmd;
            File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (powershell != null && StringUtil.startsWithIgnoreCase((String)powershell.getAbsolutePath(), (String)"C:\\Windows\\System32\\WindowsPowerShell\\")) {
                String string = powershell.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                shells.add(string);
            }
            if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                String string = cmd.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                shells.add(string);
            }
            if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null && StringUtil.startsWithIgnoreCase((String)pwsh.getAbsolutePath(), (String)"C:\\Program Files\\PowerShell\\")) {
                String string = pwsh.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                shells.add(string);
            }
            if ((gitBash = new File("C:\\Program Files\\Git\\bin\\bash.exe")).isFile()) {
                String string = gitBash.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                shells.add(string);
            }
            if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) == null) {
                cmderRoot = (String)EnvironmentVariablesData.DEFAULT.getEnvs().get("CMDER_ROOT");
            }
            if (cmderRoot != null && cmd != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                shells.add("cmd.exe /k \"%CMDER_ROOT%\\vendor\\init.bat\"");
            }
        }
        return shells;
    }

    private final void addIfExists(List<String> shells, String filePath) {
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            shells.add(filePath);
        }
    }
}

