/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.run;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\r\u001a\u00020\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcc/unitmesh/devti/sketch/run/ShellSafetyCheck;", "", "<init>", "()V", "dangerousPatterns", "", "Lkotlin/text/Regex;", "", "getDangerousPatterns", "()Ljava/util/Map;", "checkDangerousCommand", "Lkotlin/Pair;", "", "command", "core"})
public final class ShellSafetyCheck {
    @NotNull
    public static final ShellSafetyCheck INSTANCE = new ShellSafetyCheck();
    @NotNull
    private static final Map<Regex, String> dangerousPatterns;

    private ShellSafetyCheck() {
    }

    @NotNull
    public final Map<Regex, String> getDangerousPatterns() {
        return dangerousPatterns;
    }

    @NotNull
    public final Pair<Boolean, String> checkDangerousCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)command)).toString(), (String)"rm ", (boolean)false, (int)2, null)) {
            return new Pair((Object)true, (Object)"Remove command detected, use with caution");
        }
        for (Map.Entry<Regex, String> entry : dangerousPatterns.entrySet()) {
            Regex pattern = entry.getKey();
            String message = entry.getValue();
            if (!pattern.containsMatchIn((CharSequence)command)) continue;
            return new Pair((Object)true, (Object)message);
        }
        return new Pair((Object)false, (Object)"");
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new Regex("\\brm\\s+(-[a-zA-Z]*f|-[a-zA-Z]*r|-[a-zA-Z]*(rf|fr))\\b.*"), (Object)"Dangerous rm command with recursive or force flags"), TuplesKt.to((Object)new Regex("\\brm\\s+-[a-zA-Z]*\\s+/.*"), (Object)"Removing files from root directory"), TuplesKt.to((Object)new Regex("\\brmdir\\s+/.*"), (Object)"Removing directories from root"), TuplesKt.to((Object)new Regex("\\bmkfs\\b.*"), (Object)"Filesystem formatting command"), TuplesKt.to((Object)new Regex("\\bdd\\b.*"), (Object)"Low-level disk operation"), TuplesKt.to((Object)new Regex("\\b:[(][)][{]\\s*:|:&\\s*[}];:.*"), (Object)"Potential fork bomb"), TuplesKt.to((Object)new Regex("\\bchmod\\s+-[a-zA-Z]*R\\b.*777\\b.*"), (Object)"Recursive chmod with insecure permissions"), TuplesKt.to((Object)new Regex("\\bsudo\\s+rm\\b.*"), (Object)"Removing files with elevated privileges"), TuplesKt.to((Object)new Regex("\\bcurl\\s+.*\\s*\\|\\s*(ba)?sh.*"), (Object)"Downloading and executing scripts directly"), TuplesKt.to((Object)new Regex("\\bwget\\s+.*\\s*\\|\\s*(ba)?sh.*"), (Object)"Downloading and executing scripts directly"), TuplesKt.to((Object)new Regex("\\bkill\\s+-9\\s+-1\\b.*"), (Object)"Killing all user processes"), TuplesKt.to((Object)new Regex(">\\s+/etc/.*"), (Object)"Overwriting system configuration files"), TuplesKt.to((Object)new Regex("\\bformat\\b.*"), (Object)"Disk formatting command"), TuplesKt.to((Object)new Regex("\\bfdisk\\b.*"), (Object)"Disk partitioning tool"), TuplesKt.to((Object)new Regex("\\bshred\\b.*"), (Object)"Secure file deletion tool"), TuplesKt.to((Object)new Regex("\\bfsck\\s+/dev/.*"), (Object)"Filesystem check on device"), TuplesKt.to((Object)new Regex("\\buserdel\\s+(root|daemon|bin|sys|sync|games|man|lp|mail|news|uucp|proxy)\\b.*"), (Object)"Removing critical system users"), TuplesKt.to((Object)new Regex("\\bchown\\s+-[a-zA-Z]*R\\b.*"), (Object)"Recursive ownership change"), TuplesKt.to((Object)new Regex("\\bmv\\s+.*\\s+/etc/.*"), (Object)"Moving files to system configuration directory"), TuplesKt.to((Object)new Regex("\\bchattr\\s+-[a-zA-Z]*i\\b.*"), (Object)"Changing immutable file attributes")};
        dangerousPatterns = MapsKt.mapOf((Pair[])pairArray);
    }
}

