/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.run;

import cc.unitmesh.devti.sketch.run.ChmodCommandChecker;
import cc.unitmesh.devti.sketch.run.GenericCommandChecker;
import cc.unitmesh.devti.sketch.run.PatternCommandChecker;
import cc.unitmesh.devti.sketch.run.RmCommandChecker;
import cc.unitmesh.devti.sketch.run.RootDirectoryOperationChecker;
import cc.unitmesh.devti.sketch.run.ShellCommandChecker;
import cc.unitmesh.devti.sketch.run.ShellCommandCheckerRegistry;
import cc.unitmesh.devti.sketch.run.SudoCommandChecker;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.psi.ShCommand;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/sketch/run/ShellPsiSyntaxSafetyCheck;", "", "<init>", "()V", "checkerRegistry", "Lcc/unitmesh/devti/sketch/run/ShellCommandCheckerRegistry;", "commandCheckerChain", "Lcc/unitmesh/devti/sketch/run/ShellCommandChecker;", "getCommandCheckerChain", "()Lcc/unitmesh/devti/sketch/run/ShellCommandChecker;", "commandCheckerChain$delegate", "Lkotlin/Lazy;", "checkDangerousCommand", "Lkotlin/Pair;", "", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "core"})
public final class ShellPsiSyntaxSafetyCheck {
    @NotNull
    public static final ShellPsiSyntaxSafetyCheck INSTANCE = new ShellPsiSyntaxSafetyCheck();
    @NotNull
    private static final ShellCommandCheckerRegistry checkerRegistry = new ShellCommandCheckerRegistry();
    @NotNull
    private static final Lazy commandCheckerChain$delegate = LazyKt.lazy(ShellPsiSyntaxSafetyCheck::commandCheckerChain_delegate$lambda$0);

    private ShellPsiSyntaxSafetyCheck() {
    }

    private final ShellCommandChecker getCommandCheckerChain() {
        Lazy lazy = commandCheckerChain$delegate;
        return (ShellCommandChecker)lazy.getValue();
    }

    @NotNull
    public final Pair<Boolean, String> checkDangerousCommand(@NotNull Project project, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        VirtualFile virtualFile = ScratchRootType.getInstance().createScratchFile(project, "devin-shell-ins.sh", ShLanguage.INSTANCE, command);
        if (virtualFile == null) {
            return new Pair((Object)true, (Object)"Could not parse command");
        }
        VirtualFile createScratchFile = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(createScratchFile);
        if (psiFile2 == null) {
            return new Pair((Object)true, (Object)"Could not parse command");
        }
        PsiFile psiFile3 = psiFile2;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiFile3), ShCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection commandElements = collection;
        for (ShCommand cmd : commandElements) {
            ShellCommandChecker shellCommandChecker = this.getCommandCheckerChain();
            Intrinsics.checkNotNull((Object)cmd);
            Pair<Boolean, String> result = shellCommandChecker.check(cmd, command);
            if (result == null || !((Boolean)result.getFirst()).booleanValue()) continue;
            return result;
        }
        createScratchFile.delete((Object)this);
        return new Pair((Object)false, (Object)"");
    }

    private static final ShellCommandChecker commandCheckerChain_delegate$lambda$0() {
        return checkerRegistry.buildCheckerChain();
    }

    static {
        checkerRegistry.register(new RmCommandChecker());
        checkerRegistry.register(new SudoCommandChecker());
        checkerRegistry.register(new GenericCommandChecker("mkfs", "Filesystem formatting command"));
        checkerRegistry.register(new GenericCommandChecker("dd", "Low-level disk operation"));
        checkerRegistry.register(new ChmodCommandChecker());
        checkerRegistry.register(new RootDirectoryOperationChecker());
        checkerRegistry.register(new PatternCommandChecker());
    }
}

