/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.sketch.rule;

import cc.unitmesh.devti.bridge.knowledge.HistoryFunctionProviderKt;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/sketch/rule/ProjectRule;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "RULE_PATH", "", "getRULE_PATH", "()Ljava/lang/String;", "getRuleContent", "contextFileName", "hasRule", "", "filename", "getAllRules", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "core"})
@SourceDebugExtension(value={"SMAP\nProjectRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRule.kt\ncc/unitmesh/devti/sketch/rule/ProjectRule\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,49:1\n3792#2:50\n4307#2,2:51\n*S KotlinDebug\n*F\n+ 1 ProjectRule.kt\ncc/unitmesh/devti/sketch/rule/ProjectRule\n*L\n47#1:50\n47#1:51,2\n*E\n"})
public final class ProjectRule {
    @NotNull
    private final Project project;
    @NotNull
    private final String RULE_PATH;

    public ProjectRule(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.RULE_PATH = ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getTeamPromptsDir() + "/rules";
    }

    @NotNull
    public final String getRULE_PATH() {
        return this.RULE_PATH;
    }

    @Nullable
    public final String getRuleContent(@NotNull String contextFileName) {
        Intrinsics.checkNotNullParameter((Object)contextFileName, (String)"contextFileName");
        String fullname = this.RULE_PATH + "/" + contextFileName + ".md";
        VirtualFile file = HistoryFunctionProviderKt.lookupFile(this.project, fullname);
        if (file != null) {
            String content = SingleFileDiffSketchKt.readText(file);
            return "<user-rule>\n" + content + "\n</user-rule>";
        }
        VirtualFile devinFile = HistoryFunctionProviderKt.lookupFile(this.project, this.RULE_PATH + "/" + contextFileName + ".devin");
        if (devinFile != null) {
            String content = SingleFileDiffSketchKt.readText(devinFile);
            return "<user-rule>\n" + content + "\n</user-rule>";
        }
        return (String)file;
    }

    public final boolean hasRule(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String fullname = this.RULE_PATH + "/" + filename + ".md";
        VirtualFile file = HistoryFunctionProviderKt.lookupFile(this.project, fullname);
        return file != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getAllRules() {
        void $this$filterTo$iv$iv;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(this.RULE_PATH)) == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile ruleDir = virtualFile;
        VirtualFile[] virtualFileArray = ruleDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"md") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"devin"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

