/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.settings.model;

import cc.unitmesh.devti.llm2.GithubCopilotManager;
import cc.unitmesh.devti.llm2.LLMProvider2;
import cc.unitmesh.devti.llm2.SessionMessageItem;
import cc.unitmesh.devti.llm2.model.CopilotModel;
import cc.unitmesh.devti.llm2.model.LlmConfig;
import cc.unitmesh.devti.llm2.model.ModelLimits;
import cc.unitmesh.devti.llm2.model.ModelType;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import cc.unitmesh.devti.settings.dialog.LLMDialog;
import cc.unitmesh.devti.settings.model.LLMModelManager;
import cc.unitmesh.devti.settings.ui.ModelItem;
import cc.unitmesh.devti.util.AutoDevAppScope;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 /2\u00020\u0001:\u0001/B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\u0012\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJZ\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110!Jb\u0010'\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110!J\u000e\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\bJ\u000e\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0018Jb\u0010.\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010)\u001a\u00020*R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcc/unitmesh/devti/settings/model/LLMModelManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcc/unitmesh/devti/settings/AutoDevSettingsState;", "onModified", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/settings/AutoDevSettingsState;Lkotlin/jvm/functions/Function0;)V", "isCustomLLM", "", "modelName", "", "getAllAvailableModels", "", "Lcc/unitmesh/devti/settings/ui/ModelItem;", "getUsedMaxToken", "Lcc/unitmesh/devti/llm2/model/ModelLimits;", "getProviderFromModelId", "modelId", "createNewLLM", "existingLlm", "Lcc/unitmesh/devti/llm2/model/LlmConfig;", "editLLMAtRow", "table", "Ljavax/swing/JTable;", "row", "", "deleteLLMAtRow", "updateAllDropdowns", "defaultModelDropdown", "Lcom/intellij/openapi/ui/ComboBox;", "planLLMDropdown", "actLLMDropdown", "completionLLMDropdown", "embeddingLLMDropdown", "fastApplyLLMDropdown", "setSelectedModels", "updateLLMTable", "tableModel", "Ljavax/swing/table/DefaultTableModel;", "testGitHubCopilotConnection", "testCustomLLM", "llm", "refreshGitHubCopilotModels", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLLMModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMModelManager.kt\ncc/unitmesh/devti/settings/model/LLMModelManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,525:1\n1747#2,3:526\n1855#2,2:532\n1855#2,2:534\n1747#2,3:543\n1855#2,2:549\n1855#2,2:551\n1855#2,2:556\n1855#2,2:558\n1747#2,3:563\n42#3,3:529\n42#3,3:536\n42#3,3:540\n42#3,3:546\n42#3,3:553\n42#3,3:560\n1#4:539\n*S KotlinDebug\n*F\n+ 1 LLMModelManager.kt\ncc/unitmesh/devti/settings/model/LLMModelManager\n*L\n45#1:526,3\n57#1:532,2\n67#1:534,2\n122#1:543,3\n237#1:549,2\n298#1:551,2\n373#1:556,2\n386#1:558,2\n340#1:563,3\n54#1:529,3\n92#1:536,3\n119#1:540,3\n231#1:546,3\n368#1:553,3\n471#1:560,3\n*E\n"})
public final class LLMModelManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final AutoDevSettingsState settings;
    @NotNull
    private final Function0<Unit> onModified;

    public LLMModelManager(@Nullable Project project, @NotNull AutoDevSettingsState settings, @NotNull Function0<Unit> onModified) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(onModified, (String)"onModified");
        this.project = project;
        this.settings = settings;
        this.onModified = onModified;
    }

    public final boolean isCustomLLM(@NotNull String modelName) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
            if (StringsKt.startsWith$default((String)modelName, (String)"GitHub: ", (boolean)false, (int)2, null)) {
                return false;
            }
            List<LlmConfig> userModels = LlmConfig.Companion.load();
            Iterable $this$any$iv = userModels;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LlmConfig it = (LlmConfig)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)modelName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<ModelItem> getAllAvailableModels() {
        Iterable $this$forEach$iv;
        List models = new ArrayList();
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        if (manager.isInitialized()) {
            List<CopilotModel> githubModels;
            List<CopilotModel> list = githubModels = manager.getSupportedModels(false);
            if (list != null) {
                $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CopilotModel model = (CopilotModel)element$iv;
                    boolean bl = false;
                    models.add(new ModelItem("GitHub: " + model.getId(), model.getId(), false));
                }
            }
        }
        List<LlmConfig> userModels = LlmConfig.Companion.load();
        $this$forEach$iv = userModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LlmConfig llm = (LlmConfig)element$iv;
            boolean bl = false;
            models.add(new ModelItem(llm.getName(), llm.getName(), true));
        }
        return models;
    }

    @NotNull
    public final ModelLimits getUsedMaxToken() {
        AutoDevSettingsState settingsState = AutoDevSettingsState.Companion.getInstance();
        String modelId = settingsState.getDefaultModelId();
        if (((CharSequence)modelId).length() == 0 || Intrinsics.areEqual((Object)modelId, (Object)"Default")) {
            return new ModelLimits((Integer)settingsState.fetchMaxTokenLength(), (Integer)settingsState.fetchMaxTokenLength(), (Integer)settingsState.fetchMaxTokenLength(), null, null, 24, null);
        }
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        if (manager.isInitialized()) {
            CopilotModel githubModel;
            List<CopilotModel> githubModels;
            List<CopilotModel> list = githubModels = manager.getSupportedModels(false);
            if (list != null) {
                Object v1;
                block7: {
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        CopilotModel it = (CopilotModel)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)modelId)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                v2 = v1;
            } else {
                v2 = githubModel = null;
            }
            if (githubModel != null && githubModel.getCapabilities().getLimits() != null) {
                return githubModel.getCapabilities().getLimits();
            }
        }
        return new ModelLimits((Integer)settingsState.fetchMaxTokenLength(), (Integer)settingsState.fetchMaxTokenLength(), (Integer)settingsState.fetchMaxTokenLength(), null, null, 24, null);
    }

    @NotNull
    public final String getProviderFromModelId(@NotNull String modelId) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        if (((CharSequence)modelId).length() == 0 || Intrinsics.areEqual((Object)modelId, (Object)"Default")) {
            return "Default";
        }
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        if (manager.isInitialized()) {
            boolean isGithubModel;
            List<CopilotModel> githubModels;
            List<CopilotModel> list = githubModels = manager.getSupportedModels(false);
            if (list != null) {
                boolean bl;
                block9: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CopilotModel it = (CopilotModel)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)modelId)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                v2 = bl;
            } else {
                v2 = isGithubModel = false;
            }
            if (isGithubModel) {
                return modelId;
            }
        }
        return modelId;
    }

    public final void createNewLLM(@Nullable LlmConfig existingLlm) {
        LLMDialog dialog2 = new LLMDialog(this.project, this.settings, existingLlm, (Function0<Unit>)((Function0)() -> LLMModelManager.createNewLLM$lambda$5(this)));
        dialog2.show();
    }

    public static /* synthetic */ void createNewLLM$default(LLMModelManager lLMModelManager, LlmConfig llmConfig, int n, Object object) {
        if ((n & 1) != 0) {
            llmConfig = null;
        }
        lLMModelManager.createNewLLM(llmConfig);
    }

    public final void editLLMAtRow(@NotNull JTable table, int row) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = table.getValueAt(row, 0);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String modelName = string;
        if (this.isCustomLLM(modelName)) {
            Object v1;
            block5: {
                List<LlmConfig> userModels = LlmConfig.Companion.load();
                Iterable iterable = userModels;
                for (Object t : iterable) {
                    LlmConfig it = (LlmConfig)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)modelName)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            LlmConfig llmToEdit = v1;
            if (llmToEdit != null) {
                this.createNewLLM(llmToEdit);
            }
        } else {
            Messages.showInfoMessage((String)"GitHub Copilot models cannot be edited.", (String)"Read-only Model");
        }
    }

    public final void deleteLLMAtRow(@NotNull JTable table, int row) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = table.getValueAt(row, 0);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String modelName = string;
        if (this.isCustomLLM(modelName)) {
            int result = Messages.showYesNoDialog((String)("Are you sure you want to delete the LLM '" + modelName + "'?"), (String)"Delete LLM", (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                try {
                    List existingLlms = CollectionsKt.toMutableList((Collection)LlmConfig.Companion.load());
                    existingLlms.removeIf(arg_0 -> LLMModelManager.deleteLLMAtRow$lambda$8(arg_0 -> LLMModelManager.deleteLLMAtRow$lambda$7(modelName, arg_0), arg_0));
                    Json json = JsonKt.Json$default(null, LLMModelManager::deleteLLMAtRow$lambda$9, (int)1, null);
                    this.settings.setCustomLlms(json.encodeToString((SerializationStrategy)BuiltinSerializersKt.ListSerializer(LlmConfig.Companion.serializer()), (Object)existingLlms));
                    this.onModified.invoke();
                }
                catch (Exception e) {
                    Messages.showErrorDialog((String)("Error deleting LLM: " + e.getMessage()), (String)"Error");
                }
            }
        } else {
            Messages.showInfoMessage((String)"GitHub Copilot models cannot be deleted.", (String)"Read-only Model");
        }
    }

    public final void updateAllDropdowns(@NotNull ComboBox<ModelItem> defaultModelDropdown, @NotNull ComboBox<ModelItem> planLLMDropdown, @NotNull ComboBox<ModelItem> actLLMDropdown, @NotNull ComboBox<ModelItem> completionLLMDropdown, @NotNull ComboBox<ModelItem> embeddingLLMDropdown, @NotNull ComboBox<ModelItem> fastApplyLLMDropdown) {
        ModelItem modelItem;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(defaultModelDropdown, (String)"defaultModelDropdown");
        Intrinsics.checkNotNullParameter(planLLMDropdown, (String)"planLLMDropdown");
        Intrinsics.checkNotNullParameter(actLLMDropdown, (String)"actLLMDropdown");
        Intrinsics.checkNotNullParameter(completionLLMDropdown, (String)"completionLLMDropdown");
        Intrinsics.checkNotNullParameter(embeddingLLMDropdown, (String)"embeddingLLMDropdown");
        Intrinsics.checkNotNullParameter(fastApplyLLMDropdown, (String)"fastApplyLLMDropdown");
        defaultModelDropdown.removeAllItems();
        planLLMDropdown.removeAllItems();
        actLLMDropdown.removeAllItems();
        completionLLMDropdown.removeAllItems();
        embeddingLLMDropdown.removeAllItems();
        fastApplyLLMDropdown.removeAllItems();
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        List<CopilotModel> githubModels = manager.getSupportedModels(false);
        List<LlmConfig> userModels = LlmConfig.Companion.load();
        if (manager.isInitialized()) {
            List<CopilotModel> list = githubModels;
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CopilotModel model = (CopilotModel)element$iv;
                    boolean bl = false;
                    modelItem = new ModelItem("Github: " + model.getId(), model.getId(), false);
                    if (model.isEmbedding()) {
                        embeddingLLMDropdown.addItem((Object)modelItem);
                        continue;
                    }
                    defaultModelDropdown.addItem((Object)modelItem);
                    planLLMDropdown.addItem((Object)modelItem);
                    actLLMDropdown.addItem((Object)modelItem);
                    completionLLMDropdown.addItem((Object)modelItem);
                    fastApplyLLMDropdown.addItem((Object)modelItem);
                }
            }
        } else {
            BuildersKt.launch$default((CoroutineScope)AutoDevAppScope.Companion.workerScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(manager, embeddingLLMDropdown, defaultModelDropdown, planLLMDropdown, actLLMDropdown, completionLLMDropdown, fastApplyLLMDropdown, null){
                int label;
                final /* synthetic */ GithubCopilotManager $manager;
                final /* synthetic */ ComboBox<ModelItem> $embeddingLLMDropdown;
                final /* synthetic */ ComboBox<ModelItem> $defaultModelDropdown;
                final /* synthetic */ ComboBox<ModelItem> $planLLMDropdown;
                final /* synthetic */ ComboBox<ModelItem> $actLLMDropdown;
                final /* synthetic */ ComboBox<ModelItem> $completionLLMDropdown;
                final /* synthetic */ ComboBox<ModelItem> $fastApplyLLMDropdown;
                {
                    this.$manager = $manager;
                    this.$embeddingLLMDropdown = $embeddingLLMDropdown;
                    this.$defaultModelDropdown = $defaultModelDropdown;
                    this.$planLLMDropdown = $planLLMDropdown;
                    this.$actLLMDropdown = $actLLMDropdown;
                    this.$completionLLMDropdown = $completionLLMDropdown;
                    this.$fastApplyLLMDropdown = $fastApplyLLMDropdown;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                GithubCopilotManager.Companion.getInstance().initialize();
                                List<CopilotModel> freshGithubModels = this.$manager.getSupportedModels(false);
                                SwingUtilities.invokeLater(() -> updateAllDropdowns.2.invokeSuspend$lambda$1(freshGithubModels, this.$embeddingLLMDropdown, this.$defaultModelDropdown, this.$planLLMDropdown, this.$actLLMDropdown, this.$completionLLMDropdown, this.$fastApplyLLMDropdown));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$1$lambda$0$replaceOrAddModel(ComboBox<ModelItem> $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel, ModelItem newItem) {
                    int n = $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        ModelItem existingItem = (ModelItem)$this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.getItemAt(i);
                        if (!Intrinsics.areEqual((Object)existingItem.getModelId(), (Object)newItem.getModelId()) || !StringsKt.contains$default((CharSequence)existingItem.getDisplayName(), (CharSequence)"(loading...)", (boolean)false, (int)2, null)) continue;
                        $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.removeItemAt(i);
                        $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.insertItemAt((Object)newItem, i);
                        $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.setSelectedItem((Object)newItem);
                        return;
                    }
                    $this$invokeSuspend_u24lambda_u241_u24lambda_u240_u24replaceOrAddModel.addItem((Object)newItem);
                }

                private static final void invokeSuspend$lambda$1(List $freshGithubModels, ComboBox $embeddingLLMDropdown, ComboBox $defaultModelDropdown, ComboBox $planLLMDropdown, ComboBox $actLLMDropdown, ComboBox $completionLLMDropdown, ComboBox $fastApplyLLMDropdown) {
                    block2: {
                        List list = $freshGithubModels;
                        if (list == null) break block2;
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CopilotModel model = (CopilotModel)element$iv;
                            boolean bl = false;
                            ModelItem modelItem = new ModelItem("Github: " + model.getId(), model.getId(), false);
                            if (model.isEmbedding()) {
                                updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$embeddingLLMDropdown, modelItem);
                                continue;
                            }
                            updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$defaultModelDropdown, modelItem);
                            updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$planLLMDropdown, modelItem);
                            updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$actLLMDropdown, modelItem);
                            updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$completionLLMDropdown, modelItem);
                            updateAllDropdowns.2.invokeSuspend$lambda$1$lambda$0$replaceOrAddModel((ComboBox<ModelItem>)$fastApplyLLMDropdown, modelItem);
                        }
                    }
                }
            }), (int)3, null);
        }
        $this$forEach$iv = userModels;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LlmConfig llm = (LlmConfig)element$iv;
            boolean bl = false;
            modelItem = new ModelItem(llm.getName(), llm.getName(), true);
            if (WhenMappings.$EnumSwitchMapping$0[llm.getModelType().ordinal()] == 1) {
                embeddingLLMDropdown.addItem((Object)modelItem);
                continue;
            }
            defaultModelDropdown.addItem((Object)modelItem);
            planLLMDropdown.addItem((Object)modelItem);
            actLLMDropdown.addItem((Object)modelItem);
            completionLLMDropdown.addItem((Object)modelItem);
            fastApplyLLMDropdown.addItem((Object)modelItem);
        }
    }

    public final void setSelectedModels(@NotNull AutoDevSettingsState settings, @NotNull ComboBox<ModelItem> defaultModelDropdown, @NotNull ComboBox<ModelItem> planLLMDropdown, @NotNull ComboBox<ModelItem> actLLMDropdown, @NotNull ComboBox<ModelItem> completionLLMDropdown, @NotNull ComboBox<ModelItem> embeddingLLMDropdown, @NotNull ComboBox<ModelItem> fastApplyLLMDropdown) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(defaultModelDropdown, (String)"defaultModelDropdown");
        Intrinsics.checkNotNullParameter(planLLMDropdown, (String)"planLLMDropdown");
        Intrinsics.checkNotNullParameter(actLLMDropdown, (String)"actLLMDropdown");
        Intrinsics.checkNotNullParameter(completionLLMDropdown, (String)"completionLLMDropdown");
        Intrinsics.checkNotNullParameter(embeddingLLMDropdown, (String)"embeddingLLMDropdown");
        Intrinsics.checkNotNullParameter(fastApplyLLMDropdown, (String)"fastApplyLLMDropdown");
        LLMModelManager.setSelectedModels$selectModelById(defaultModelDropdown, settings.getDefaultModelId());
        LLMModelManager.setSelectedModels$selectModelById(planLLMDropdown, settings.getSelectedPlanModelId());
        LLMModelManager.setSelectedModels$selectModelById(actLLMDropdown, settings.getSelectedActModelId());
        LLMModelManager.setSelectedModels$selectModelById(completionLLMDropdown, settings.getSelectedCompletionModelId());
        LLMModelManager.setSelectedModels$selectModelById(embeddingLLMDropdown, settings.getSelectedEmbeddingModelId());
        LLMModelManager.setSelectedModels$selectModelById(fastApplyLLMDropdown, settings.getSelectedFastApplyModelId());
    }

    public final void updateLLMTable(@NotNull DefaultTableModel tableModel) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        tableModel.setRowCount(0);
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        List<CopilotModel> githubModels = manager.getSupportedModels(false);
        List<LlmConfig> userModels = LlmConfig.Companion.load();
        List<CopilotModel> list = githubModels;
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CopilotModel model = (CopilotModel)element$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{"Github: " + model.getId(), model.getId(), "true", "0.1", ""};
                tableModel.addRow(objectArray);
            }
        }
        $this$forEach$iv = userModels;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            Object modelValue;
            LlmConfig llm;
            block15: {
                block14: {
                    block13: {
                        Object object3;
                        block12: {
                            llm = (LlmConfig)element$iv;
                            boolean bl = false;
                            object3 = llm.getCustomRequest().getBody().get("model");
                            if (object3 == null) break block12;
                            JsonElement it = object3;
                            boolean bl2 = false;
                            String string = it instanceof JsonPrimitive ? ((JsonPrimitive)it).getContent() : StringsKt.removeSurrounding((String)it.toString(), (CharSequence)"\"");
                            object3 = string;
                            if (string != null) break block13;
                        }
                        object3 = modelValue = "";
                    }
                    if ((object2 = llm.getCustomRequest().getBody().get("temperature")) == null) break block14;
                    JsonElement it = object2;
                    boolean bl = false;
                    String string = it instanceof JsonPrimitive ? ((JsonPrimitive)it).getContent() : it.toString();
                    object2 = string;
                    if (string != null) break block15;
                }
                object2 = "0.0";
            }
            Object temperatureValue = object2;
            Object[] objectArray = new String[]{llm.getName(), modelValue, String.valueOf(llm.getCustomRequest().getStream()), temperatureValue, "Delete"};
            tableModel.addRow(objectArray);
        }
    }

    public final void testGitHubCopilotConnection() {
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)new CoroutineName("testGitHubCopilot")));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        provider = LLMProvider2.Companion.GithubCopilot$default(LLMProvider2.Companion, "gpt-4", false, null, 6, null);
                        this.label = 1;
                        v0 = LLMProvider2.request$default(provider, new Message("user", "Hello, this is a test message."), false, null, (Continuation)this, 6, null);
                        ** if (v0 != var5_2) goto lbl12
lbl11:
                        // 1 sources

                        return var5_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        response = (Flow)v0;
                        responseText = new Ref.ObjectRef();
                        responseText.element = "";
                        this.label = 2;
                        v1 = FlowKt.collectLatest((Flow)response, (Function2)((Function2)new Function2<SessionMessageItem<Message>, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)responseText, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Ref.ObjectRef<String> $responseText;
                            {
                                this.$responseText = $responseText;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SessionMessageItem it = (SessionMessageItem)this.L$0;
                                        this.$responseText.element = this.$responseText.element + ((Message)it.getChatMessage()).getContent();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(SessionMessageItem<Message> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl25
lbl24:
                        // 1 sources

                        return var5_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl31
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl31:
                            // 2 sources

                            Messages.showInfoMessage((String)"GitHub Copilot connection successful!", (String)"Test Result");
                        }
                        catch (Exception e) {
                            Messages.showErrorDialog((String)("GitHub Copilot connection failed: " + e.getMessage()), (String)"Test Failed");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void testCustomLLM(@NotNull LlmConfig llm) {
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)new CoroutineName("testCustomLLM")));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(llm, null){
            int label;
            final /* synthetic */ LlmConfig $llm;
            {
                this.$llm = $llm;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        provider = LLMProvider2.Companion.invoke(this.$llm.getUrl(), this.$llm.getAuth().getToken(), this.$llm.getResponseFormatByStream(), this.$llm.toLegacyRequestFormat());
                        this.label = 1;
                        v0 = LLMProvider2.request$default(provider, new Message("user", "Hello, this is a test message."), false, null, (Continuation)this, 6, null);
                        ** if (v0 != var5_2) goto lbl12
lbl11:
                        // 1 sources

                        return var5_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        response = (Flow)v0;
                        responseText = new Ref.ObjectRef();
                        responseText.element = "";
                        this.label = 2;
                        v1 = FlowKt.collectLatest((Flow)response, (Function2)((Function2)new Function2<SessionMessageItem<Message>, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)responseText, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Ref.ObjectRef<String> $responseText;
                            {
                                this.$responseText = $responseText;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SessionMessageItem it = (SessionMessageItem)this.L$0;
                                        this.$responseText.element = this.$responseText.element + ((Message)it.getChatMessage()).getContent();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(SessionMessageItem<Message> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl25
lbl24:
                        // 1 sources

                        return var5_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl31
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl31:
                            // 2 sources

                            Messages.showInfoMessage((String)("Connection to " + this.$llm.getName() + " successful!"), (String)"Test Result");
                        }
                        catch (Exception e) {
                            Messages.showErrorDialog((String)("Connection to " + this.$llm.getName() + " failed: " + e.getMessage()), (String)"Test Failed");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void refreshGitHubCopilotModels(@NotNull ComboBox<ModelItem> defaultModelDropdown, @NotNull ComboBox<ModelItem> planLLMDropdown, @NotNull ComboBox<ModelItem> actLLMDropdown, @NotNull ComboBox<ModelItem> completionLLMDropdown, @NotNull ComboBox<ModelItem> embeddingLLMDropdown, @NotNull ComboBox<ModelItem> fastApplyLLMDropdown, @NotNull DefaultTableModel tableModel) {
        Intrinsics.checkNotNullParameter(defaultModelDropdown, (String)"defaultModelDropdown");
        Intrinsics.checkNotNullParameter(planLLMDropdown, (String)"planLLMDropdown");
        Intrinsics.checkNotNullParameter(actLLMDropdown, (String)"actLLMDropdown");
        Intrinsics.checkNotNullParameter(completionLLMDropdown, (String)"completionLLMDropdown");
        Intrinsics.checkNotNullParameter(embeddingLLMDropdown, (String)"embeddingLLMDropdown");
        Intrinsics.checkNotNullParameter(fastApplyLLMDropdown, (String)"fastApplyLLMDropdown");
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        boolean $i$f$service = false;
        Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GithubCopilotManager manager = (GithubCopilotManager)object;
        BuildersKt.launch$default((CoroutineScope)AutoDevAppScope.Companion.workerScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(manager, this, defaultModelDropdown, planLLMDropdown, actLLMDropdown, completionLLMDropdown, embeddingLLMDropdown, fastApplyLLMDropdown, tableModel, null){
            int label;
            final /* synthetic */ GithubCopilotManager $manager;
            final /* synthetic */ LLMModelManager this$0;
            final /* synthetic */ ComboBox<ModelItem> $defaultModelDropdown;
            final /* synthetic */ ComboBox<ModelItem> $planLLMDropdown;
            final /* synthetic */ ComboBox<ModelItem> $actLLMDropdown;
            final /* synthetic */ ComboBox<ModelItem> $completionLLMDropdown;
            final /* synthetic */ ComboBox<ModelItem> $embeddingLLMDropdown;
            final /* synthetic */ ComboBox<ModelItem> $fastApplyLLMDropdown;
            final /* synthetic */ DefaultTableModel $tableModel;
            {
                this.$manager = $manager;
                this.this$0 = $receiver;
                this.$defaultModelDropdown = $defaultModelDropdown;
                this.$planLLMDropdown = $planLLMDropdown;
                this.$actLLMDropdown = $actLLMDropdown;
                this.$completionLLMDropdown = $completionLLMDropdown;
                this.$embeddingLLMDropdown = $embeddingLLMDropdown;
                this.$fastApplyLLMDropdown = $fastApplyLLMDropdown;
                this.$tableModel = $tableModel;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            this.$manager.getSupportedModels(true);
                            SwingUtilities.invokeLater(() -> refreshGitHubCopilotModels.1.invokeSuspend$lambda$0(this.this$0, this.$defaultModelDropdown, this.$planLLMDropdown, this.$actLLMDropdown, this.$completionLLMDropdown, this.$embeddingLLMDropdown, this.$fastApplyLLMDropdown, this.$tableModel));
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(() -> refreshGitHubCopilotModels.1.invokeSuspend$lambda$1(e));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(LLMModelManager this$0, ComboBox $defaultModelDropdown, ComboBox $planLLMDropdown, ComboBox $actLLMDropdown, ComboBox $completionLLMDropdown, ComboBox $embeddingLLMDropdown, ComboBox $fastApplyLLMDropdown, DefaultTableModel $tableModel) {
                this$0.updateAllDropdowns((ComboBox<ModelItem>)$defaultModelDropdown, (ComboBox<ModelItem>)$planLLMDropdown, (ComboBox<ModelItem>)$actLLMDropdown, (ComboBox<ModelItem>)$completionLLMDropdown, (ComboBox<ModelItem>)$embeddingLLMDropdown, (ComboBox<ModelItem>)$fastApplyLLMDropdown);
                this$0.updateLLMTable($tableModel);
                this$0.setSelectedModels(LLMModelManager.access$getSettings$p(this$0), (ComboBox<ModelItem>)$defaultModelDropdown, (ComboBox<ModelItem>)$planLLMDropdown, (ComboBox<ModelItem>)$actLLMDropdown, (ComboBox<ModelItem>)$completionLLMDropdown, (ComboBox<ModelItem>)$embeddingLLMDropdown, (ComboBox<ModelItem>)$fastApplyLLMDropdown);
                Messages.showInfoMessage((String)"GitHub Copilot models refreshed successfully!", (String)"Refresh Complete");
            }

            private static final void invokeSuspend$lambda$1(Exception $e) {
                Messages.showErrorDialog((String)("Failed to refresh GitHub Copilot models: " + $e.getMessage()), (String)"Refresh Failed");
            }
        }), (int)3, null);
    }

    private static final Unit createNewLLM$lambda$5(LLMModelManager this$0) {
        this$0.onModified.invoke();
        return Unit.INSTANCE;
    }

    private static final boolean deleteLLMAtRow$lambda$7(String $modelName, LlmConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$modelName);
    }

    private static final boolean deleteLLMAtRow$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit deleteLLMAtRow$lambda$9(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final void setSelectedModels$selectModelById(ComboBox<ModelItem> $this$setSelectedModels_u24selectModelById, String modelId) {
        boolean isUserCustomModel;
        block6: {
            if (((CharSequence)modelId).length() == 0) {
                return;
            }
            int n = $this$setSelectedModels_u24selectModelById.getItemCount();
            for (int i = 0; i < n; ++i) {
                ModelItem item = (ModelItem)$this$setSelectedModels_u24selectModelById.getItemAt(i);
                if (!Intrinsics.areEqual((Object)item.getModelId(), (Object)modelId)) continue;
                $this$setSelectedModels_u24selectModelById.setSelectedItem((Object)item);
                return;
            }
            List<LlmConfig> userModels = LlmConfig.Companion.load();
            Iterable $this$any$iv = userModels;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LlmConfig it = (LlmConfig)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)modelId)) continue;
                    v0 = true;
                    break block6;
                }
                v0 = isUserCustomModel = false;
            }
        }
        if (!isUserCustomModel && ((CharSequence)modelId).length() > 0) {
            ModelItem placeholderItem = new ModelItem("Github: " + modelId + " (loading...)", modelId, false);
            $this$setSelectedModels_u24selectModelById.addItem((Object)placeholderItem);
            $this$setSelectedModels_u24selectModelById.setSelectedItem((Object)placeholderItem);
        }
    }

    public static final /* synthetic */ AutoDevSettingsState access$getSettings$p(LLMModelManager $this) {
        return $this.settings;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/settings/model/LLMModelManager$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/settings/model/LLMModelManager;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMModelManager getInstance() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
            AutoDevSettingsState settings = AutoDevSettingsState.Companion.getInstance();
            return new LLMModelManager(project, settings, (Function0<Unit>)((Function0)Companion::getInstance$lambda$0));
        }

        private static final Unit getInstance$lambda$0() {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModelType.values().length];
            try {
                nArray[ModelType.Embedding.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

