/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.settings.dialog;

import cc.unitmesh.devti.llm2.LLMProvider2;
import cc.unitmesh.devti.llm2.SessionMessageItem;
import cc.unitmesh.devti.llm2.model.Auth;
import cc.unitmesh.devti.llm2.model.CustomRequest;
import cc.unitmesh.devti.llm2.model.LlmConfig;
import cc.unitmesh.devti.llm2.model.ModelType;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\bH\u0014J\b\u0010\u001c\u001a\u00020\bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/settings/dialog/QuickLLMSetupDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcc/unitmesh/devti/settings/AutoDevSettingsState;", "onSave", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/settings/AutoDevSettingsState;Lkotlin/jvm/functions/Function0;)V", "providerComboBox", "Ljavax/swing/JComboBox;", "", "kotlin.jvm.PlatformType", "nameField", "Lcom/intellij/ui/components/JBTextField;", "urlField", "tokenField", "modelField", "testButton", "Ljavax/swing/JButton;", "testResultLabel", "Lcom/intellij/ui/components/JBLabel;", "createCenterPanel", "Ljavax/swing/JPanel;", "updateFieldsForProvider", "doOKAction", "testConnection", "core"})
@SourceDebugExtension(value={"SMAP\nQuickLLMSetupDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickLLMSetupDialog.kt\ncc/unitmesh/devti/settings/dialog/QuickLLMSetupDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1747#2,3:327\n*S KotlinDebug\n*F\n+ 1 QuickLLMSetupDialog.kt\ncc/unitmesh/devti/settings/dialog/QuickLLMSetupDialog\n*L\n214#1:327,3\n*E\n"})
public final class QuickLLMSetupDialog
extends DialogWrapper {
    @Nullable
    private final Project project;
    @NotNull
    private final AutoDevSettingsState settings;
    @NotNull
    private final Function0<Unit> onSave;
    @NotNull
    private final JComboBox<String> providerComboBox;
    @NotNull
    private final JBTextField nameField;
    @NotNull
    private final JBTextField urlField;
    @NotNull
    private final JBTextField tokenField;
    @NotNull
    private final JBTextField modelField;
    @NotNull
    private final JButton testButton;
    @NotNull
    private final JBLabel testResultLabel;

    public QuickLLMSetupDialog(@Nullable Project project, @NotNull AutoDevSettingsState settings, @NotNull Function0<Unit> onSave) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
        super(project, true);
        this.project = project;
        this.settings = settings;
        this.onSave = onSave;
        String[] stringArray = new String[]{"OpenAI", "Azure OpenAI", "Anthropic Claude", "Google Gemini", "DeepSeek", "GLM (\u667a\u8c31\u6e05\u8a00)", "Qwen (\u901a\u4e49\u5343\u95ee)", "Moonshot (\u6708\u4e4b\u6697\u9762)", "Baichuan (\u767e\u5ddd)", "Ollama (Local)", "Custom"};
        this.providerComboBox = new JComboBox<String>(stringArray);
        this.nameField = new JBTextField();
        this.urlField = new JBTextField();
        this.tokenField = new JBTextField();
        this.modelField = new JBTextField();
        this.testButton = new JButton("Test Connection");
        this.testResultLabel = new JBLabel("");
        this.setTitle("Quick LLM Setup");
        this.init();
        this.providerComboBox.addActionListener(arg_0 -> QuickLLMSetupDialog._init_$lambda$0(this, arg_0));
        this.testButton.addActionListener(arg_0 -> QuickLLMSetupDialog._init_$lambda$1(this, arg_0));
        this.updateFieldsForProvider();
    }

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setPreferredSize(new Dimension(600, 500));
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)new JBLabel("Provider:"), (JComponent)this.providerComboBox).addSeparator().addLabeledComponent((JComponent)new JBLabel("Configuration Name:"), (JComponent)this.nameField).addLabeledComponent((JComponent)new JBLabel("API URL:"), (JComponent)this.urlField).addLabeledComponent((JComponent)new JBLabel("API Token:"), (JComponent)this.tokenField).addLabeledComponent((JComponent)new JBLabel("Model Name:"), (JComponent)this.modelField).addSeparator();
        JPanel testPanel = new JPanel();
        testPanel.add(this.testButton);
        testPanel.add((Component)this.testResultLabel);
        formBuilder.addLabeledComponent((JComponent)new JBLabel("Connection Test:"), (JComponent)testPanel);
        panel2.add((Component)formBuilder.getPanel(), "Center");
        return panel2;
    }

    private final void updateFieldsForProvider() {
        Object object = this.providerComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        switch ((String)object) {
            case "OpenAI": {
                this.nameField.setText("OpenAI GPT");
                this.urlField.setText("https://api.openai.com/v1/chat/completions");
                this.modelField.setText("gpt-3.5-turbo");
                this.tokenField.setText("");
                break;
            }
            case "Azure OpenAI": {
                this.nameField.setText("Azure OpenAI");
                this.urlField.setText("https://your-resource.openai.azure.com/openai/deployments/your-deployment/chat/completions?api-version=2023-05-15");
                this.modelField.setText("gpt-35-turbo");
                this.tokenField.setText("");
                break;
            }
            case "Anthropic Claude": {
                this.nameField.setText("Claude");
                this.urlField.setText("https://api.anthropic.com/v1/messages");
                this.modelField.setText("claude-3-sonnet-20240229");
                this.tokenField.setText("");
                break;
            }
            case "Google Gemini": {
                this.nameField.setText("Gemini");
                this.urlField.setText("https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent");
                this.modelField.setText("gemini-pro");
                this.tokenField.setText("");
                break;
            }
            case "DeepSeek": {
                this.nameField.setText("DeepSeek");
                this.urlField.setText("https://api.deepseek.com/v1/chat/completions");
                this.modelField.setText("deepseek-chat");
                this.tokenField.setText("");
                break;
            }
            case "GLM (\u667a\u8c31\u6e05\u8a00)": {
                this.nameField.setText("GLM");
                this.urlField.setText("https://open.bigmodel.cn/api/paas/v4/chat/completions");
                this.modelField.setText("glm-4");
                this.tokenField.setText("");
                break;
            }
            case "Qwen (\u901a\u4e49\u5343\u95ee)": {
                this.nameField.setText("Qwen");
                this.urlField.setText("https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation");
                this.modelField.setText("qwen-turbo");
                this.tokenField.setText("");
                break;
            }
            case "Moonshot (\u6708\u4e4b\u6697\u9762)": {
                this.nameField.setText("Moonshot");
                this.urlField.setText("https://api.moonshot.cn/v1/chat/completions");
                this.modelField.setText("moonshot-v1-8k");
                this.tokenField.setText("");
                break;
            }
            case "Baichuan (\u767e\u5ddd)": {
                this.nameField.setText("Baichuan");
                this.urlField.setText("https://api.baichuan-ai.com/v1/chat/completions");
                this.modelField.setText("Baichuan2-Turbo");
                this.tokenField.setText("");
                break;
            }
            case "Ollama (Local)": {
                this.nameField.setText("Ollama Local");
                this.urlField.setText("http://localhost:11434/v1/chat/completions");
                this.modelField.setText("llama2");
                this.tokenField.setText("");
                break;
            }
            case "Custom": {
                this.nameField.setText("Custom LLM");
                this.urlField.setText("");
                this.modelField.setText("");
                this.tokenField.setText("");
            }
        }
    }

    protected void doOKAction() {
        Object[] objectArray;
        block16: {
            block15: {
                String string = this.nameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string)) break block15;
                String string2 = this.urlField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string2)) break block15;
                String string3 = this.modelField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                if (!StringsKt.isBlank((CharSequence)string3)) break block16;
            }
            Messages.showErrorDialog((String)"Please fill in all required fields", (String)"Validation Error");
            return;
        }
        Object object = this.providerComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String provider = (String)object;
        String string = this.tokenField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string) && !CollectionsKt.listOf((Object[])(objectArray = new String[]{"Ollama (Local)", "Custom"})).contains(provider)) {
            Messages.showErrorDialog((String)"API Token is required for this provider", (String)"Validation Error");
            return;
        }
        try {
            boolean bl;
            List existingLlms;
            LlmConfig llmConfig;
            block14: {
                List list;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"model", (Object)JsonElementKt.JsonPrimitive((String)this.modelField.getText())), TuplesKt.to((Object)"temperature", (Object)JsonElementKt.JsonPrimitive((Number)0.0)), TuplesKt.to((Object)"stream", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
                CustomRequest customRequest = new CustomRequest(MapsKt.emptyMap(), MapsKt.mapOf((Pair[])pairArray), true);
                String string4 = this.nameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                String string5 = "Created by Quick Setup - " + provider;
                String string6 = this.urlField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
                String string7 = this.tokenField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
                llmConfig = new LlmConfig(string4, string5, string6, new Auth("Bearer", string7, 0, 4, null), 4096, customRequest, ModelType.Default, null, null, 384, null);
                try {
                    list = CollectionsKt.toMutableList((Collection)LlmConfig.Companion.load());
                }
                catch (Exception e) {
                    list = new ArrayList();
                }
                existingLlms = list;
                Iterable $this$any$iv = existingLlms;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LlmConfig it = (LlmConfig)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.nameField.getText())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Messages.showErrorDialog((String)"A configuration with this name already exists", (String)"Duplicate Name");
                return;
            }
            existingLlms.add(llmConfig);
            Json json = JsonKt.Json$default(null, QuickLLMSetupDialog::doOKAction$lambda$3, (int)1, null);
            this.settings.setCustomLlms(json.encodeToString((SerializationStrategy)BuiltinSerializersKt.ListSerializer(LlmConfig.Companion.serializer()), (Object)existingLlms));
            if (((CharSequence)this.settings.getDefaultModelId()).length() == 0) {
                String string8 = this.nameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
                this.settings.setDefaultModelId(string8);
                this.settings.setUseDefaultForAllCategories(true);
            }
            Messages.showInfoMessage((String)("LLM configuration '" + this.nameField.getText() + "' has been created successfully."), (String)"Configuration Added");
            this.onSave.invoke();
            super.doOKAction();
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)("Error creating LLM configuration: " + e.getMessage()), (String)"Error");
        }
    }

    private final void testConnection() {
        block6: {
            block5: {
                String string = this.urlField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string)) break block5;
                String string2 = this.modelField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!StringsKt.isBlank((CharSequence)string2)) break block6;
            }
            this.testResultLabel.setText("Please fill in URL and Model fields first");
            this.testResultLabel.setForeground((Color)JBColor.RED);
            return;
        }
        Object object = this.providerComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String provider = (String)object;
        String string = this.tokenField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            Object[] objectArray = new String[]{"Ollama (Local)", "Custom"};
            if (!CollectionsKt.listOf((Object[])objectArray).contains(provider)) {
                this.testResultLabel.setText("API Token is required for this provider");
                this.testResultLabel.setForeground((Color)JBColor.RED);
                return;
            }
        }
        this.testButton.setEnabled(false);
        this.testResultLabel.setText("Testing connection...");
        this.testResultLabel.setForeground((Color)JBColor.BLUE);
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)new CoroutineName("testConnection")));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ QuickLLMSetupDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = new Pair[]{TuplesKt.to((Object)"model", (Object)JsonElementKt.JsonPrimitive((String)QuickLLMSetupDialog.access$getModelField$p(this.this$0).getText())), TuplesKt.to((Object)"temperature", (Object)JsonElementKt.JsonPrimitive((Number)Boxing.boxDouble((double)0.0))), TuplesKt.to((Object)"stream", (Object)JsonElementKt.JsonPrimitive((Boolean)Boxing.boxBoolean((boolean)true)))};
                        customRequest = new CustomRequest(MapsKt.emptyMap(), MapsKt.mapOf((Pair[])var3_3), true);
                        var5_6 = QuickLLMSetupDialog.access$getNameField$p(this.this$0).getText();
                        if (StringsKt.isBlank((CharSequence)var5_6)) {
                            $i$a$-ifBlank-QuickLLMSetupDialog$testConnection$1$testConfig$1 = false;
                            v0 = "Test";
                        } else {
                            v0 = var5_6;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ifBlank(...)");
                        v1 = (String)v0;
                        v2 = QuickLLMSetupDialog.access$getUrlField$p(this.this$0).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                        v3 = QuickLLMSetupDialog.access$getTokenField$p(this.this$0).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
                        var7_9 = null;
                        var8_10 = 384;
                        var9_11 = null;
                        var10_12 = null;
                        var11_13 = ModelType.Default;
                        var12_14 = customRequest;
                        var13_15 = 4096;
                        var14_16 = new Auth("Bearer", v3, 0, 4, null);
                        var15_17 = v2;
                        var16_18 = "Test configuration";
                        var17_19 = v1;
                        testConfig = new LlmConfig(var17_19, var16_18, var15_17, var14_16, var13_15, var12_14, var11_13, var10_12, var9_11, var8_10, var7_9);
                        provider = LLMProvider2.Companion.invoke(testConfig.getUrl(), testConfig.getAuth().getToken(), testConfig.getResponseFormatByStream(), testConfig.toLegacyRequestFormat());
                        this.label = 1;
                        v4 = LLMProvider2.request$default(provider, new Message("user", "Hello, this is a test message."), testConfig.getCustomRequest().getStream(), null, (Continuation)this, 4, null);
                        ** if (v4 != var18_2) goto lbl38
lbl37:
                        // 1 sources

                        return var18_2;
lbl38:
                        // 1 sources

                        ** GOTO lbl44
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl44:
                        // 2 sources

                        response = (Flow)v4;
                        responseText = new Ref.ObjectRef();
                        responseText.element = "";
                        this.label = 2;
                        v5 = FlowKt.collectLatest((Flow)response, (Function2)((Function2)new Function2<SessionMessageItem<Message>, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)responseText, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Ref.ObjectRef<String> $responseText;
                            {
                                this.$responseText = $responseText;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SessionMessageItem it = (SessionMessageItem)this.L$0;
                                        this.$responseText.element = this.$responseText.element + ((Message)it.getChatMessage()).getContent();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(SessionMessageItem<Message> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v5 != var18_2) goto lbl51
lbl50:
                        // 1 sources

                        return var18_2;
lbl51:
                        // 1 sources

                        ** GOTO lbl57
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl57:
                            // 2 sources

                            SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$1(cc.unitmesh.devti.settings.dialog.QuickLLMSetupDialog ), ()V)((QuickLLMSetupDialog)this.this$0));
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$2(cc.unitmesh.devti.settings.dialog.QuickLLMSetupDialog java.lang.Exception ), ()V)((QuickLLMSetupDialog)this.this$0, (Exception)e));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1(QuickLLMSetupDialog this$0) {
                QuickLLMSetupDialog.access$getTestResultLabel$p(this$0).setText("Connection successful!");
                QuickLLMSetupDialog.access$getTestResultLabel$p(this$0).setForeground((Color)JBColor.GREEN);
                QuickLLMSetupDialog.access$getTestButton$p(this$0).setEnabled(true);
            }

            private static final void invokeSuspend$lambda$2(QuickLLMSetupDialog this$0, Exception $e) {
                QuickLLMSetupDialog.access$getTestResultLabel$p(this$0).setText("Connection failed: " + $e.getMessage());
                QuickLLMSetupDialog.access$getTestResultLabel$p(this$0).setForeground((Color)JBColor.RED);
                QuickLLMSetupDialog.access$getTestButton$p(this$0).setEnabled(true);
            }
        }), (int)3, null);
    }

    private static final void _init_$lambda$0(QuickLLMSetupDialog this$0, ActionEvent it) {
        this$0.updateFieldsForProvider();
    }

    private static final void _init_$lambda$1(QuickLLMSetupDialog this$0, ActionEvent it) {
        this$0.testConnection();
    }

    private static final Unit doOKAction$lambda$3(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JBTextField access$getModelField$p(QuickLLMSetupDialog $this) {
        return $this.modelField;
    }

    public static final /* synthetic */ JBTextField access$getNameField$p(QuickLLMSetupDialog $this) {
        return $this.nameField;
    }

    public static final /* synthetic */ JBTextField access$getUrlField$p(QuickLLMSetupDialog $this) {
        return $this.urlField;
    }

    public static final /* synthetic */ JBTextField access$getTokenField$p(QuickLLMSetupDialog $this) {
        return $this.tokenField;
    }

    public static final /* synthetic */ JBLabel access$getTestResultLabel$p(QuickLLMSetupDialog $this) {
        return $this.testResultLabel;
    }

    public static final /* synthetic */ JButton access$getTestButton$p(QuickLLMSetupDialog $this) {
        return $this.testButton;
    }
}

