/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.provider.runner;

import cc.unitmesh.devti.provider.runner.CheckExecutionListener;
import cc.unitmesh.devti.provider.runner.RunContext;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.OutputListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J4\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J6\u0010\u0005\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/provider/runner/ConfigurationRunner;", "", "runnerId", "", "Lorg/jetbrains/annotations/NonNls;", "executeRunConfigurations", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "testEventsListener", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerEventsAdapter;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "executeRunConfigures", "runContext", "Lcc/unitmesh/devti/provider/runner/RunContext;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "configurations", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerEventsListener;", "createRunContext", "processRunCompletionAction", "Lcom/intellij/execution/runners/ProgramRunner$Callback;", "startRunConfigurationExecution", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "core"})
public interface ConfigurationRunner {
    @NotNull
    public String runnerId();

    public void executeRunConfigurations(@NotNull Project var1, @NotNull RunnerAndConfigurationSettings var2, @Nullable SMTRunnerEventsAdapter var3, @Nullable ProgressIndicator var4);

    public void executeRunConfigures(@NotNull Project var1, @NotNull RunnerAndConfigurationSettings var2, @NotNull RunContext var3, @Nullable SMTRunnerEventsAdapter var4, @Nullable ProgressIndicator var5);

    public void executeRunConfigurations(@Nullable MessageBusConnection var1, @NotNull RunnerAndConfigurationSettings var2, @NotNull RunContext var3, @Nullable SMTRunnerEventsListener var4, @Nullable ProgressIndicator var5);

    @NotNull
    public RunContext createRunContext();

    @NotNull
    public ProgramRunner.Callback processRunCompletionAction(@NotNull RunContext var1);

    public boolean startRunConfigurationExecution(@NotNull RunnerAndConfigurationSettings var1, @NotNull RunContext var2) throws ExecutionException;

    public void executeRunConfigurations(@NotNull Project var1, @NotNull RunConfiguration var2);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nConfigurationRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationRunner.kt\ncc/unitmesh/devti/provider/runner/ConfigurationRunner$DefaultImpls\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n11#2:185\n11#2:186\n*S KotlinDebug\n*F\n+ 1 ConfigurationRunner.kt\ncc/unitmesh/devti/provider/runner/ConfigurationRunner$DefaultImpls\n*L\n176#1:185\n81#1:186\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static String runnerId(@NotNull ConfigurationRunner $this) {
            return "Run";
        }

        public static void executeRunConfigurations(@NotNull ConfigurationRunner $this, @NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, @Nullable SMTRunnerEventsAdapter testEventsListener2, @Nullable ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunContext runContext = $this.createRunContext();
            $this.executeRunConfigures(project, settings, runContext, testEventsListener2, indicator);
        }

        public static /* synthetic */ void executeRunConfigurations$default(ConfigurationRunner configurationRunner, Project project, RunnerAndConfigurationSettings runnerAndConfigurationSettings, SMTRunnerEventsAdapter sMTRunnerEventsAdapter, ProgressIndicator progressIndicator, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeRunConfigurations");
            }
            if ((n & 4) != 0) {
                sMTRunnerEventsAdapter = null;
            }
            if ((n & 8) != 0) {
                progressIndicator = null;
            }
            configurationRunner.executeRunConfigurations(project, runnerAndConfigurationSettings, sMTRunnerEventsAdapter, progressIndicator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void executeRunConfigures(@NotNull ConfigurationRunner $this, @NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, @NotNull RunContext runContext, @Nullable SMTRunnerEventsAdapter testEventsListener2, @Nullable ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            MessageBusConnection connection = project.getMessageBus().connect();
            try {
                $this.executeRunConfigurations(connection, settings, runContext, (SMTRunnerEventsListener)testEventsListener2, indicator);
                return;
            }
            finally {
                block3: {
                    MessageBusConnection messageBusConnection = connection;
                    if (messageBusConnection == null) break block3;
                    messageBusConnection.disconnect();
                }
            }
        }

        public static void executeRunConfigurations(@NotNull ConfigurationRunner $this, @Nullable MessageBusConnection connection, @NotNull RunnerAndConfigurationSettings configurations, @NotNull RunContext runContext, @Nullable SMTRunnerEventsListener testEventsListener2, @Nullable ProgressIndicator indicator) {
            SMTRunnerEventsListener it;
            Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
            Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            SMTRunnerEventsListener sMTRunnerEventsListener = testEventsListener2;
            if (sMTRunnerEventsListener != null) {
                it = sMTRunnerEventsListener;
                boolean bl = false;
                MessageBusConnection messageBusConnection = connection;
                if (messageBusConnection != null) {
                    Topic topic = SMTRunnerEventsListener.TEST_STATUS;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TEST_STATUS");
                    messageBusConnection.subscribe(topic, (Object)it);
                }
            }
            MessageBusConnection messageBusConnection = connection;
            if (messageBusConnection != null) {
                it = messageBusConnection;
                boolean bl = false;
                Disposer.register((Disposable)runContext, (Disposable)((Disposable)connection));
            }
            ActionsKt.runInEdt$default(null, () -> DefaultImpls.executeRunConfigurations$lambda$2($this, configurations, runContext, connection), (int)1, null);
            if (indicator != null) {
                boolean result;
                while (!indicator.isCanceled() && !(result = runContext.getLatch().await(100L, TimeUnit.MILLISECONDS))) {
                }
                if (indicator.isCanceled()) {
                    Disposer.dispose((Disposable)runContext);
                }
            }
        }

        @NotNull
        public static RunContext createRunContext(@NotNull ConfigurationRunner $this) {
            StringBuilder stderr = new StringBuilder();
            OutputListener processListener2 = new OutputListener(stderr){
                final /* synthetic */ StringBuilder $stderr;
                {
                    this.$stderr = $stderr;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (ProcessOutputType.isStderr(outputType)) {
                        this.$stderr.append(event.getText());
                    }
                }
            };
            RunContext runContext = new RunContext((ProcessListener)processListener2, null, new CountDownLatch(1), null, null, 24, null);
            return runContext;
        }

        @NotNull
        public static ProgramRunner.Callback processRunCompletionAction(@NotNull ConfigurationRunner $this, @NotNull RunContext runContext) {
            Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            return arg_0 -> DefaultImpls.processRunCompletionAction$lambda$5(runContext, arg_0);
        }

        public static boolean startRunConfigurationExecution(@NotNull ConfigurationRunner $this, @NotNull RunnerAndConfigurationSettings $receiver, @NotNull RunContext runContext) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            ProgramRunner runner = ProgramRunner.getRunner((String)$this.runnerId(), (RunProfile)((RunProfile)$receiver.getConfiguration()));
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getRunExecutorInstance(...)");
            ExecutionEnvironment env = ExecutionEnvironmentBuilder.Companion.create(executor, $receiver).activeTarget().build($this.processRunCompletionAction(runContext));
            if (runner == null || env.getState() == null) {
                runContext.getLatch().countDown();
                return false;
            }
            runContext.getEnvironments().add(env);
            try {
                runner.execute(env);
            }
            catch (ExecutionException e) {
                runContext.getLatch().countDown();
                throw e;
            }
            return true;
        }

        public static void executeRunConfigurations(@NotNull ConfigurationRunner $this, @NotNull Project project, @NotNull RunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            RunManager runManager = RunManager.Companion.getInstance(project);
            ConfigurationType configurationType = configuration.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
            String string = configuration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            RunnerAndConfigurationSettings settings = runManager.findConfigurationByTypeAndName(configurationType, string);
            if (settings == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ConfigurationRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to find test configuration for: " + configuration.getName());
                return;
            }
            DefaultImpls.executeRunConfigurations$default($this, project, settings, null, null, 12, null);
        }

        private static Unit executeRunConfigurations$lambda$2(ConfigurationRunner this$0, RunnerAndConfigurationSettings $configurations, RunContext $runContext, MessageBusConnection $connection) {
            try {
                this$0.startRunConfigurationExecution($configurations, $runContext);
                CheckExecutionListener handler = new CheckExecutionListener(this$0.runnerId(), $runContext);
                MessageBusConnection messageBusConnection = $connection;
                if (messageBusConnection != null) {
                    messageBusConnection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)handler);
                }
            }
            catch (ExecutionException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ConfigurationRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to start run configuration: " + $configurations.getName());
                $runContext.getLatch().countDown();
            }
            return Unit.INSTANCE;
        }

        private static void processRunCompletionAction$lambda$5$lambda$3(RunContentDescriptor $descriptor) {
            ExecutionManagerImpl.Companion.stopProcess($descriptor);
        }

        private static void processRunCompletionAction$lambda$5(RunContext $runContext, RunContentDescriptor descriptor) {
            block2: {
                if (descriptor == null) {
                    $runContext.getLatch().countDown();
                    return;
                }
                Disposer.register((Disposable)$runContext, () -> DefaultImpls.processRunCompletionAction$lambda$5$lambda$3(descriptor));
                ProcessHandler processHandler2 = descriptor.getProcessHandler();
                if (processHandler2 == null) break block2;
                processHandler2.addProcessListener((ProcessListener)new ProcessAdapter($runContext){
                    final /* synthetic */ RunContext $runContext;
                    {
                        this.$runContext = $runContext;
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$runContext.getLatch().countDown();
                    }
                });
                ProcessListener processListener2 = $runContext.getProcessListener();
                if (processListener2 != null) {
                    ProcessListener it = processListener2;
                    boolean bl = false;
                    processHandler2.addProcessListener(it);
                }
            }
        }
    }
}

