/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.process;

import cc.unitmesh.devti.process.KillProcessResponse;
import cc.unitmesh.devti.process.ProcessInfo;
import cc.unitmesh.devti.process.ProcessOutputStorage;
import cc.unitmesh.devti.process.ProcessStatus;
import cc.unitmesh.devti.process.ReadProcessOutputResponse;
import cc.unitmesh.devti.process.WriteProcessInputResponse;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\nJ&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ'\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#2\b\b\u0002\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\nJ\u0010\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\nJ\u0018\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010*\u001a\u00020%J \u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\b\b\u0002\u0010.\u001a\u00020%J,\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u00101\u001a\u00020%2\b\b\u0002\u00102\u001a\u00020%2\b\b\u0002\u00103\u001a\u00020\u001fJ\u0016\u00104\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\u0016\u00106\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\u000e\u00107\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\nJ\u0010\u00108\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0006\u00109\u001a\u00020\u001fJ\u000e\u0010:\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcc/unitmesh/devti/process/ProcessStateManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "processes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcc/unitmesh/devti/process/ProcessInfo;", "processHandlers", "Lcom/intellij/execution/process/ProcessHandler;", "processInputStreams", "Ljava/io/OutputStream;", "outputStorage", "Lcc/unitmesh/devti/process/ProcessOutputStorage;", "processIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "generateProcessId", "registerProcess", "", "processInfo", "processHandler", "inputStream", "updateProcessStatus", "processId", "status", "Lcc/unitmesh/devti/process/ProcessStatus;", "exitCode", "", "(Ljava/lang/String;Lcc/unitmesh/devti/process/ProcessStatus;Ljava/lang/Integer;)V", "getProcess", "getAllProcesses", "", "includeTerminated", "", "getProcessHandler", "getProcessInputStream", "killProcess", "Lcc/unitmesh/devti/process/KillProcessResponse;", "force", "writeProcessInput", "Lcc/unitmesh/devti/process/WriteProcessInputResponse;", "inputData", "appendNewline", "readProcessOutput", "Lcc/unitmesh/devti/process/ReadProcessOutputResponse;", "includeStdout", "includeStderr", "maxBytes", "appendStdout", "data", "appendStderr", "removeProcess", "cleanupProcess", "getRunningProcessesCount", "isProcessRunning", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nProcessStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessStateManager.kt\ncc/unitmesh/devti/process/ProcessStateManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n11#2:218\n1#3:219\n766#4:220\n857#4,2:221\n1774#4,4:223\n*S KotlinDebug\n*F\n+ 1 ProcessStateManager.kt\ncc/unitmesh/devti/process/ProcessStateManager\n*L\n16#1:218\n75#1:220\n75#1:221,2\n200#1:223,4\n*E\n"})
public final class ProcessStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, ProcessInfo> processes;
    @NotNull
    private final ConcurrentHashMap<String, ProcessHandler> processHandlers;
    @NotNull
    private final ConcurrentHashMap<String, OutputStream> processInputStreams;
    @NotNull
    private final ProcessOutputStorage outputStorage;
    @NotNull
    private final AtomicLong processIdCounter;

    public ProcessStateManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.processes = new ConcurrentHashMap();
        this.processHandlers = new ConcurrentHashMap();
        this.processInputStreams = new ConcurrentHashMap();
        this.outputStorage = new ProcessOutputStorage();
        this.processIdCounter = new AtomicLong(0L);
    }

    @NotNull
    public final String generateProcessId() {
        return "proc_" + System.currentTimeMillis() + "_" + this.processIdCounter.incrementAndGet();
    }

    public final void registerProcess(@NotNull ProcessInfo processInfo, @Nullable ProcessHandler processHandler2, @Nullable OutputStream inputStream) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        ((Map)this.processes).put(processInfo.getProcessId(), processInfo);
        ProcessHandler processHandler3 = processHandler2;
        if (processHandler3 != null) {
            it = processHandler3;
            boolean bl = false;
            ((Map)this.processHandlers).put(processInfo.getProcessId(), it);
        }
        OutputStream outputStream = inputStream;
        if (outputStream != null) {
            it = outputStream;
            boolean bl = false;
            ((Map)this.processInputStreams).put(processInfo.getProcessId(), it);
        }
        this.logger.info("Registered process: " + processInfo.getProcessId() + " - " + processInfo.getCommand());
    }

    public static /* synthetic */ void registerProcess$default(ProcessStateManager processStateManager, ProcessInfo processInfo, ProcessHandler processHandler2, OutputStream outputStream, int n, Object object) {
        if ((n & 2) != 0) {
            processHandler2 = null;
        }
        if ((n & 4) != 0) {
            outputStream = null;
        }
        processStateManager.registerProcess(processInfo, processHandler2, outputStream);
    }

    public final void updateProcessStatus(@NotNull String processId, @NotNull ProcessStatus status, @Nullable Integer exitCode2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            ProcessInfo processInfo = this.processes.get(processId);
            if (processInfo == null) break block1;
            ProcessInfo info = processInfo;
            boolean bl = false;
            ProcessStatus[] processStatusArray = new ProcessStatus[]{ProcessStatus.COMPLETED, ProcessStatus.FAILED, ProcessStatus.KILLED, ProcessStatus.TIMED_OUT};
            ProcessInfo updatedInfo = ProcessInfo.copy$default(info, null, null, null, status, exitCode2, 0L, CollectionsKt.listOf((Object[])processStatusArray).contains((Object)status) ? Long.valueOf(System.currentTimeMillis()) : info.getEndTime(), null, false, 0, false, 1959, null);
            ((Map)this.processes).put(processId, updatedInfo);
            this.logger.info("Updated process status: " + processId + " -> " + status + " (exit code: " + exitCode2 + ")");
            processStatusArray = new ProcessStatus[]{ProcessStatus.COMPLETED, ProcessStatus.FAILED, ProcessStatus.KILLED, ProcessStatus.TIMED_OUT};
            if (CollectionsKt.listOf((Object[])processStatusArray).contains((Object)status)) {
                this.cleanupProcess(processId);
            }
        }
    }

    public static /* synthetic */ void updateProcessStatus$default(ProcessStateManager processStateManager, String string, ProcessStatus processStatus, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        processStateManager.updateProcessStatus(string, processStatus, n);
    }

    @Nullable
    public final ProcessInfo getProcess(@NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        return this.processes.get(processId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessInfo> getAllProcesses(boolean includeTerminated) {
        List list;
        if (includeTerminated) {
            Collection<ProcessInfo> collection = this.processes.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            list = CollectionsKt.toList((Iterable)collection);
        } else {
            void $this$filterTo$iv$iv;
            Collection<ProcessInfo> collection = this.processes.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProcessInfo it = (ProcessInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getStatus() == ProcessStatus.RUNNING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    public static /* synthetic */ List getAllProcesses$default(ProcessStateManager processStateManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return processStateManager.getAllProcesses(bl);
    }

    @Nullable
    public final ProcessHandler getProcessHandler(@NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        return this.processHandlers.get(processId);
    }

    @Nullable
    public final OutputStream getProcessInputStream(@NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        return this.processInputStreams.get(processId);
    }

    @NotNull
    public final KillProcessResponse killProcess(@NotNull String processId, boolean force) {
        KillProcessResponse killProcessResponse;
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        ProcessHandler processHandler2 = this.processHandlers.get(processId);
        if (processHandler2 == null) {
            return new KillProcessResponse(false, "Process not found or already terminated");
        }
        try {
            if (force) {
                processHandler2.destroyProcess();
            } else {
                processHandler2.detachProcess();
            }
            ProcessStateManager.updateProcessStatus$default(this, processId, ProcessStatus.KILLED, null, 4, null);
            killProcessResponse = new KillProcessResponse(true, null, 2, null);
        }
        catch (Exception e) {
            this.logger.warn("Failed to kill process " + processId, (Throwable)e);
            killProcessResponse = new KillProcessResponse(false, "Failed to kill process: " + e.getMessage());
        }
        return killProcessResponse;
    }

    public static /* synthetic */ KillProcessResponse killProcess$default(ProcessStateManager processStateManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return processStateManager.killProcess(string, bl);
    }

    @NotNull
    public final WriteProcessInputResponse writeProcessInput(@NotNull String processId, @NotNull String inputData, boolean appendNewline) {
        WriteProcessInputResponse writeProcessInputResponse;
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        OutputStream inputStream = this.processInputStreams.get(processId);
        if (inputStream == null) {
            return new WriteProcessInputResponse(false, "Process not found or input stream not available");
        }
        try {
            String dataToWrite;
            String string = dataToWrite = appendNewline && !StringsKt.endsWith$default((String)inputData, (String)"\n", (boolean)false, (int)2, null) ? inputData + "\n" : inputData;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            inputStream.write(byArray);
            inputStream.flush();
            writeProcessInputResponse = new WriteProcessInputResponse(true, null, 2, null);
        }
        catch (Exception e) {
            this.logger.warn("Failed to write input to process " + processId, (Throwable)e);
            writeProcessInputResponse = new WriteProcessInputResponse(false, "Failed to write input: " + e.getMessage());
        }
        return writeProcessInputResponse;
    }

    public static /* synthetic */ WriteProcessInputResponse writeProcessInput$default(ProcessStateManager processStateManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return processStateManager.writeProcessInput(string, string2, bl);
    }

    @NotNull
    public final ReadProcessOutputResponse readProcessOutput(@NotNull String processId, boolean includeStdout, boolean includeStderr, int maxBytes) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        String stdout = includeStdout ? this.outputStorage.getStdout(processId, maxBytes) : "";
        String stderr = includeStderr ? this.outputStorage.getStderr(processId, maxBytes) : "";
        boolean hasMoreStdout = includeStdout ? this.outputStorage.hasMoreStdout(processId, maxBytes) : false;
        boolean hasMoreStderr = includeStderr ? this.outputStorage.hasMoreStderr(processId, maxBytes) : false;
        return new ReadProcessOutputResponse(stdout, stderr, hasMoreStdout || hasMoreStderr);
    }

    public static /* synthetic */ ReadProcessOutputResponse readProcessOutput$default(ProcessStateManager processStateManager, String string, boolean bl, boolean bl2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            n = 10000;
        }
        return processStateManager.readProcessOutput(string, bl, bl2, n);
    }

    public final void appendStdout(@NotNull String processId, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.outputStorage.appendStdout(processId, data);
    }

    public final void appendStderr(@NotNull String processId, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.outputStorage.appendStderr(processId, data);
    }

    public final void removeProcess(@NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        this.processes.remove(processId);
        this.cleanupProcess(processId);
        this.logger.info("Removed process: " + processId);
    }

    private final void cleanupProcess(String processId) {
        block2: {
            this.processHandlers.remove(processId);
            OutputStream outputStream = this.processInputStreams.remove(processId);
            if (outputStream == null) break block2;
            OutputStream stream2 = outputStream;
            boolean bl = false;
            try {
                stream2.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close input stream for process " + processId, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getRunningProcessesCount() {
        int n;
        Collection<ProcessInfo> collection = this.processes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl = false;
                if (!(it.getStatus() == ProcessStatus.RUNNING) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final boolean isProcessRunning(@NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        ProcessInfo processInfo = this.processes.get(processId);
        return (processInfo != null ? processInfo.getStatus() : null) == ProcessStatus.RUNNING;
    }

    @JvmStatic
    @NotNull
    public static final ProcessStateManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/process/ProcessStateManager$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/process/ProcessStateManager;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProcessStateManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProcessStateManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ProcessStateManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

