/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer.plan;

import cc.unitmesh.devti.observer.plan.AgentPlanStep;
import cc.unitmesh.devti.observer.plan.CodeFileLink;
import cc.unitmesh.devti.observer.plan.CodeFileLinkExtractor;
import cc.unitmesh.devti.observer.plan.PatternMatcher;
import cc.unitmesh.devti.observer.plan.TaskMarkers;
import cc.unitmesh.devti.observer.plan.TaskStatus;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/devti/observer/plan/TaskExtractor;", "", "documentContent", "", "<init>", "(Ljava/lang/String;)V", "codeFileLinkExtractor", "Lcc/unitmesh/devti/observer/plan/CodeFileLinkExtractor;", "extractTasks", "", "listNode", "Lorg/intellij/markdown/ast/ASTNode;", "taskList", "", "Lcc/unitmesh/devti/observer/plan/AgentPlanStep;", "core"})
@SourceDebugExtension(value={"SMAP\nMarkdownPlanParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/TaskExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1855#2:343\n1855#2,2:344\n1856#2:346\n*S KotlinDebug\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/TaskExtractor\n*L\n103#1:343\n139#1:344,2\n103#1:346\n*E\n"})
public final class TaskExtractor {
    @NotNull
    private final String documentContent;
    @NotNull
    private final CodeFileLinkExtractor codeFileLinkExtractor;

    public TaskExtractor(@NotNull String documentContent) {
        Intrinsics.checkNotNullParameter((Object)documentContent, (String)"documentContent");
        this.documentContent = documentContent;
        this.codeFileLinkExtractor = new CodeFileLinkExtractor();
    }

    public final void extractTasks(@NotNull ASTNode listNode, @NotNull List<AgentPlanStep> taskList) {
        Intrinsics.checkNotNullParameter((Object)listNode, (String)"listNode");
        Intrinsics.checkNotNullParameter(taskList, (String)"taskList");
        Iterable $this$forEach$iv = listNode.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            ASTNode item = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)item.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
            String taskText = ((Object)StringsKt.trim((CharSequence)((Object)ASTUtilKt.getTextInNode((ASTNode)item, (CharSequence)this.documentContent)).toString())).toString();
            int firstLineEnd = StringsKt.indexOf$default((CharSequence)taskText, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (firstLineEnd > 0) {
                String string2 = taskText.substring(0, firstLineEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            } else {
                string = taskText;
            }
            String taskLine = string;
            MatchResult taskMatch = Regex.find$default((Regex)PatternMatcher.INSTANCE.getTASK_PATTERN(), (CharSequence)taskLine, (int)0, (int)2, null);
            if (taskMatch != null) {
                String statusMarker = (String)taskMatch.getGroupValues().get(1);
                description = ((Object)StringsKt.trim((CharSequence)((String)taskMatch.getGroupValues().get(2)))).toString();
                List<CodeFileLink> codeFileLinks = this.codeFileLinkExtractor.extractCodeFileLinks((String)description);
                task = new AgentPlanStep((String)description, TaskMarkers.INSTANCE.isCompleted(statusMarker), TaskMarkers.INSTANCE.determineStatus(statusMarker), null, codeFileLinks, 8, null);
                taskList.add((AgentPlanStep)task);
            } else {
                description = taskLine;
                Regex regex = PatternMatcher.INSTANCE.getUNORDERED_ITEM_CLEANER();
                String cleanDescription = ((Object)StringsKt.trim((CharSequence)regex.replace(description, (String)(task = "")))).toString();
                if (((CharSequence)cleanDescription).length() > 0) {
                    List<CodeFileLink> codeFileLinks = this.codeFileLinkExtractor.extractCodeFileLinks(cleanDescription);
                    taskList.add(new AgentPlanStep(cleanDescription, false, TaskStatus.TODO, null, codeFileLinks, 8, null));
                }
            }
            Iterable $this$forEach$iv2 = item.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ASTNode childNode = (ASTNode)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)childNode.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST)) continue;
                this.extractTasks(childNode, taskList);
            }
        }
    }
}

