/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer.plan;

import cc.unitmesh.devti.observer.plan.BasicSectionInfo;
import cc.unitmesh.devti.observer.plan.DetailedSectionInfo;
import cc.unitmesh.devti.observer.plan.PatternMatcher;
import cc.unitmesh.devti.observer.plan.TaskMarkers;
import cc.unitmesh.devti.observer.plan.TaskStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcc/unitmesh/devti/observer/plan/PlanSectionVisitor;", "", "documentContent", "", "<init>", "(Ljava/lang/String;)V", "extractBasicSectionInfo", "Lcc/unitmesh/devti/observer/plan/BasicSectionInfo;", "sectionNode", "Lorg/intellij/markdown/ast/ASTNode;", "extractDetailedSectionInfo", "Lcc/unitmesh/devti/observer/plan/DetailedSectionInfo;", "listItemNode", "core"})
public final class PlanSectionVisitor {
    @NotNull
    private final String documentContent;

    public PlanSectionVisitor(@NotNull String documentContent) {
        Intrinsics.checkNotNullParameter((Object)documentContent, (String)"documentContent");
        this.documentContent = documentContent;
    }

    @Nullable
    public final BasicSectionInfo extractBasicSectionInfo(@NotNull ASTNode sectionNode) {
        BasicSectionInfo basicSectionInfo;
        MatchResult titleMatch;
        Intrinsics.checkNotNullParameter((Object)sectionNode, (String)"sectionNode");
        String sectionText = ((Object)StringsKt.trim((CharSequence)((Object)ASTUtilKt.getTextInNode((ASTNode)sectionNode, (CharSequence)this.documentContent)).toString())).toString();
        MatchResult matchResult = titleMatch = Regex.find$default((Regex)new Regex("^(\\d+)\\.\\s*(.+?)(?:\\s*" + TaskMarkers.INSTANCE.getCHECKMARK() + ")?$"), (CharSequence)sectionText, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            String title = ((Object)StringsKt.trim((CharSequence)((String)it.getGroupValues().get(2)))).toString();
            boolean completed = StringsKt.contains$default((CharSequence)sectionText, (CharSequence)TaskMarkers.INSTANCE.getCHECKMARK(), (boolean)false, (int)2, null);
            basicSectionInfo = new BasicSectionInfo(title, completed);
        } else {
            basicSectionInfo = null;
        }
        return basicSectionInfo;
    }

    @Nullable
    public final DetailedSectionInfo extractDetailedSectionInfo(@NotNull ASTNode listItemNode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)listItemNode, (String)"listItemNode");
        String fullText = ((Object)StringsKt.trim((CharSequence)((Object)ASTUtilKt.getTextInNode((ASTNode)listItemNode, (CharSequence)this.documentContent)).toString())).toString();
        int firstLineEnd = StringsKt.indexOf$default((CharSequence)fullText, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (firstLineEnd > 0) {
            String string2 = fullText.substring(0, firstLineEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = fullText;
        }
        String headerLine = string;
        MatchResult matchResult = Regex.find$default((Regex)PatternMatcher.INSTANCE.getSECTION_PATTERN(), (CharSequence)headerLine, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult headerMatch = matchResult;
        String title = ((Object)StringsKt.trim((CharSequence)((String)headerMatch.getGroupValues().get(3)))).toString();
        String startMarker = (String)headerMatch.getGroupValues().get(2);
        String endMarker = (String)headerMatch.getGroupValues().get(4);
        String statusMarker = ((CharSequence)startMarker).length() > 0 ? startMarker : endMarker;
        boolean completed = TaskMarkers.INSTANCE.isCompleted(statusMarker);
        TaskStatus status = TaskMarkers.INSTANCE.determineStatus(statusMarker);
        return new DetailedSectionInfo(title, completed, status);
    }
}

