/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer.plan;

import cc.unitmesh.devti.observer.plan.AgentPlanStep;
import cc.unitmesh.devti.observer.plan.AgentTaskEntry;
import cc.unitmesh.devti.observer.plan.BasicSectionInfo;
import cc.unitmesh.devti.observer.plan.CodeFileLink;
import cc.unitmesh.devti.observer.plan.DetailedPlanStructureInterpreter;
import cc.unitmesh.devti.observer.plan.PlanSectionVisitor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J&\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcc/unitmesh/devti/observer/plan/MarkdownPlanParser;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "markdownRootType", "Lorg/intellij/markdown/IElementType;", "markdownFlavor", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "interpretPlan", "", "Lcc/unitmesh/devti/observer/plan/AgentTaskEntry;", "content", "", "parseMarkdownDocument", "Lorg/intellij/markdown/ast/ASTNode;", "extractPlanStructure", "documentNode", "findTopLevelSections", "isSimplePlanStructure", "", "sectionNode", "interpretSimplePlanStructure", "", "sectionListNode", "planSections", "", "interpretDetailedPlanStructure", "parse", "formatPlanToMarkdown", "entries", "core"})
@SourceDebugExtension(value={"SMAP\nMarkdownPlanParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/MarkdownPlanParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,342:1\n766#2:343\n857#2,2:344\n2624#2,2:346\n1747#2,3:348\n2626#2:351\n1855#2,2:352\n1864#2,2:354\n1855#2:356\n1855#2,2:357\n1856#2:359\n1866#2:360\n11#3:361\n*S KotlinDebug\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/MarkdownPlanParser\n*L\n258#1:343\n258#1:344,2\n262#1:346,2\n264#1:348,3\n262#1:351\n274#1:352,2\n297#1:354,2\n299#1:356\n302#1:357,2\n299#1:359\n297#1:360\n223#1:361\n*E\n"})
public final class MarkdownPlanParser {
    @NotNull
    public static final MarkdownPlanParser INSTANCE = new MarkdownPlanParser();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final IElementType markdownRootType;
    @NotNull
    private static final GFMFlavourDescriptor markdownFlavor;

    private MarkdownPlanParser() {
    }

    @NotNull
    public final List<AgentTaskEntry> interpretPlan(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            ASTNode documentTree = this.parseMarkdownDocument(content);
            return this.extractPlanStructure(documentTree, content);
        }
        catch (Exception e) {
            logger.warn("\u65e0\u6cd5\u89e3\u6790markdown\u8ba1\u5212\u5185\u5bb9", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private final ASTNode parseMarkdownDocument(String content) {
        return MarkdownParser.parse$default((MarkdownParser)new MarkdownParser((MarkdownFlavourDescriptor)markdownFlavor), (IElementType)markdownRootType, (String)content, (boolean)false, (int)4, null);
    }

    private final List<AgentTaskEntry> extractPlanStructure(ASTNode documentNode, String content) {
        List planSections = new ArrayList();
        List<ASTNode> topLevelSections = this.findTopLevelSections(documentNode);
        if (!((Collection)topLevelSections).isEmpty()) {
            if (this.isSimplePlanStructure((ASTNode)CollectionsKt.first(topLevelSections), content)) {
                this.interpretSimplePlanStructure((ASTNode)CollectionsKt.first(topLevelSections), content, planSections);
            } else {
                this.interpretDetailedPlanStructure(documentNode, content, planSections);
            }
        }
        return planSections;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> findTopLevelSections(ASTNode documentNode) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = documentNode.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.ORDERED_LIST)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimplePlanStructure(ASTNode sectionNode, String content) {
        boolean bl;
        Iterable $this$none$iv = sectionNode.getChildren();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            ASTNode listItem = (ASTNode)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)listItem.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
                boolean bl3;
                Iterable $this$any$iv = listItem.getChildren();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ASTNode it = (ASTNode)element$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST)) continue;
                        return false;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private final void interpretSimplePlanStructure(ASTNode sectionListNode, String content, List<AgentTaskEntry> planSections) {
        PlanSectionVisitor sectionVisitor = new PlanSectionVisitor(content);
        Iterable $this$forEach$iv = sectionListNode.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicSectionInfo sectionInfo;
            ASTNode item = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)item.getType(), (Object)MarkdownElementTypes.LIST_ITEM) || (sectionInfo = sectionVisitor.extractBasicSectionInfo(item)) == null) continue;
            planSections.add(new AgentTaskEntry(sectionInfo.getTitle(), CollectionsKt.emptyList(), sectionInfo.getCompleted(), null, null, 24, null));
        }
    }

    private final void interpretDetailedPlanStructure(ASTNode documentNode, String content, List<AgentTaskEntry> planSections) {
        DetailedPlanStructureInterpreter planStructureInterpreter = new DetailedPlanStructureInterpreter(content);
        planStructureInterpreter.interpretDocument(documentNode, planSections);
    }

    @NotNull
    public final List<AgentTaskEntry> parse(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.interpretPlan(content);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatPlanToMarkdown(@NotNull List<AgentTaskEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        StringBuilder stringBuilder = new StringBuilder();
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AgentTaskEntry agentTaskEntry = (AgentTaskEntry)item$iv;
            int index = n;
            boolean bl = false;
            stringBuilder.append(index + 1 + ". " + entry.getTitle() + "\n");
            Iterable $this$forEach$iv = entry.getSteps();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                AgentPlanStep step = (AgentPlanStep)element$iv;
                boolean bl2 = false;
                if (!((Collection)step.getCodeFileLinks()).isEmpty()) {
                    String text = null;
                    text = step.getStep();
                    Iterable $this$forEach$iv2 = step.getCodeFileLinks();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CodeFileLink link = (CodeFileLink)element$iv2;
                        boolean bl3 = false;
                        text = StringsKt.replace$default((String)text, (String)("[" + link.getDisplayText() + "](" + link.getFilePath() + ")"), (String)("[" + link.getDisplayText() + "](" + link.getFilePath() + ")"), (boolean)false, (int)4, null);
                    }
                    string = text;
                } else {
                    string = step.getStep();
                }
                String stepText = string;
                stringBuilder.append("   - [" + (step.getCompleted() ? "x" : " ") + "] " + stepText + "\n");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownPlanParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkdownPlanParser.logger = logger;
        markdownRootType = new IElementType("ROOT");
        markdownFlavor = new GFMFlavourDescriptor(false, false, false, 7, null);
    }
}

