/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer.plan;

import cc.unitmesh.devti.observer.plan.AgentTaskEntry;
import cc.unitmesh.devti.observer.plan.DetailedSectionInfo;
import cc.unitmesh.devti.observer.plan.MutableSectionContext;
import cc.unitmesh.devti.observer.plan.PlanSectionVisitor;
import cc.unitmesh.devti.observer.plan.TaskExtractor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.ast.visitors.Visitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/observer/plan/DetailedPlanStructureInterpreter;", "", "documentContent", "", "<init>", "(Ljava/lang/String;)V", "sectionVisitor", "Lcc/unitmesh/devti/observer/plan/PlanSectionVisitor;", "taskExtractor", "Lcc/unitmesh/devti/observer/plan/TaskExtractor;", "currentSection", "Lcc/unitmesh/devti/observer/plan/MutableSectionContext;", "interpretDocument", "", "documentNode", "Lorg/intellij/markdown/ast/ASTNode;", "planSections", "", "Lcc/unitmesh/devti/observer/plan/AgentTaskEntry;", "processOrderedList", "listNode", "processUnorderedList", "finalizeCurrentSection", "core"})
@SourceDebugExtension(value={"SMAP\nMarkdownPlanParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/DetailedPlanStructureInterpreter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1855#2:343\n1855#2,2:344\n1856#2:346\n*S KotlinDebug\n*F\n+ 1 MarkdownPlanParser.kt\ncc/unitmesh/devti/observer/plan/DetailedPlanStructureInterpreter\n*L\n177#1:343\n188#1:344,2\n177#1:346\n*E\n"})
public final class DetailedPlanStructureInterpreter {
    @NotNull
    private final String documentContent;
    @NotNull
    private final PlanSectionVisitor sectionVisitor;
    @NotNull
    private final TaskExtractor taskExtractor;
    @Nullable
    private MutableSectionContext currentSection;

    public DetailedPlanStructureInterpreter(@NotNull String documentContent) {
        Intrinsics.checkNotNullParameter((Object)documentContent, (String)"documentContent");
        this.documentContent = documentContent;
        this.sectionVisitor = new PlanSectionVisitor(this.documentContent);
        this.taskExtractor = new TaskExtractor(this.documentContent);
    }

    public final void interpretDocument(@NotNull ASTNode documentNode, @NotNull List<AgentTaskEntry> planSections) {
        Intrinsics.checkNotNullParameter((Object)documentNode, (String)"documentNode");
        Intrinsics.checkNotNullParameter(planSections, (String)"planSections");
        ASTNodeKt.accept((ASTNode)documentNode, (Visitor)((Visitor)new RecursiveVisitor(this, planSections){
            final /* synthetic */ DetailedPlanStructureInterpreter this$0;
            final /* synthetic */ List<AgentTaskEntry> $planSections;
            {
                this.this$0 = $receiver;
                this.$planSections = $planSections;
            }

            public void visitNode(ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                IElementType iElementType = node.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    DetailedPlanStructureInterpreter.access$processOrderedList(this.this$0, node, this.$planSections);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    DetailedPlanStructureInterpreter.access$processUnorderedList(this.this$0, node);
                } else {
                    super.visitNode(node);
                }
            }
        }));
        this.finalizeCurrentSection(planSections);
    }

    private final void processOrderedList(ASTNode listNode, List<AgentTaskEntry> planSections) {
        Iterable $this$forEach$iv = listNode.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DetailedSectionInfo sectionInfo;
            ASTNode item = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)item.getType(), (Object)MarkdownElementTypes.LIST_ITEM) || (sectionInfo = this.sectionVisitor.extractDetailedSectionInfo(item)) == null) continue;
            this.finalizeCurrentSection(planSections);
            this.currentSection = new MutableSectionContext(sectionInfo.getTitle(), sectionInfo.getCompleted(), sectionInfo.getStatus(), null, 8, null);
            Iterable $this$forEach$iv2 = item.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ASTNode childNode = (ASTNode)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)childNode.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST)) continue;
                this.processUnorderedList(childNode);
            }
        }
    }

    private final void processUnorderedList(ASTNode listNode) {
        block0: {
            MutableSectionContext mutableSectionContext = this.currentSection;
            if (mutableSectionContext == null) break block0;
            MutableSectionContext section = mutableSectionContext;
            boolean bl = false;
            this.taskExtractor.extractTasks(listNode, section.getTasks());
        }
    }

    private final void finalizeCurrentSection(List<AgentTaskEntry> planSections) {
        block0: {
            MutableSectionContext mutableSectionContext = this.currentSection;
            if (mutableSectionContext == null) break block0;
            MutableSectionContext section = mutableSectionContext;
            boolean bl = false;
            AgentTaskEntry plan = new AgentTaskEntry(section.getTitle(), section.getTasks(), section.getCompleted(), section.getStatus(), null, 16, null);
            plan.updateCompletionStatus();
            planSections.add(plan);
            this.currentSection = null;
        }
    }

    public static final /* synthetic */ void access$processOrderedList(DetailedPlanStructureInterpreter $this, ASTNode listNode, List planSections) {
        $this.processOrderedList(listNode, planSections);
    }

    public static final /* synthetic */ void access$processUnorderedList(DetailedPlanStructureInterpreter $this, ASTNode listNode) {
        $this.processUnorderedList(listNode);
    }
}

