/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer.agent;

import cc.unitmesh.devti.agent.tool.AgentTool;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.llms.tokenizer.Tokenizer;
import cc.unitmesh.devti.llms.tokenizer.TokenizerFactory;
import cc.unitmesh.devti.observer.agent.AgentState;
import cc.unitmesh.devti.observer.plan.AgentTaskEntry;
import cc.unitmesh.devti.observer.plan.MarkdownPlanParser;
import cc.unitmesh.devti.observer.plan.PlanUpdateListener;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import cc.unitmesh.devti.util.PatchConverter;
import cc.unitmesh.devti.util.parser.MarkdownCodeHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u0004\u0018\u00010\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001cJ\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\u001cJ\u0014\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\"J\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020$J\u0006\u0010/\u001a\u00020\u001aJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020*0)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcc/unitmesh/devti/observer/agent/AgentStateService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "maxToken", "", "getMaxToken", "()I", "state", "Lcc/unitmesh/devti/observer/agent/AgentState;", "getState", "()Lcc/unitmesh/devti/observer/agent/AgentState;", "setState", "(Lcc/unitmesh/devti/observer/agent/AgentState;)V", "tokenizer", "Lkotlin/Lazy;", "Lcc/unitmesh/devti/llms/tokenizer/Tokenizer;", "getTokenizer", "()Lkotlin/Lazy;", "setTokenizer", "(Lkotlin/Lazy;)V", "addTools", "", "tools", "", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "addToChange", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "buildOriginIntention", "", "getAllMessages", "Lcc/unitmesh/devti/llms/custom/Message;", "processMessages", "messages", "updatePlan", "items", "", "Lcc/unitmesh/devti/observer/plan/AgentTaskEntry;", "content", "resetMessages", "addMessage", "message", "resetState", "getPlan", "core"})
@SourceDebugExtension(value={"SMAP\nAgentStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentStateService.kt\ncc/unitmesh/devti/observer/agent/AgentStateService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,131:1\n1549#2:132\n1620#2,3:133\n288#2,2:138\n1549#2:140\n1620#2,3:141\n11#3:136\n11#3:137\n*S KotlinDebug\n*F\n+ 1 AgentStateService.kt\ncc/unitmesh/devti/observer/agent/AgentStateService\n*L\n30#1:132\n30#1:133,3\n61#1:138,2\n85#1:140\n85#1:141,3\n34#1:136\n55#1:137\n*E\n"})
public final class AgentStateService {
    @NotNull
    private final Project project;
    private final int maxToken;
    @NotNull
    private AgentState state;
    @NotNull
    private Lazy<? extends Tokenizer> tokenizer;

    public AgentStateService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.maxToken = AutoDevSettingsState.Companion.getMaxTokenLength();
        this.state = new AgentState(null, null, null, null, null, null, null, 127, null);
        this.tokenizer = LazyKt.lazy(AgentStateService::tokenizer$lambda$0);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final int getMaxToken() {
        return this.maxToken;
    }

    @NotNull
    public final AgentState getState() {
        return this.state;
    }

    public final void setState(@NotNull AgentState agentState) {
        Intrinsics.checkNotNullParameter((Object)agentState, (String)"<set-?>");
        this.state = agentState;
    }

    @NotNull
    public final Lazy<Tokenizer> getTokenizer() {
        return this.tokenizer;
    }

    public final void setTokenizer(@NotNull Lazy<? extends Tokenizer> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.tokenizer = lazy;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTools(@NotNull List<? extends BuiltinCommand> tools) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Iterable iterable = tools;
        AgentState agentState = this.state;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BuiltinCommand builtinCommand = (BuiltinCommand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AgentTool(it.getCommandName(), it.getDescription(), "", false, null, null, false, null, 248, null));
        }
        agentState.setUsedTools((List)destination$iv$iv);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AgentStateService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Called agent tools:\n " + CollectionsKt.joinToString$default((Iterable)this.state.getUsedTools(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    public final void addToChange(@NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        String string = this.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        File baseDir = new File(string);
        if (patch.getAfterName() != null) {
            String string2 = patch.getAfterName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAfterName(...)");
            String newChangePath = PatchConverter.INSTANCE.getAbsolutePath(baseDir, string2).getCanonicalPath();
            this.state.getChanges().removeIf(arg_0 -> AgentStateService.addToChange$lambda$3(arg_0 -> AgentStateService.addToChange$lambda$2(newChangePath, arg_0), arg_0));
        }
        try {
            Change change = PatchConverter.INSTANCE.createChange(this.project, patch);
            this.state.getChanges().add(change);
            ((PlanUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PlanUpdateListener.Companion.getTOPIC())).onUpdateChange(this.state.getChanges());
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AgentStateService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info((Throwable)e);
        }
    }

    @Nullable
    public final String buildOriginIntention() {
        String intention;
        Object v1;
        block2: {
            Iterable $this$firstOrNull$iv = this.state.getMessages();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Message it = (Message)element$iv;
                boolean bl = false;
                String string = it.getRole().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)"user")) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Message message = v1;
        String string = intention = message != null ? message.getContent() : null;
        if (intention != null) {
            this.state.setOriginIntention(intention);
        }
        return intention;
    }

    @NotNull
    public final List<Message> getAllMessages() {
        return this.state.getMessages();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Message> processMessages(@NotNull List<Message> messages) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        int countLength = ((Tokenizer)this.tokenizer.getValue()).count(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, AgentStateService::processMessages$lambda$5, (int)30, null));
        if (countLength < this.maxToken) {
            this.state.setMessages(messages);
            return messages;
        }
        Iterable iterable = messages;
        AgentState agentState = this.state;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Message.copy$default((Message)it, null, MarkdownCodeHelper.INSTANCE.removeAllMarkdownCode(it.getContent()), 1, null));
        }
        agentState.setMessages((List)destination$iv$iv);
        return this.state.getMessages();
    }

    public final void updatePlan(@NotNull List<AgentTaskEntry> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.state.setPlan(items);
        ((PlanUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PlanUpdateListener.Companion.getTOPIC())).onPlanUpdate(items);
    }

    public final void updatePlan(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        List<AgentTaskEntry> planItems = MarkdownPlanParser.INSTANCE.parse(content);
        this.updatePlan(CollectionsKt.toMutableList((Collection)planItems));
    }

    public final void resetMessages() {
        this.state = AgentState.copy$default(this.state, null, null, null, CollectionsKt.emptyList(), null, null, null, 119, null);
    }

    public final void addMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.state = AgentState.copy$default(this.state, null, null, null, CollectionsKt.plus((Collection)this.state.getMessages(), (Object)message), null, null, null, 119, null);
    }

    public final void resetState() {
        this.state = new AgentState(null, null, null, null, null, null, null, 127, null);
        PlanUpdateListener syncPublisher = (PlanUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PlanUpdateListener.Companion.getTOPIC());
        syncPublisher.onUpdateChange(new ArrayList());
        syncPublisher.onPlanUpdate(new ArrayList());
    }

    @NotNull
    public final List<AgentTaskEntry> getPlan() {
        return this.state.getPlan();
    }

    private static final Tokenizer tokenizer$lambda$0() {
        return TokenizerFactory.INSTANCE.createTokenizer();
    }

    private static final boolean addToChange$lambda$2(String $newChangePath, Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ContentRevision afterRevision = it.getAfterRevision();
        return afterRevision != null && Intrinsics.areEqual((Object)new File(afterRevision.getFile().getPath()).getCanonicalPath(), (Object)$newChangePath);
    }

    private static final boolean addToChange$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence processMessages$lambda$5(Message it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }
}

