/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.flow.kanban.impl.GitHubIssue;
import cc.unitmesh.devti.provider.observer.AgentObserver;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.push.GitPushListener;
import git4idea.push.GitPushRepoResult;
import git4idea.repo.GitRepository;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u0017H\u0002J \u0010,\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020\u000fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcc/unitmesh/devti/observer/PipelineStatusProcessor;", "Lcc/unitmesh/devti/provider/observer/AgentObserver;", "Lgit4idea/push/GitPushListener;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "monitoringJob", "Ljava/util/concurrent/ScheduledFuture;", "timeoutMinutes", "", "project", "Lcom/intellij/openapi/project/Project;", "onCompleted", "", "repository", "Lgit4idea/repo/GitRepository;", "pushResult", "Lgit4idea/push/GitPushRepoResult;", "onRegister", "startMonitoring", "commitSha", "", "remoteUrl", "findWorkflowRunForCommit", "Lorg/kohsuke/github/GHWorkflowRun;", "checkWorkflowStatus", "", "workflowRun", "handleWorkflowFailure", "getWorkflowFailureDetails", "Lcc/unitmesh/devti/observer/PipelineStatusProcessor$WorkflowFailureDetails;", "extractFailedSteps", "", "job", "Lorg/kohsuke/github/GHWorkflowJob;", "getJobLogsFromAPI", "getWorkflowLogsFromAPI", "extractLogsFromZipStream", "zipStream", "Ljava/util/zip/ZipInputStream;", "isPermissionError", "errorMessage", "buildDetailedFailureMessage", "failureDetails", "stopMonitoring", "WorkflowFailureDetails", "JobFailure", "core"})
@SourceDebugExtension(value={"SMAP\nPipelineStatusProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PipelineStatusProcessor.kt\ncc/unitmesh/devti/observer/PipelineStatusProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,344:1\n1#2:345\n766#3:346\n857#3,2:347\n1549#3:349\n1620#3,3:350\n766#3:353\n857#3,2:354\n1549#3:356\n1620#3,3:357\n1855#3:362\n1855#3,2:363\n1856#3:367\n1313#4,2:360\n1313#4,2:365\n1313#4,2:368\n*S KotlinDebug\n*F\n+ 1 PipelineStatusProcessor.kt\ncc/unitmesh/devti/observer/PipelineStatusProcessor\n*L\n180#1:346\n180#1:347,2\n181#1:349\n181#1:350,3\n203#1:353\n203#1:354,2\n204#1:356\n204#1:357,3\n289#1:362\n298#1:363,2\n289#1:367\n258#1:360,2\n307#1:365,2\n319#1:368,2\n*E\n"})
public final class PipelineStatusProcessor
implements AgentObserver,
GitPushListener {
    @NotNull
    private final Logger log;
    @Nullable
    private ScheduledFuture<?> monitoringJob;
    private final int timeoutMinutes;
    @Nullable
    private Project project;

    public PipelineStatusProcessor() {
        Logger logger = Logger.getInstance(PipelineStatusProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.timeoutMinutes = 35;
    }

    public void onCompleted(@NotNull GitRepository repository, @NotNull GitPushRepoResult pushResult) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pushResult, (String)"pushResult");
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project != null) {
            Project currentProject = project;
            boolean bl = false;
            this.project = currentProject;
            if (!((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(currentProject).getState()).getEnableObserver()) {
                return;
            }
            if (pushResult.getType() != GitPushRepoResult.Type.SUCCESS) {
                this.log.info("Push failed, skipping pipeline monitoring");
                return;
            }
            String string = repository.getCurrentRevision();
            if (string != null) {
                String latestCommit = string;
                boolean bl2 = false;
                this.log.info("Push successful, starting pipeline monitoring for commit: " + latestCommit);
                String string2 = GitHubIssue.Companion.parseGitHubRemoteUrl(repository);
                if (string2 != null) {
                    String remoteUrl = string2;
                    boolean bl3 = false;
                    this.startMonitoring(repository, latestCommit, remoteUrl);
                } else {
                    this.log.warn("No GitHub remote URL found");
                }
            } else {
                this.log.warn("Could not determine latest commit SHA");
            }
        } else {
            this.log.warn("Cannot get project from component: " + this);
        }
    }

    @Override
    public void onRegister(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void startMonitoring(GitRepository repository, String commitSha, String remoteUrl) {
        this.log.info("Starting pipeline monitoring for commit: " + commitSha);
        Ref.IntRef workflowNotFoundCount = new Ref.IntRef();
        int maxWorkflowNotFoundAttempts = 3;
        long startTime = System.currentTimeMillis();
        this.monitoringJob = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> PipelineStatusProcessor.startMonitoring$lambda$6(startTime, this, commitSha, remoteUrl, workflowNotFoundCount, maxWorkflowNotFoundAttempts), 4L, 5L, TimeUnit.MINUTES);
    }

    private final GHWorkflowRun findWorkflowRunForCommit(String remoteUrl, String commitSha) {
        GHWorkflowRun gHWorkflowRun;
        try {
            Object object;
            block8: {
                block6: {
                    List allRuns;
                    block7: {
                        Object v3;
                        Iterable iterable;
                        block5: {
                            Project project = this.project;
                            Intrinsics.checkNotNull((Object)project);
                            GHRepository gHRepository = GitHubIssue.Companion.getGitHubRepository(project, remoteUrl);
                            if (gHRepository == null) break block6;
                            GHRepository ghRepository = gHRepository;
                            boolean bl = false;
                            PagedIterator pagedIterator = ghRepository.queryWorkflowRuns().list().iterator();
                            Intrinsics.checkNotNullExpressionValue((Object)pagedIterator, (String)"iterator(...)");
                            allRuns = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.asSequence((Iterator)((Iterator)pagedIterator)), (int)50));
                            iterable = allRuns;
                            for (Object t : iterable) {
                                GHWorkflowRun it = (GHWorkflowRun)t;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getHeadSha(), (Object)commitSha)) continue;
                                v3 = t;
                                break block5;
                            }
                            v3 = null;
                        }
                        if ((object = (GHWorkflowRun)v3) == null) break block7;
                        Iterable matchingRun = iterable = object;
                        boolean bl = false;
                        this.log.info("Found workflow run for commit " + commitSha + ": " + matchingRun.getName() + " (" + matchingRun.getStatus() + ")");
                        object = iterable;
                        if (object != null) break block8;
                    }
                    PipelineStatusProcessor $this$findWorkflowRunForCommit_u24lambda_u2410_u24lambda_u249 = this;
                    boolean bl = false;
                    $this$findWorkflowRunForCommit_u24lambda_u2410_u24lambda_u249.log.debug("No workflow run found for commit " + commitSha + " in recent " + allRuns.size() + " runs");
                    object = null;
                    break block8;
                }
                object = null;
            }
            gHWorkflowRun = object;
        }
        catch (Exception e) {
            this.log.error("Error finding workflow run for commit: " + commitSha, (Throwable)e);
            gHWorkflowRun = null;
        }
        return gHWorkflowRun;
    }

    private final boolean checkWorkflowStatus(GHWorkflowRun workflowRun, String commitSha) {
        GHWorkflowRun.Status status = workflowRun.getStatus();
        return switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
            case 1 -> {
                GHWorkflowRun.Conclusion v1 = workflowRun.getConclusion();
                switch (v1 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                    case 1: {
                        yield true;
                    }
                    case 2: {
                        this.handleWorkflowFailure(workflowRun, commitSha);
                        yield true;
                    }
                    case 3: 
                    case 4: {
                        yield true;
                    }
                }
                this.log.info("Workflow completed with conclusion: " + workflowRun.getConclusion());
                yield false;
            }
            case 2, 3 -> false;
            default -> false;
        };
    }

    private final void handleWorkflowFailure(GHWorkflowRun workflowRun, String commitSha) {
        block4: {
            try {
                WorkflowFailureDetails failureDetails = this.getWorkflowFailureDetails(workflowRun);
                String detailedMessage = this.buildDetailedFailureMessage(workflowRun, commitSha, failureDetails);
                Project project = this.project;
                if (project == null) break block4;
                Project it = project;
                boolean bl = false;
                AutoDevNotifications.INSTANCE.error(it, detailedMessage);
            }
            catch (Exception e) {
                boolean bl;
                String string = e.getMessage();
                if (string != null) {
                    String $this$handleWorkflowFailure_u24lambda_u2412 = string;
                    boolean bl2 = false;
                    bl = StringsKt.contains((CharSequence)$this$handleWorkflowFailure_u24lambda_u2412, (CharSequence)"admin rights", (boolean)true) || StringsKt.contains((CharSequence)$this$handleWorkflowFailure_u24lambda_u2412, (CharSequence)"403", (boolean)true);
                } else {
                    bl = false;
                }
                boolean isPermissionError = bl;
                String fallbackMessage = isPermissionError ? StringsKt.trimMargin$default((String)("\n                |\u274c GitHub Action failed for commit: " + StringsKt.take((String)commitSha, (int)7) + " - " + workflowRun.getConclusion() + "\n                |\u26a0\ufe0f Detailed logs unavailable - admin rights required\n                |View details at: " + workflowRun.getHtmlUrl() + "\n                "), null, (int)1, null) : StringsKt.trimMargin$default((String)("\n                |\u274c GitHub Action failed for commit: " + StringsKt.take((String)commitSha, (int)7) + " - " + workflowRun.getConclusion() + "\n                |URL: " + workflowRun.getHtmlUrl() + "\n                |Error getting details: " + e.getMessage() + "\n                "), null, (int)1, null);
                Project project = this.project;
                if (project == null) break block4;
                Project it = project;
                boolean bl3 = false;
                AutoDevNotifications.INSTANCE.error(it, fallbackMessage);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WorkflowFailureDetails getWorkflowFailureDetails(GHWorkflowRun workflowRun) {
        WorkflowFailureDetails workflowFailureDetails;
        try {
            void $this$mapTo$iv$iv;
            GHWorkflowJob it;
            Iterable $this$filterTo$iv$iv;
            PagedIterable pagedIterable = workflowRun.listJobs();
            Intrinsics.checkNotNullExpressionValue((Object)pagedIterable, (String)"listJobs(...)");
            Iterable $this$filter$iv = (Iterable)pagedIterable;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GHWorkflowJob)element$iv$iv;
                boolean bl = false;
                if (!(it.getConclusion() == GHWorkflowRun.Conclusion.FAILURE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GHWorkflowJob)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Intrinsics.checkNotNull((Object)it);
                URL uRL = it.getHtmlUrl();
                collection.add(new JobFailure(string, this.extractFailedSteps(it), this.getJobLogsFromAPI(it), uRL != null ? uRL.toString() : null));
            }
            List failedJobs = (List)destination$iv$iv;
            workflowFailureDetails = !((Collection)failedJobs).isEmpty() ? new WorkflowFailureDetails(CollectionsKt.toMutableList((Collection)failedJobs), null, null, 6, null) : new WorkflowFailureDetails(null, this.getWorkflowLogsFromAPI(workflowRun), null, 5, null);
        }
        catch (Exception e) {
            this.log.error("Error getting workflow failure details", (Throwable)e);
            workflowFailureDetails = new WorkflowFailureDetails(null, null, e.getMessage(), 3, null);
        }
        return workflowFailureDetails;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> extractFailedSteps(GHWorkflowJob job) {
        List list;
        try {
            void $this$mapTo$iv$iv;
            GHWorkflowJob.Step it;
            Iterable $this$filterTo$iv$iv;
            List list2 = job.getSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSteps(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GHWorkflowJob.Step)element$iv$iv;
                boolean bl = false;
                if (!(it.getConclusion() == GHWorkflowRun.Conclusion.FAILURE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void step;
                it = (GHWorkflowJob.Step)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(step.getName() + ": " + step.getConclusion() + " (" + step.getNumber() + ")");
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            this.log.error("Error extracting failed steps", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getJobLogsFromAPI(GHWorkflowJob job) {
        String string;
        try {
            string = (String)job.downloadLogs(PipelineStatusProcessor::getJobLogsFromAPI$lambda$19);
        }
        catch (Exception e) {
            String string2;
            if (this.isPermissionError(e.getMessage())) {
                this.log.info("Admin rights required to download job logs. Falling back to alternative approach.");
                string2 = StringsKt.trimMargin$default((String)("\n                |\u26a0\ufe0f Job logs unavailable - admin rights required to download logs from GitHub Actions.\n                |Job URL: " + job.getHtmlUrl() + "\n                |You can view the logs directly at: " + job.getHtmlUrl() + "\n                "), null, (int)1, null);
            } else {
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    private final String getWorkflowLogsFromAPI(GHWorkflowRun workflowRun) {
        String string;
        try {
            string = (String)workflowRun.downloadLogs(arg_0 -> PipelineStatusProcessor.getWorkflowLogsFromAPI$lambda$21(this, arg_0));
        }
        catch (Exception e) {
            String string2;
            this.log.warn("Cannot download workflow logs - " + e.getMessage());
            if (this.isPermissionError(e.getMessage())) {
                this.log.info("Admin rights required to download workflow logs.");
                string2 = StringsKt.trimMargin$default((String)("\n                |\u26a0\ufe0f Workflow logs unavailable - admin rights required to download logs from GitHub Actions.\n                |Workflow URL: " + workflowRun.getHtmlUrl() + "\n                |You can view the logs directly at: " + workflowRun.getHtmlUrl() + "\n                "), null, (int)1, null);
            } else {
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    private final String extractLogsFromZipStream(ZipInputStream zipStream) {
        StringBuilder logContents = new StringBuilder();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.generateSequence(() -> PipelineStatusProcessor.extractLogsFromZipStream$lambda$22(zipStream)), PipelineStatusProcessor::extractLogsFromZipStream$lambda$23);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ZipEntry entry = (ZipEntry)element$iv;
            boolean bl = false;
            String content = new String(ByteStreamsKt.readBytes((InputStream)zipStream), Charsets.UTF_8);
            logContents.append("=== " + entry.getName() + " ===\n").append(content).append("\n\n");
        }
        String string = logContents.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isPermissionError(String errorMessage) {
        boolean bl;
        String string = errorMessage;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = StringsKt.contains((CharSequence)it, (CharSequence)"admin rights", (boolean)true) || StringsKt.contains((CharSequence)it, (CharSequence)"403", (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildDetailedFailureMessage(GHWorkflowRun workflowRun, String commitSha, WorkflowFailureDetails failureDetails) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildDetailedFailureMessage_u24lambda_u2435 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildDetailedFailureMessage_u24lambda_u2435.append("\u274c GitHub Action failed for commit: " + StringsKt.take((String)commitSha, (int)7) + "\n");
        $this$buildDetailedFailureMessage_u24lambda_u2435.append("Workflow: " + workflowRun.getName() + "\n");
        $this$buildDetailedFailureMessage_u24lambda_u2435.append("URL: " + workflowRun.getHtmlUrl() + "\n\n");
        if (failureDetails.getError() != null) {
            $this$buildDetailedFailureMessage_u24lambda_u2435.append("Error getting details: " + failureDetails.getError() + "\n");
        } else if (!((Collection)failureDetails.getFailedJobs()).isEmpty()) {
            $this$buildDetailedFailureMessage_u24lambda_u2435.append("Failed Jobs:\n");
            Iterable $this$forEach$iv = failureDetails.getFailedJobs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                JobFailure jobFailure = (JobFailure)element$iv;
                boolean bl2 = false;
                $this$buildDetailedFailureMessage_u24lambda_u2435.append("\u2022 " + jobFailure.getJobName() + "\n");
                if (jobFailure.getJobUrl() != null) {
                    String it;
                    boolean bl3 = false;
                    $this$buildDetailedFailureMessage_u24lambda_u2435.append("  URL: " + it + "\n");
                }
                if (!((Collection)jobFailure.getErrorSteps()).isEmpty()) {
                    $this$buildDetailedFailureMessage_u24lambda_u2435.append("  Failed steps:\n");
                    Iterable $this$forEach$iv2 = jobFailure.getErrorSteps();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String step = (String)element$iv2;
                        boolean bl4 = false;
                        $this$buildDetailedFailureMessage_u24lambda_u2435.append("    - " + step + "\n");
                    }
                }
                if ((object = jobFailure.getLogs()) != null) {
                    Object object2 = object;
                    String it = object2;
                    boolean bl5 = false;
                    object = !StringsKt.isBlank((CharSequence)it) ? object2 : null;
                    if (object != null) {
                        void $this$forEach$iv3;
                        Object logs = object;
                        boolean bl6 = false;
                        $this$buildDetailedFailureMessage_u24lambda_u2435.append("  Logs:\n");
                        Sequence bl4 = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)((CharSequence)logs)), PipelineStatusProcessor::buildDetailedFailureMessage$lambda$35$lambda$32$lambda$31$lambda$29);
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            String line = (String)element$iv3;
                            boolean bl7 = false;
                            $this$buildDetailedFailureMessage_u24lambda_u2435.append("    " + line + "\n");
                        }
                    }
                }
                $this$buildDetailedFailureMessage_u24lambda_u2435.append("\n");
            }
        } else if (failureDetails.getWorkflowLogs() != null) {
            $this$buildDetailedFailureMessage_u24lambda_u2435.append("Workflow Logs:\n");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)failureDetails.getWorkflowLogs()), PipelineStatusProcessor::buildDetailedFailureMessage$lambda$35$lambda$33);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl8 = false;
                $this$buildDetailedFailureMessage_u24lambda_u2435.append("  " + line + "\n");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void stopMonitoring() {
        ScheduledFuture<?> scheduledFuture = this.monitoringJob;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.monitoringJob = null;
        this.log.info("Pipeline monitoring stopped");
    }

    @Override
    public void sendErrorNotification(@NotNull Project project, @NotNull String prompt2) {
        AgentObserver.DefaultImpls.sendErrorNotification(this, project, prompt2);
    }

    private static final void startMonitoring$lambda$6(long $startTime, PipelineStatusProcessor this$0, String $commitSha, String $remoteUrl, Ref.IntRef $workflowNotFoundCount, int $maxWorkflowNotFoundAttempts) {
        try {
            long elapsedMinutes = (System.currentTimeMillis() - $startTime) / (long)60000;
            if (elapsedMinutes >= (long)this$0.timeoutMinutes) {
                this$0.log.info("Pipeline monitoring timeout reached for commit: " + $commitSha);
                this$0.stopMonitoring();
                return;
            }
            GHWorkflowRun gHWorkflowRun = this$0.findWorkflowRunForCommit($remoteUrl, $commitSha);
            if (gHWorkflowRun != null) {
                GHWorkflowRun workflowRun = gHWorkflowRun;
                boolean bl = false;
                $workflowNotFoundCount.element = 0;
                boolean isComplete = this$0.checkWorkflowStatus(workflowRun, $commitSha);
                if (isComplete) {
                    this$0.stopMonitoring();
                }
            } else {
                PipelineStatusProcessor $this$startMonitoring_u24lambda_u246_u24lambda_u244 = this$0;
                boolean bl = false;
                int n = $workflowNotFoundCount.element;
                $workflowNotFoundCount.element = n + 1;
                $this$startMonitoring_u24lambda_u246_u24lambda_u244.log.info("Workflow not found for " + $remoteUrl + " commit: " + $commitSha + " (attempt " + $workflowNotFoundCount.element + "/" + $maxWorkflowNotFoundAttempts + ")");
                if ($workflowNotFoundCount.element >= $maxWorkflowNotFoundAttempts) {
                    $this$startMonitoring_u24lambda_u246_u24lambda_u244.log.info("No workflow found after " + $maxWorkflowNotFoundAttempts + " attempts, stopping monitoring");
                    $this$startMonitoring_u24lambda_u246_u24lambda_u244.stopMonitoring();
                }
            }
        }
        catch (Exception e) {
            this$0.log.error("Error monitoring pipeline for commit: " + $commitSha, (Throwable)e);
            Project project = this$0.project;
            if (project != null) {
                Project currentProject = project;
                boolean bl = false;
                AutoDevNotifications.INSTANCE.notify(currentProject, "Error monitoring GitHub Action: " + e.getMessage(), NotificationType.ERROR);
            }
            this$0.stopMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getJobLogsFromAPI$lambda$19(InputStream logStream) {
        String string;
        Closeable closeable = logStream;
        Throwable throwable = null;
        try {
            InputStream stream2 = (InputStream)closeable;
            boolean bl = false;
            string = TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(stream2)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getWorkflowLogsFromAPI$lambda$21(PipelineStatusProcessor this$0, InputStream logStream) {
        String string;
        Closeable closeable = new ZipInputStream(logStream);
        Throwable throwable = null;
        try {
            ZipInputStream zipStream = (ZipInputStream)closeable;
            boolean bl = false;
            string = this$0.extractLogsFromZipStream(zipStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private static final ZipEntry extractLogsFromZipStream$lambda$22(ZipInputStream $zipStream) {
        return $zipStream.getNextEntry();
    }

    private static final boolean extractLogsFromZipStream$lambda$23(ZipEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".txt", (boolean)false, (int)2, null);
    }

    private static final boolean buildDetailedFailureMessage$lambda$35$lambda$32$lambda$31$lambda$29(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final boolean buildDetailedFailureMessage$lambda$35$lambda$33(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/observer/PipelineStatusProcessor$JobFailure;", "", "jobName", "", "errorSteps", "", "logs", "jobUrl", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getJobName", "()Ljava/lang/String;", "getErrorSteps", "()Ljava/util/List;", "getLogs", "getJobUrl", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class JobFailure {
        @NotNull
        private final String jobName;
        @NotNull
        private final List<String> errorSteps;
        @Nullable
        private final String logs;
        @Nullable
        private final String jobUrl;

        public JobFailure(@NotNull String jobName, @NotNull List<String> errorSteps, @Nullable String logs, @Nullable String jobUrl) {
            Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
            Intrinsics.checkNotNullParameter(errorSteps, (String)"errorSteps");
            this.jobName = jobName;
            this.errorSteps = errorSteps;
            this.logs = logs;
            this.jobUrl = jobUrl;
        }

        public /* synthetic */ JobFailure(String string, List list, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(string, list, string2, string3);
        }

        @NotNull
        public final String getJobName() {
            return this.jobName;
        }

        @NotNull
        public final List<String> getErrorSteps() {
            return this.errorSteps;
        }

        @Nullable
        public final String getLogs() {
            return this.logs;
        }

        @Nullable
        public final String getJobUrl() {
            return this.jobUrl;
        }

        @NotNull
        public final String component1() {
            return this.jobName;
        }

        @NotNull
        public final List<String> component2() {
            return this.errorSteps;
        }

        @Nullable
        public final String component3() {
            return this.logs;
        }

        @Nullable
        public final String component4() {
            return this.jobUrl;
        }

        @NotNull
        public final JobFailure copy(@NotNull String jobName, @NotNull List<String> errorSteps, @Nullable String logs, @Nullable String jobUrl) {
            Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
            Intrinsics.checkNotNullParameter(errorSteps, (String)"errorSteps");
            return new JobFailure(jobName, errorSteps, logs, jobUrl);
        }

        public static /* synthetic */ JobFailure copy$default(JobFailure jobFailure, String string, List list, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = jobFailure.jobName;
            }
            if ((n & 2) != 0) {
                list = jobFailure.errorSteps;
            }
            if ((n & 4) != 0) {
                string2 = jobFailure.logs;
            }
            if ((n & 8) != 0) {
                string3 = jobFailure.jobUrl;
            }
            return jobFailure.copy(string, list, string2, string3);
        }

        @NotNull
        public String toString() {
            return "JobFailure(jobName=" + this.jobName + ", errorSteps=" + this.errorSteps + ", logs=" + this.logs + ", jobUrl=" + this.jobUrl + ")";
        }

        public int hashCode() {
            int result = this.jobName.hashCode();
            result = result * 31 + ((Object)this.errorSteps).hashCode();
            result = result * 31 + (this.logs == null ? 0 : this.logs.hashCode());
            result = result * 31 + (this.jobUrl == null ? 0 : this.jobUrl.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JobFailure)) {
                return false;
            }
            JobFailure jobFailure = (JobFailure)other;
            if (!Intrinsics.areEqual((Object)this.jobName, (Object)jobFailure.jobName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.errorSteps, jobFailure.errorSteps)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logs, (Object)jobFailure.logs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.jobUrl, (Object)jobFailure.jobUrl);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GHWorkflowRun.Conclusion.values().length];
            try {
                nArray[GHWorkflowRun.Conclusion.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHWorkflowRun.Conclusion.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHWorkflowRun.Conclusion.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHWorkflowRun.Conclusion.TIMED_OUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GHWorkflowRun.Status.values().length];
            try {
                nArray[GHWorkflowRun.Status.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHWorkflowRun.Status.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHWorkflowRun.Status.QUEUED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/observer/PipelineStatusProcessor$WorkflowFailureDetails;", "", "failedJobs", "", "Lcc/unitmesh/devti/observer/PipelineStatusProcessor$JobFailure;", "workflowLogs", "", "error", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getFailedJobs", "()Ljava/util/List;", "getWorkflowLogs", "()Ljava/lang/String;", "getError", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class WorkflowFailureDetails {
        @NotNull
        private final List<JobFailure> failedJobs;
        @Nullable
        private final String workflowLogs;
        @Nullable
        private final String error;

        public WorkflowFailureDetails(@NotNull List<JobFailure> failedJobs, @Nullable String workflowLogs, @Nullable String error) {
            Intrinsics.checkNotNullParameter(failedJobs, (String)"failedJobs");
            this.failedJobs = failedJobs;
            this.workflowLogs = workflowLogs;
            this.error = error;
        }

        public /* synthetic */ WorkflowFailureDetails(List list, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(list, string, string2);
        }

        @NotNull
        public final List<JobFailure> getFailedJobs() {
            return this.failedJobs;
        }

        @Nullable
        public final String getWorkflowLogs() {
            return this.workflowLogs;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<JobFailure> component1() {
            return this.failedJobs;
        }

        @Nullable
        public final String component2() {
            return this.workflowLogs;
        }

        @Nullable
        public final String component3() {
            return this.error;
        }

        @NotNull
        public final WorkflowFailureDetails copy(@NotNull List<JobFailure> failedJobs, @Nullable String workflowLogs, @Nullable String error) {
            Intrinsics.checkNotNullParameter(failedJobs, (String)"failedJobs");
            return new WorkflowFailureDetails(failedJobs, workflowLogs, error);
        }

        public static /* synthetic */ WorkflowFailureDetails copy$default(WorkflowFailureDetails workflowFailureDetails, List list, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                list = workflowFailureDetails.failedJobs;
            }
            if ((n & 2) != 0) {
                string = workflowFailureDetails.workflowLogs;
            }
            if ((n & 4) != 0) {
                string2 = workflowFailureDetails.error;
            }
            return workflowFailureDetails.copy(list, string, string2);
        }

        @NotNull
        public String toString() {
            return "WorkflowFailureDetails(failedJobs=" + this.failedJobs + ", workflowLogs=" + this.workflowLogs + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = ((Object)this.failedJobs).hashCode();
            result = result * 31 + (this.workflowLogs == null ? 0 : this.workflowLogs.hashCode());
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WorkflowFailureDetails)) {
                return false;
            }
            WorkflowFailureDetails workflowFailureDetails = (WorkflowFailureDetails)other;
            if (!Intrinsics.areEqual(this.failedJobs, workflowFailureDetails.failedJobs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.workflowLogs, (Object)workflowFailureDetails.workflowLogs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)workflowFailureDetails.error);
        }

        public WorkflowFailureDetails() {
            this(null, null, null, 7, null);
        }
    }
}

