/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.observer;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.flow.kanban.impl.GitHubIssue;
import cc.unitmesh.devti.flow.model.SimpleStory;
import cc.unitmesh.devti.observer.agent.AgentProcessor;
import cc.unitmesh.devti.settings.devops.AutoDevDevOpsConfigurableProviderKt;
import cc.unitmesh.devti.settings.devops.AutoDevDevOpsSettingService;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/observer/IssueWorker;", "Lcc/unitmesh/devti/observer/agent/AgentProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "processedIssues", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "process", "", "processRepository", "repository", "Lgit4idea/repo/GitRepository;", "processGitHubIssues", "repoUrl", "processNewIssue", "github", "Lcc/unitmesh/devti/flow/kanban/impl/GitHubIssue;", "issueId", "getLatestIssues", "", "notifyNewIssue", "story", "Lcc/unitmesh/devti/flow/model/SimpleStory;", "buildIssuePrompt", "getGitRepositories", "core"})
@SourceDebugExtension(value={"SMAP\nRemoteHookObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteHookObserver.kt\ncc/unitmesh/devti/observer/IssueWorker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n11#2:141\n11383#3,9:142\n13309#3:151\n13310#3:153\n11392#3:154\n1#4:152\n*S KotlinDebug\n*F\n+ 1 RemoteHookObserver.kt\ncc/unitmesh/devti/observer/IssueWorker\n*L\n43#1:141\n135#1:142,9\n135#1:151\n135#1:153\n135#1:154\n135#1:152\n*E\n"})
public final class IssueWorker
implements AgentProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;
    private final ConcurrentHashMap.KeySetView<String, Boolean> processedIssues;

    public IssueWorker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IssueWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.processedIssues = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void process() {
        try {
            List<GitRepository> repositories = this.getGitRepositories();
            if (repositories.isEmpty()) {
                this.log.debug("No Git repositories found in the project");
                return;
            }
            for (GitRepository repository : repositories) {
                this.processRepository(repository);
            }
        }
        catch (Exception e) {
            this.log.warn("Error processing GitHub/GitLab issues", (Throwable)e);
        }
    }

    private final void processRepository(GitRepository repository) {
        Collection collection = repository.getRemotes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemotes(...)");
        Object object = (GitRemote)CollectionsKt.firstOrNull((Iterable)collection);
        if (object == null || (object = object.getFirstUrl()) == null) {
            return;
        }
        Object remoteUrl = object;
        if (StringsKt.contains$default((CharSequence)((CharSequence)remoteUrl), (CharSequence)"github.com", (boolean)false, (int)2, null)) {
            this.processGitHubIssues((String)remoteUrl);
        } else if (StringsKt.contains$default((CharSequence)((CharSequence)remoteUrl), (CharSequence)"gitlab", (boolean)false, (int)2, null)) {
            this.log.debug("GitLab integration not yet implemented");
        }
    }

    private final void processGitHubIssues(String repoUrl) {
        String token = ((AutoDevDevOpsSettingService.AutoDevCoderSettings)AutoDevDevOpsConfigurableProviderKt.getDevopsPromptsSettings(this.project).getState()).getGithubToken();
        if (StringsKt.isBlank((CharSequence)token)) {
            this.log.debug("GitHub token not configured");
            return;
        }
        try {
            GitHubIssue github = new GitHubIssue(repoUrl, token);
            List<String> latestIssues = this.getLatestIssues(github);
            for (String latestIssueId : latestIssues) {
                if (this.processedIssues.contains(latestIssueId)) continue;
                this.processNewIssue(github, latestIssueId);
            }
        }
        catch (Exception e) {
            this.log.warn("Error processing GitHub issues for repo: " + repoUrl, (Throwable)e);
        }
    }

    private final void processNewIssue(GitHubIssue github, String issueId) {
        try {
            SimpleStory story = github.getStoryById(issueId);
            this.processedIssues.add(issueId);
            this.notifyNewIssue(story);
            this.log.info("Processed new GitHub issue: #" + issueId + " - " + story.getTitle());
        }
        catch (Exception e) {
            this.log.warn("Error processing issue " + issueId, (Throwable)e);
        }
    }

    private final List<String> getLatestIssues(GitHubIssue github) {
        List list;
        try {
            list = github.getRecentIssueIds();
        }
        catch (Exception e) {
            this.log.warn("Error fetching latest issues", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void notifyNewIssue(SimpleStory story) {
        String prompt2 = this.buildIssuePrompt(story);
        AutoDevNotifications.INSTANCE.error(this.project, prompt2);
    }

    private final String buildIssuePrompt(SimpleStory story) {
        return StringsKt.trimIndent((String)("\n            New issue received: #" + story.getId() + " - " + story.getTitle() + "\n            \n            " + story.getDescription() + "\n            \n            How would you like to proceed with this issue?\n        "));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GitRepository> getGitRepositories() {
        void $this$mapNotNullTo$iv$iv;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        VcsRoot[] vcsRootArray = vcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        VcsRoot[] roots = vcsRootArray;
        VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
        VcsRepositoryManager repositoryManager = vcsRepositoryManager;
        VcsRoot[] $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        VcsRoot[] vcsRootArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            GitRepository it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void root = element$iv$iv;
            boolean bl2 = false;
            Repository repo = repositoryManager.getRepositoryForRoot(root.getPath());
            if ((repo instanceof GitRepository ? (GitRepository)repo : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

