/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.ui.eval;

import cc.unitmesh.devti.mcp.ui.eval.RequestDetailPanel;
import cc.unitmesh.devti.mcp.ui.eval.ResponseDetailPanel;
import cc.unitmesh.devti.mcp.ui.model.McpMessage;
import cc.unitmesh.devti.mcp.ui.model.MessageType;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "messages", "", "Lcc/unitmesh/devti/mcp/ui/model/McpMessage;", "tableModel", "Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel$MessageTableModel;", "table", "Lcom/intellij/ui/table/JBTable;", "detailCardLayout", "Ljava/awt/CardLayout;", "detailPanel", "requestDetailPanel", "Lcc/unitmesh/devti/mcp/ui/eval/RequestDetailPanel;", "responseDetailPanel", "Lcc/unitmesh/devti/mcp/ui/eval/ResponseDetailPanel;", "splitPane", "Ljavax/swing/JSplitPane;", "addMessage", "", "message", "clear", "Companion", "MessageTableModel", "TypeColumnRenderer", "core"})
public final class McpMessageLogPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<McpMessage> messages = new ArrayList();
    @NotNull
    private final MessageTableModel tableModel = new MessageTableModel();
    @NotNull
    private final JBTable table;
    @NotNull
    private final CardLayout detailCardLayout;
    @NotNull
    private final JPanel detailPanel;
    @NotNull
    private final RequestDetailPanel requestDetailPanel;
    @NotNull
    private final ResponseDetailPanel responseDetailPanel;
    @NotNull
    private final JSplitPane splitPane;
    @NotNull
    private static final String REQUEST_PANEL = "REQUEST_PANEL";
    @NotNull
    private static final String RESPONSE_PANEL = "RESPONSE_PANEL";
    @NotNull
    private static final String EMPTY_PANEL = "EMPTY_PANEL";

    /*
     * WARNING - void declaration
     */
    public McpMessageLogPanel() {
        super(new BorderLayout());
        void $this$table_u24lambda_u241_u24lambda_u240;
        DefaultListSelectionModel defaultListSelectionModel;
        void $this$table_u24lambda_u241;
        Object object = new JBTable((TableModel)this.tableModel);
        JBTable jBTable = object;
        McpMessageLogPanel mcpMessageLogPanel = this;
        boolean bl = false;
        $this$table_u24lambda_u241.setShowGrid(false);
        $this$table_u24lambda_u241.setIntercellSpacing(new Dimension(0, 0));
        $this$table_u24lambda_u241.setRowHeight(30);
        DefaultListSelectionModel defaultListSelectionModel2 = defaultListSelectionModel = new DefaultListSelectionModel();
        void var6_7 = $this$table_u24lambda_u241;
        boolean bl2 = false;
        $this$table_u24lambda_u241_u24lambda_u240.setSelectionMode(0);
        var6_7.setSelectionModel((ListSelectionModel)defaultListSelectionModel);
        $this$table_u24lambda_u241.setAutoCreateRowSorter(true);
        mcpMessageLogPanel.table = object;
        this.detailCardLayout = new CardLayout();
        this.detailPanel = new JPanel(this.detailCardLayout);
        this.requestDetailPanel = new RequestDetailPanel();
        this.responseDetailPanel = new ResponseDetailPanel();
        this.splitPane = new JSplitPane(1);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TypeColumnRenderer());
        this.detailPanel.add((Component)new JPanel(), EMPTY_PANEL);
        this.detailPanel.add((Component)this.requestDetailPanel, REQUEST_PANEL);
        this.detailPanel.add((Component)this.responseDetailPanel, RESPONSE_PANEL);
        this.detailCardLayout.show(this.detailPanel, EMPTY_PANEL);
        Object $this$_init__u24lambda_u242 = object = this.splitPane;
        boolean bl3 = false;
        ((JSplitPane)$this$_init__u24lambda_u242).setLeftComponent((Component)new JBScrollPane((Component)this.table));
        ((JSplitPane)$this$_init__u24lambda_u242).setRightComponent((Component)new JBScrollPane((Component)this.detailPanel));
        ((JSplitPane)$this$_init__u24lambda_u242).setContinuousLayout(true);
        ((JSplitPane)$this$_init__u24lambda_u242).setResizeWeight(0.7);
        ((JSplitPane)$this$_init__u24lambda_u242).setOneTouchExpandable(true);
        ((JSplitPane)$this$_init__u24lambda_u242).setDividerLocation(0.7);
        this.add((Component)this.splitPane, "Center");
        this.table.getSelectionModel().addListSelectionListener(arg_0 -> McpMessageLogPanel._init_$lambda$3(this, arg_0));
    }

    public final void addMessage(@NotNull McpMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messages.add(message);
        this.tableModel.fireTableDataChanged();
        SwingUtilities.invokeLater(() -> McpMessageLogPanel.addMessage$lambda$4(this));
    }

    public final void clear() {
        this.messages.clear();
        this.tableModel.fireTableDataChanged();
        this.detailCardLayout.show(this.detailPanel, EMPTY_PANEL);
    }

    private static final void _init_$lambda$3(McpMessageLogPanel this$0, ListSelectionEvent e) {
        block4: {
            block5: {
                if (e.getValueIsAdjusting() || this$0.table.getSelectedRow() < 0) break block4;
                int selectedIndex = this$0.table.convertRowIndexToModel(this$0.table.getSelectedRow());
                if (selectedIndex < 0 || selectedIndex >= this$0.messages.size()) break block5;
                McpMessage message = this$0.messages.get(selectedIndex);
                switch (WhenMappings.$EnumSwitchMapping$0[message.getType().ordinal()]) {
                    case 1: {
                        this$0.requestDetailPanel.displayMessage(message);
                        this$0.detailCardLayout.show(this$0.detailPanel, REQUEST_PANEL);
                        break block4;
                    }
                    case 2: {
                        this$0.responseDetailPanel.displayMessage(message);
                        this$0.detailCardLayout.show(this$0.detailPanel, RESPONSE_PANEL);
                        break block4;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this$0.detailCardLayout.show(this$0.detailPanel, EMPTY_PANEL);
        }
    }

    private static final void addMessage$lambda$4(McpMessageLogPanel this$0) {
        this$0.table.setRowSelectionInterval(this$0.messages.size() - 1, this$0.messages.size() - 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel$Companion;", "", "<init>", "()V", "REQUEST_PANEL", "", "RESPONSE_PANEL", "EMPTY_PANEL", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel$MessageTableModel;", "Ljavax/swing/table/DefaultTableModel;", "<init>", "(Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel;)V", "columnNames", "", "", "[Ljava/lang/String;", "getColumnCount", "", "getRowCount", "getColumnName", "column", "getValueAt", "", "row", "isCellEditable", "", "core"})
    private final class MessageTableModel
    extends DefaultTableModel {
        @NotNull
        private final String[] columnNames;

        public MessageTableModel() {
            String[] stringArray = new String[]{"Type", "Method", "Timestamp", "Duration"};
            this.columnNames = stringArray;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return McpMessageLogPanel.this.messages.size();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        @NotNull
        public Object getValueAt(int row, int column) {
            Object object;
            McpMessage message = (McpMessage)McpMessageLogPanel.this.messages.get(row);
            switch (column) {
                case 0: {
                    object = message.getType();
                    break;
                }
                case 1: {
                    object = message.getMethod();
                    break;
                }
                case 2: {
                    object = message.getTimestamp().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                    break;
                }
                case 3: {
                    object = message.getDuration();
                    if (object != null && (object = ((Long)object).toString()) != null) break;
                    object = "-";
                    break;
                }
                default: {
                    object = "";
                }
            }
            return object;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel$TypeColumnRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "<init>", "()V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "core"})
    private static final class TypeColumnRenderer
    extends DefaultTableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object object;
            Component component2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JLabel");
            JLabel label = (JLabel)component2;
            label.setHorizontalAlignment(0);
            if (!isSelected) {
                object = value;
                if (object == MessageType.REQUEST) {
                    label.setBackground((Color)new JBColor(14808574, 870305));
                    label.setForeground((Color)new JBColor(87963, 14938877));
                } else if (object == MessageType.RESPONSE) {
                    label.setBackground((Color)new JBColor(15267305, 3046706));
                    label.setForeground((Color)new JBColor(1793568, 15267305));
                }
            }
            label.setText((object = value) == MessageType.REQUEST ? "REQUEST" : (object == MessageType.RESPONSE ? "RESPONSE" : ""));
            label.setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
            return label;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

