/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.ui;

import cc.unitmesh.devti.mcp.client.CustomMcpServerManager;
import cc.unitmesh.devti.mcp.client.MockDataGenerator;
import cc.unitmesh.devti.mcp.ui.McpToolDetailDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/devti/mcp/ui/McpToolListCardPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "serverName", "", "tool", "Lio/modelcontextprotocol/kotlin/sdk/Tool;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lio/modelcontextprotocol/kotlin/sdk/Tool;)V", "mcpServerManager", "Lcc/unitmesh/devti/mcp/client/CustomMcpServerManager;", "borderColor", "Lcom/intellij/ui/JBColor;", "textGray", "mutedBackground", "MAX_TOOL_CARD_HEIGHT", "", "TOOL_CARD_WIDTH", "buildCardUI", "", "showToolDetails", "testTool", "ToolTestResultDialog", "core"})
@SourceDebugExtension(value={"SMAP\nMcpToolListCardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpToolListCardPanel.kt\ncc/unitmesh/devti/mcp/ui/McpToolListCardPanel\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,176:1\n205#2:177\n*S KotlinDebug\n*F\n+ 1 McpToolListCardPanel.kt\ncc/unitmesh/devti/mcp/ui/McpToolListCardPanel\n*L\n124#1:177\n*E\n"})
public final class McpToolListCardPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final String serverName;
    @NotNull
    private final Tool tool;
    @NotNull
    private final CustomMcpServerManager mcpServerManager;
    @NotNull
    private final JBColor borderColor;
    @NotNull
    private final JBColor textGray;
    @NotNull
    private final JBColor mutedBackground;
    private final int MAX_TOOL_CARD_HEIGHT;
    private final int TOOL_CARD_WIDTH;

    public McpToolListCardPanel(@NotNull Project project, @NotNull String serverName, @NotNull Tool tool) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super(new BorderLayout(0, 0));
        this.project = project;
        this.serverName = serverName;
        this.tool = tool;
        this.mcpServerManager = CustomMcpServerManager.Companion.instance(this.project);
        this.borderColor = new JBColor(15067115, 3948353);
        this.textGray = new JBColor(7041664, 10330280);
        this.mutedBackground = new JBColor(15987958, 2829616);
        this.MAX_TOOL_CARD_HEIGHT = 160;
        this.TOOL_CARD_WIDTH = 200;
        this.buildCardUI();
    }

    private final void buildCardUI() {
        JPanel jPanel;
        JPanel jPanel2;
        this.setBackground(UIUtil.getPanelBackground());
        this.setBorder(new CompoundBorder(BorderFactory.createLineBorder((Color)this.borderColor), (Border)JBUI.Borders.empty((int)4, (int)8)));
        this.setPreferredSize(new Dimension(this.TOOL_CARD_WIDTH, this.MAX_TOOL_CARD_HEIGHT));
        JPanel $this$buildCardUI_u24lambda_u240 = jPanel2 = new JPanel(new BorderLayout(8, 0));
        boolean bl = false;
        $this$buildCardUI_u24lambda_u240.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u240.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)this.borderColor), JBUI.Borders.empty((int)2)));
        JPanel headerPanel2 = jPanel2;
        JPanel $this$buildCardUI_u24lambda_u241 = $this$buildCardUI_u24lambda_u240 = new JBLabel(this.tool.getName());
        boolean bl2 = false;
        $this$buildCardUI_u24lambda_u241.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        JPanel titleLabel = $this$buildCardUI_u24lambda_u240;
        headerPanel2.add((Component)titleLabel, "Center");
        JPanel $this$buildCardUI_u24lambda_u242 = $this$buildCardUI_u24lambda_u241 = new JPanel(new BorderLayout());
        boolean $i$a$-apply-McpToolListCardPanel$buildCardUI$contentPanel$22 = false;
        $this$buildCardUI_u24lambda_u242.setBackground(UIUtil.getPanelBackground());
        JPanel contentPanel = $this$buildCardUI_u24lambda_u241;
        String string = this.tool.getDescription();
        if (string == null) {
            string = "No description available";
        }
        String descriptionText = string;
        JTextPane $i$a$-apply-McpToolListCardPanel$buildCardUI$contentPanel$22 = new JTextPane();
        JComponent $this$buildCardUI_u24lambda_u243 = $i$a$-apply-McpToolListCardPanel$buildCardUI$contentPanel$22;
        boolean bl3 = false;
        ((JEditorPane)$this$buildCardUI_u24lambda_u243).setText(descriptionText);
        $this$buildCardUI_u24lambda_u243.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u243.setForeground((Color)this.textGray);
        ((JTextComponent)$this$buildCardUI_u24lambda_u243).setEditable(false);
        $this$buildCardUI_u24lambda_u243.setBackground(null);
        $this$buildCardUI_u24lambda_u243.setBorder(null);
        JTextPane descLabel = $i$a$-apply-McpToolListCardPanel$buildCardUI$contentPanel$22;
        contentPanel.add((Component)descLabel, "Center");
        JComponent $this$buildCardUI_u24lambda_u244 = $this$buildCardUI_u24lambda_u243 = new JPanel(new BorderLayout());
        boolean bl4 = false;
        $this$buildCardUI_u24lambda_u244.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u244.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        JComponent footerPanel = $this$buildCardUI_u24lambda_u243;
        JComponent $this$buildCardUI_u24lambda_u245 = $this$buildCardUI_u24lambda_u244 = new JBLabel(this.serverName);
        boolean bl5 = false;
        $this$buildCardUI_u24lambda_u245.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u245.setForeground((Color)this.textGray);
        $this$buildCardUI_u24lambda_u245.setBackground((Color)this.mutedBackground);
        $this$buildCardUI_u24lambda_u245.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        $this$buildCardUI_u24lambda_u245.setOpaque(true);
        JComponent serverLabel = $this$buildCardUI_u24lambda_u244;
        JComponent $this$buildCardUI_u24lambda_u246 = $this$buildCardUI_u24lambda_u245 = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl6 = false;
        $this$buildCardUI_u24lambda_u246.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u246.add(serverLabel);
        JComponent serverWrapperPanel = $this$buildCardUI_u24lambda_u245;
        JComponent $this$buildCardUI_u24lambda_u248 = $this$buildCardUI_u24lambda_u246 = new HyperlinkLabel("Details");
        boolean bl7 = false;
        $this$buildCardUI_u24lambda_u248.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u248.addHyperlinkListener(arg_0 -> McpToolListCardPanel.buildCardUI$lambda$8$lambda$7(this, arg_0));
        JComponent detailsLink = $this$buildCardUI_u24lambda_u246;
        JComponent $this$buildCardUI_u24lambda_u2410 = $this$buildCardUI_u24lambda_u248 = new HyperlinkLabel("Test");
        boolean bl8 = false;
        $this$buildCardUI_u24lambda_u2410.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u2410.addHyperlinkListener(arg_0 -> McpToolListCardPanel.buildCardUI$lambda$10$lambda$9(this, arg_0));
        JComponent testLink = $this$buildCardUI_u24lambda_u248;
        JPanel $this$buildCardUI_u24lambda_u2411 = jPanel = new JPanel(new FlowLayout(2, 4, 0));
        boolean bl9 = false;
        $this$buildCardUI_u24lambda_u2411.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u2411.add(testLink);
        $this$buildCardUI_u24lambda_u2411.add(detailsLink);
        JPanel linkWrapperPanel = jPanel;
        footerPanel.add((Component)serverWrapperPanel, "West");
        footerPanel.add((Component)linkWrapperPanel, "East");
        this.add((Component)headerPanel2, "North");
        this.add((Component)contentPanel, "Center");
        this.add((Component)footerPanel, "South");
    }

    private final void showToolDetails() {
        McpToolDetailDialog dialog2 = new McpToolDetailDialog(this.project, this.serverName, this.tool, this.mcpServerManager);
        dialog2.show();
    }

    private final void testTool() {
        Json json;
        JsonObject mockData = MockDataGenerator.INSTANCE.generateMockData(this.tool.getInputSchema());
        Json this_$iv = json = JsonKt.Json$default(null, McpToolListCardPanel::testTool$lambda$12, (int)1, null);
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonContent = this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)mockData);
        String result = this.mcpServerManager.execute(this.project, this.tool, jsonContent);
        ToolTestResultDialog dialog2 = new ToolTestResultDialog(this.project, this.tool, jsonContent, result);
        dialog2.show();
    }

    private static final void buildCardUI$lambda$8$lambda$7(McpToolListCardPanel this$0, HyperlinkEvent it) {
        this$0.showToolDetails();
    }

    private static final void buildCardUI$lambda$10$lambda$9(McpToolListCardPanel this$0, HyperlinkEvent it) {
        this$0.testTool();
    }

    private static final Unit testTool$lambda$12(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcc/unitmesh/devti/mcp/ui/McpToolListCardPanel$ToolTestResultDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "tool", "Lio/modelcontextprotocol/kotlin/sdk/Tool;", "inputJson", "", "result", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/modelcontextprotocol/kotlin/sdk/Tool;Ljava/lang/String;Ljava/lang/String;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "core"})
    private static final class ToolTestResultDialog
    extends DialogWrapper {
        @NotNull
        private final Tool tool;
        @NotNull
        private final String inputJson;
        @NotNull
        private final String result;

        public ToolTestResultDialog(@NotNull Project project, @NotNull Tool tool, @NotNull String inputJson, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            super(project);
            this.tool = tool;
            this.inputJson = inputJson;
            this.result = result;
            this.setTitle("Test Result: " + this.tool.getName());
            this.init();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JTextArea jTextArea;
            JTextArea jTextArea2;
            JPanel panel2 = new JPanel(new BorderLayout(0, 10));
            panel2.setPreferredSize(new Dimension(600, 400));
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)new JLabel("Input:"), "North");
            JTextArea $this$createCenterPanel_u24lambda_u240 = jTextArea2 = new JTextArea(this.inputJson);
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setLineWrap(true);
            $this$createCenterPanel_u24lambda_u240.setWrapStyleWord(true);
            $this$createCenterPanel_u24lambda_u240.setEditable(false);
            $this$createCenterPanel_u24lambda_u240.setFont((Font)JBUI.Fonts.create((String)"Monospaced", (int)12));
            JTextArea inputTextArea = jTextArea2;
            topPanel.add((Component)new JBScrollPane((Component)inputTextArea), "Center");
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add((Component)new JLabel("Result:"), "North");
            JTextArea $this$createCenterPanel_u24lambda_u241 = jTextArea = new JTextArea(this.result);
            boolean bl2 = false;
            $this$createCenterPanel_u24lambda_u241.setLineWrap(true);
            $this$createCenterPanel_u24lambda_u241.setWrapStyleWord(true);
            $this$createCenterPanel_u24lambda_u241.setEditable(false);
            $this$createCenterPanel_u24lambda_u241.setFont((Font)JBUI.Fonts.create((String)"Monospaced", (int)12));
            JTextArea resultTextArea = jTextArea;
            bottomPanel.add((Component)new JBScrollPane((Component)resultTextArea), "Center");
            panel2.add((Component)topPanel, "North");
            panel2.add((Component)bottomPanel, "Center");
            return panel2;
        }
    }
}

