/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.ui;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.mcp.client.CustomMcpServerManager;
import cc.unitmesh.devti.mcp.ui.eval.McpMessageLogPanel;
import cc.unitmesh.devti.mcp.ui.model.McpChatConfig;
import cc.unitmesh.devti.mcp.ui.model.McpMessage;
import cc.unitmesh.devti.mcp.ui.model.MessageType;
import cc.unitmesh.devti.mcp.ui.model.ParsedToolCall;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\b\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u001cH\u0002J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0001H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcc/unitmesh/devti/mcp/ui/McpChatResultPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;)V", "getConfig", "()Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;", "mcpServerManager", "Lcc/unitmesh/devti/mcp/client/CustomMcpServerManager;", "json", "Lkotlinx/serialization/json/Json;", "rawResultTextArea", "Ljavax/swing/JTextArea;", "toolsPanel", "messageLogPanel", "Lcc/unitmesh/devti/mcp/ui/eval/McpMessageLogPanel;", "responseScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "toolsScrollPane", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "borderColor", "Lcom/intellij/ui/JBColor;", "toolCalls", "", "Lcc/unitmesh/devti/mcp/ui/model/ParsedToolCall;", "reset", "", "setText", "text", "", "parseAndShowTools", "executeAllTools", "createToolCallPanel", "toolCall", "executeToolCall", "parentPanel", "findMatchingTool", "Lio/modelcontextprotocol/kotlin/sdk/Tool;", "toolName", "core"})
@SourceDebugExtension(value={"SMAP\nMcpChatResultPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpChatResultPanel.kt\ncc/unitmesh/devti/mcp/ui/McpChatResultPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,401:1\n1855#2,2:402\n215#3,2:404\n205#4:406\n205#4:407\n*S KotlinDebug\n*F\n+ 1 McpChatResultPanel.kt\ncc/unitmesh/devti/mcp/ui/McpChatResultPanel\n*L\n136#1:402,2\n239#1:404,2\n183#1:406\n325#1:407\n*E\n"})
public final class McpChatResultPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final McpChatConfig config;
    @NotNull
    private final CustomMcpServerManager mcpServerManager;
    @NotNull
    private final Json json;
    @NotNull
    private final JTextArea rawResultTextArea;
    @NotNull
    private final JPanel toolsPanel;
    @NotNull
    private final McpMessageLogPanel messageLogPanel;
    @NotNull
    private final JBScrollPane responseScrollPane;
    @NotNull
    private final JBScrollPane toolsScrollPane;
    @NotNull
    private final JBTabbedPane tabbedPane;
    @NotNull
    private final JBColor borderColor;
    @NotNull
    private List<ParsedToolCall> toolCalls;

    /*
     * WARNING - void declaration
     */
    public McpChatResultPanel(@NotNull Project project, @NotNull McpChatConfig config) {
        void $this$tabbedPane_u24lambda_u245;
        JComponent $this$toolsScrollPane_u24lambda_u244;
        JComponent $this$responseScrollPane_u24lambda_u243;
        JComponent $this$toolsPanel_u24lambda_u242;
        JComponent $this$rawResultTextArea_u24lambda_u241;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(new BorderLayout());
        this.project = project;
        this.config = config;
        this.mcpServerManager = CustomMcpServerManager.Companion.instance(this.project);
        this.json = JsonKt.Json$default(null, McpChatResultPanel::json$lambda$0, (int)1, null);
        JTextArea jTextArea = jComponent = new JTextArea();
        McpChatResultPanel mcpChatResultPanel = this;
        boolean bl = false;
        $this$rawResultTextArea_u24lambda_u241.setEditable(false);
        $this$rawResultTextArea_u24lambda_u241.setWrapStyleWord(true);
        $this$rawResultTextArea_u24lambda_u241.setLineWrap(true);
        $this$rawResultTextArea_u24lambda_u241.setBackground(UIUtil.getPanelBackground());
        $this$rawResultTextArea_u24lambda_u241.setBorder(JBUI.Borders.empty((int)4));
        mcpChatResultPanel.rawResultTextArea = jComponent;
        $this$rawResultTextArea_u24lambda_u241 = jComponent = new JPanel(new GridBagLayout());
        mcpChatResultPanel = this;
        boolean bl2 = false;
        $this$toolsPanel_u24lambda_u242.setBackground(UIUtil.getPanelBackground());
        $this$toolsPanel_u24lambda_u242.setBorder(JBUI.Borders.empty((int)8));
        mcpChatResultPanel.toolsPanel = jComponent;
        this.messageLogPanel = new McpMessageLogPanel();
        $this$toolsPanel_u24lambda_u242 = jComponent = new JBScrollPane((Component)this.rawResultTextArea);
        mcpChatResultPanel = this;
        boolean bl3 = false;
        $this$responseScrollPane_u24lambda_u243.setBorder(BorderFactory.createEmptyBorder());
        $this$responseScrollPane_u24lambda_u243.setVerticalScrollBarPolicy(20);
        mcpChatResultPanel.responseScrollPane = jComponent;
        $this$responseScrollPane_u24lambda_u243 = jComponent = new JBScrollPane((Component)this.toolsPanel);
        mcpChatResultPanel = this;
        boolean bl4 = false;
        $this$toolsScrollPane_u24lambda_u244.setBorder(BorderFactory.createEmptyBorder());
        $this$toolsScrollPane_u24lambda_u244.setVerticalScrollBarPolicy(20);
        mcpChatResultPanel.toolsScrollPane = jComponent;
        $this$toolsScrollPane_u24lambda_u244 = jComponent = new JBTabbedPane();
        mcpChatResultPanel = this;
        boolean bl5 = false;
        $this$tabbedPane_u24lambda_u245.addTab(AutoDevBundle.message("mcp.chat.result.tab.response", new Object[0]), (Component)this.responseScrollPane);
        $this$tabbedPane_u24lambda_u245.addTab(AutoDevBundle.message("mcp.chat.result.tab.tools", new Object[0]), (Component)this.toolsScrollPane);
        $this$tabbedPane_u24lambda_u245.addTab(AutoDevBundle.message("mcp.chat.result.tab.messages", new Object[0]), (Component)this.messageLogPanel);
        mcpChatResultPanel.tabbedPane = jComponent;
        this.borderColor = new JBColor(15067115, 3948353);
        this.toolCalls = CollectionsKt.emptyList();
        this.setBackground(UIUtil.getPanelBackground());
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)contentPanel, "Center");
    }

    @NotNull
    public final McpChatConfig getConfig() {
        return this.config;
    }

    public final void reset() {
        this.rawResultTextArea.setText("");
        this.toolsPanel.removeAll();
        this.toolsPanel.revalidate();
        this.toolsPanel.repaint();
        this.messageLogPanel.clear();
        this.toolCalls = CollectionsKt.emptyList();
        this.tabbedPane.setSelectedIndex(0);
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.rawResultTextArea.setText(text);
    }

    public final void parseAndShowTools(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.toolsPanel.removeAll();
        this.toolCalls = ParsedToolCall.Companion.fromString(text);
        if (this.toolCalls.isEmpty()) {
            JBLabel jBLabel;
            Object $this$parseAndShowTools_u24lambda_u246 = jBLabel = new JBLabel(AutoDevBundle.message("mcp.chat.result.no.tools", new Object[0]));
            boolean bl = false;
            $this$parseAndShowTools_u24lambda_u246.setForeground((Color)new JBColor(7041664, 10330280));
            $this$parseAndShowTools_u24lambda_u246.setHorizontalAlignment(0);
            JBLabel noToolsLabel = jBLabel;
            Object $this$parseAndShowTools_u24lambda_u247 = $this$parseAndShowTools_u24lambda_u246 = new GridBagConstraints();
            boolean bl2 = false;
            $this$parseAndShowTools_u24lambda_u247.gridx = 0;
            $this$parseAndShowTools_u24lambda_u247.gridy = 0;
            $this$parseAndShowTools_u24lambda_u247.weightx = 1.0;
            $this$parseAndShowTools_u24lambda_u247.weighty = 1.0;
            $this$parseAndShowTools_u24lambda_u247.fill = 1;
            Object gbc = $this$parseAndShowTools_u24lambda_u246;
            this.toolsPanel.add((Component)noToolsLabel, gbc);
        } else {
            int gridY = 0;
            JButton $this$parseAndShowTools_u24lambda_u246 = new JButton(AutoDevBundle.message("mcp.chat.result.execute.all", new Object[0]));
            JComponent $this$parseAndShowTools_u24lambda_u249 = $this$parseAndShowTools_u24lambda_u246;
            boolean bl = false;
            $this$parseAndShowTools_u24lambda_u249.setFont((Font)JBUI.Fonts.label((float)12.0f).asBold());
            ((AbstractButton)$this$parseAndShowTools_u24lambda_u249).addActionListener(arg_0 -> McpChatResultPanel.parseAndShowTools$lambda$9$lambda$8(this, arg_0));
            JButton executeAllButton = $this$parseAndShowTools_u24lambda_u246;
            $this$parseAndShowTools_u24lambda_u249 = new JPanel(new FlowLayout(0));
            Serializable $this$parseAndShowTools_u24lambda_u2410 = $this$parseAndShowTools_u24lambda_u249;
            boolean bl3 = false;
            $this$parseAndShowTools_u24lambda_u2410.setOpaque(false);
            $this$parseAndShowTools_u24lambda_u2410.add(executeAllButton);
            JComponent buttonPanel = $this$parseAndShowTools_u24lambda_u249;
            Serializable $this$parseAndShowTools_u24lambda_u2411 = $this$parseAndShowTools_u24lambda_u2410 = new GridBagConstraints();
            boolean bl4 = false;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2411).gridx = 0;
            int n = gridY;
            gridY = n + 1;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2411).gridy = n;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2411).weightx = 1.0;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2411).fill = 2;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2411).insets = (Insets)JBUI.insetsBottom((int)10);
            Serializable buttonGbc = $this$parseAndShowTools_u24lambda_u2410;
            this.toolsPanel.add((Component)buttonPanel, buttonGbc);
            Iterable $this$forEach$iv = this.toolCalls;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                GridBagConstraints gridBagConstraints;
                Object element$iv = object.next();
                ParsedToolCall toolCall = (ParsedToolCall)element$iv;
                boolean bl5 = false;
                JPanel toolPanel = this.createToolCallPanel(toolCall);
                GridBagConstraints $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412 = gridBagConstraints = new GridBagConstraints();
                boolean bl6 = false;
                $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412.gridx = 0;
                int n2 = gridY;
                gridY = n2 + 1;
                $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412.gridy = n2;
                $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412.weightx = 1.0;
                $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412.fill = 2;
                $this$parseAndShowTools_u24lambda_u2413_u24lambda_u2412.insets = (Insets)JBUI.insetsBottom((int)10);
                GridBagConstraints gbc = gridBagConstraints;
                this.toolsPanel.add((Component)toolPanel, gbc);
            }
            JPanel fillerPanel = new JPanel();
            fillerPanel.setOpaque(false);
            Object $this$parseAndShowTools_u24lambda_u2414 = object = new GridBagConstraints();
            boolean bl7 = false;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2414).gridx = 0;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2414).gridy = gridY;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2414).weightx = 1.0;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2414).weighty = 1.0;
            ((GridBagConstraints)$this$parseAndShowTools_u24lambda_u2414).fill = 1;
            Object gbc = object;
            this.toolsPanel.add((Component)fillerPanel, gbc);
        }
        this.toolsPanel.revalidate();
        this.toolsPanel.repaint();
        if (!((Collection)this.toolCalls).isEmpty()) {
            this.tabbedPane.setSelectedIndex(1);
        }
    }

    private final void executeAllTools() {
        if (this.toolCalls.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(() -> McpChatResultPanel.executeAllTools$lambda$15(this));
    }

    private final JPanel createToolCallPanel(ParsedToolCall toolCall) {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel $this$createToolCallPanel_u24lambda_u2416 = jPanel2 = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createToolCallPanel_u24lambda_u2416.setBackground(UIUtil.getPanelBackground().brighter());
        $this$createToolCallPanel_u24lambda_u2416.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, (Color)this.borderColor), new EmptyBorder((Insets)JBUI.insets((int)10))));
        JPanel panel2 = jPanel2;
        JPanel $this$createToolCallPanel_u24lambda_u2417 = $this$createToolCallPanel_u24lambda_u2416 = new JBLabel(toolCall.getName());
        boolean bl2 = false;
        $this$createToolCallPanel_u24lambda_u2417.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        $this$createToolCallPanel_u24lambda_u2417.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        JPanel titleLabel = $this$createToolCallPanel_u24lambda_u2416;
        JPanel $this$createToolCallPanel_u24lambda_u2418 = $this$createToolCallPanel_u24lambda_u2417 = new JPanel(new GridBagLayout());
        boolean bl3 = false;
        $this$createToolCallPanel_u24lambda_u2418.setOpaque(false);
        JPanel paramsPanel = $this$createToolCallPanel_u24lambda_u2417;
        int paramGridY = 0;
        Map<String, String> $this$forEach$iv = toolCall.getParameters();
        boolean $i$f$forEach22 = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            GridBagConstraints gridBagConstraints;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl4 = false;
            String name = entry.getKey();
            String value = entry.getValue();
            JBLabel jBLabel = new JBLabel(name + ":");
            Object $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2419 = jBLabel;
            boolean bl5 = false;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2419.setFont((Font)JBUI.Fonts.label((float)12.0f).asBold());
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2419.setBorder((Border)JBUI.Borders.emptyRight((int)8));
            JBLabel nameLabel = jBLabel;
            Object $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420 = $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2419 = new JTextArea(value);
            boolean bl6 = false;
            ((JTextComponent)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setEditable(false);
            ((JTextArea)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setWrapStyleWord(true);
            ((JTextArea)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setLineWrap(true);
            ((JComponent)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setBackground(UIUtil.getPanelBackground().brighter());
            ((JComponent)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setBorder(null);
            ((JTextComponent)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420).setMargin((Insets)JBUI.emptyInsets());
            Object valueLabel = $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2419;
            Object $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2421 = $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420 = new GridBagConstraints();
            boolean bl7 = false;
            ((GridBagConstraints)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2421).gridx = 0;
            ((GridBagConstraints)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2421).gridy = paramGridY;
            ((GridBagConstraints)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2421).anchor = 18;
            ((GridBagConstraints)$this$createToolCallPanel_u24lambda_u2423_u24lambda_u2421).insets = (Insets)JBUI.insets((int)2);
            Object nameGbc = $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2420;
            GridBagConstraints $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422 = gridBagConstraints = new GridBagConstraints();
            boolean bl8 = false;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422.gridx = 1;
            int n = paramGridY;
            paramGridY = n + 1;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422.gridy = n;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422.weightx = 1.0;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422.fill = 2;
            $this$createToolCallPanel_u24lambda_u2423_u24lambda_u2422.insets = (Insets)JBUI.insets((int)2);
            GridBagConstraints valueGbc = gridBagConstraints;
            paramsPanel.add((Component)nameLabel, nameGbc);
            paramsPanel.add((Component)valueLabel, valueGbc);
        }
        JButton $i$f$forEach22 = new JButton(AutoDevBundle.message("mcp.chat.result.execute", new Object[0]));
        JComponent $this$createToolCallPanel_u24lambda_u2425 = $i$f$forEach22;
        boolean bl9 = false;
        $this$createToolCallPanel_u24lambda_u2425.setFont((Font)JBUI.Fonts.label((float)12.0f));
        ((AbstractButton)$this$createToolCallPanel_u24lambda_u2425).addActionListener(arg_0 -> McpChatResultPanel.createToolCallPanel$lambda$25$lambda$24(this, toolCall, panel2, arg_0));
        JButton executeButton = $i$f$forEach22;
        JComponent $this$createToolCallPanel_u24lambda_u2426 = $this$createToolCallPanel_u24lambda_u2425 = new JPanel(new FlowLayout(0));
        boolean bl10 = false;
        $this$createToolCallPanel_u24lambda_u2426.setOpaque(false);
        $this$createToolCallPanel_u24lambda_u2426.add(executeButton);
        JComponent buttonsPanel = $this$createToolCallPanel_u24lambda_u2425;
        JComponent $this$createToolCallPanel_u24lambda_u2427 = $this$createToolCallPanel_u24lambda_u2426 = new JPanel(new BorderLayout());
        boolean bl11 = false;
        $this$createToolCallPanel_u24lambda_u2427.setOpaque(false);
        $this$createToolCallPanel_u24lambda_u2427.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        $this$createToolCallPanel_u24lambda_u2427.setVisible(false);
        JComponent resultPanel = $this$createToolCallPanel_u24lambda_u2426;
        JPanel $this$createToolCallPanel_u24lambda_u2428 = jPanel = new JPanel(new BorderLayout());
        boolean bl12 = false;
        $this$createToolCallPanel_u24lambda_u2428.setOpaque(false);
        $this$createToolCallPanel_u24lambda_u2428.add((Component)paramsPanel, "Center");
        $this$createToolCallPanel_u24lambda_u2428.add((Component)buttonsPanel, "South");
        JPanel contentPanel = jPanel;
        panel2.add((Component)titleLabel, "North");
        panel2.add((Component)contentPanel, "Center");
        panel2.add((Component)resultPanel, "South");
        return panel2;
    }

    private final void executeToolCall(ParsedToolCall toolCall, JPanel parentPanel) {
        Object[] objectArray;
        Object[] $this$executeToolCall_u24lambda_u2429 = objectArray = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$executeToolCall_u24lambda_u2429.setOpaque(false);
        $this$executeToolCall_u24lambda_u2429.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        $this$executeToolCall_u24lambda_u2429.setVisible(false);
        Object[] resultPanel = objectArray;
        parentPanel.add((Component)resultPanel, "South");
        $this$executeToolCall_u24lambda_u2429 = new Object[]{toolCall.getName()};
        Object[] $this$executeToolCall_u24lambda_u2430 = $this$executeToolCall_u24lambda_u2429 = new JBLabel(AutoDevBundle.message("mcp.chat.result.executing", $this$executeToolCall_u24lambda_u2429));
        boolean bl2 = false;
        $this$executeToolCall_u24lambda_u2430.setHorizontalAlignment(0);
        Object[] loadingLabel = $this$executeToolCall_u24lambda_u2429;
        resultPanel.add((Component)loadingLabel, "Center");
        resultPanel.setVisible(true);
        resultPanel.revalidate();
        resultPanel.repaint();
        long startTime = System.currentTimeMillis();
        SwingUtilities.invokeLater(() -> McpChatResultPanel.executeToolCall$lambda$35(this, toolCall, startTime, (JPanel)resultPanel));
    }

    private final Tool findMatchingTool(String toolName) {
        for (Tool tool : this.config.getEnabledTools()) {
            if (!Intrinsics.areEqual((Object)tool.getName(), (Object)toolName)) continue;
            return tool;
        }
        return null;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final void parseAndShowTools$lambda$9$lambda$8(McpChatResultPanel this$0, ActionEvent it) {
        this$0.executeAllTools();
    }

    private static final void executeAllTools$lambda$15(McpChatResultPanel this$0) {
        for (ParsedToolCall toolCall : this$0.toolCalls) {
            String this_$iv;
            Tool matchingTool = this$0.findMatchingTool(toolCall.getName());
            if (matchingTool == null) continue;
            long startTime = System.currentTimeMillis();
            try {
                Json json = this$0.json;
                Map<String, String> value$iv = toolCall.getParameters();
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                this_$iv = this_$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), value$iv);
            }
            catch (Exception e) {
                this_$iv = "{}";
            }
            String params = this_$iv;
            String requestContent = "Tool: " + toolCall.getName() + "\nParameters: " + params;
            String string = toolCall.getName();
            LocalDateTime localDateTime = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
            McpMessage requestMessage = new McpMessage(MessageType.REQUEST, string, localDateTime, null, requestContent, toolCall.getName(), params, 8, null);
            this$0.messageLogPanel.addMessage(requestMessage);
            String result = this$0.mcpServerManager.execute(this$0.project, matchingTool, params);
            long duration = System.currentTimeMillis() - startTime;
            String string2 = toolCall.getName();
            LocalDateTime localDateTime2 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(...)");
            McpMessage responseMessage = new McpMessage(MessageType.RESPONSE, string2, localDateTime2, duration, result, null, null, 96, null);
            this$0.messageLogPanel.addMessage(responseMessage);
        }
        this$0.tabbedPane.setSelectedIndex(2);
    }

    private static final void createToolCallPanel$lambda$25$lambda$24(McpChatResultPanel this$0, ParsedToolCall $toolCall, JPanel $panel, ActionEvent it) {
        this$0.executeToolCall($toolCall, $panel);
    }

    /*
     * WARNING - void declaration
     */
    private static final void executeToolCall$lambda$35(McpChatResultPanel this$0, ParsedToolCall $toolCall, long $startTime, JPanel $resultPanel) {
        JBScrollPane jBScrollPane;
        void $this$executeToolCall_u24lambda_u2435_u24lambda_u2432_u24lambda_u2431;
        JBLabel jBLabel;
        String string;
        String jsonParams;
        try {
            void this_$iv;
            Json json = this$0.json;
            Map<String, String> value$iv = $toolCall.getParameters();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            jsonParams = this_$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), value$iv);
        }
        catch (Exception e) {
            jsonParams = "{}";
        }
        String params = jsonParams;
        String requestContent = "Tool: " + $toolCall.getName() + "\nParameters: " + params;
        String string2 = $toolCall.getName();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        McpMessage requestMessage = new McpMessage(MessageType.REQUEST, string2, localDateTime, null, requestContent, $toolCall.getName(), params, 8, null);
        this$0.messageLogPanel.addMessage(requestMessage);
        Tool matchingTool = this$0.findMatchingTool($toolCall.getName());
        if (matchingTool != null) {
            string = this$0.mcpServerManager.execute(this$0.project, matchingTool, params);
        } else {
            Object[] objectArray = new Object[]{$toolCall.getName()};
            string = AutoDevBundle.message("mcp.chat.result.error.tool.not.found", objectArray);
        }
        String result = string;
        long executionTime = System.currentTimeMillis() - $startTime;
        String string3 = $toolCall.getName();
        LocalDateTime localDateTime2 = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(...)");
        McpMessage responseMessage = new McpMessage(MessageType.RESPONSE, string3, localDateTime2, executionTime, result, null, null, 96, null);
        this$0.messageLogPanel.addMessage(responseMessage);
        $resultPanel.removeAll();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JComponent $this$executeToolCall_u24lambda_u2435_u24lambda_u2432 = jPanel;
        boolean bl = false;
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2432.setOpaque(false);
        JBLabel jBLabel2 = jBLabel = new JBLabel(AutoDevBundle.message("mcp.chat.result.execution.time", new Object[0]) + ": " + executionTime + "ms");
        JPanel jPanel2 = $this$executeToolCall_u24lambda_u2435_u24lambda_u2432;
        boolean bl2 = false;
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2432_u24lambda_u2431.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2432_u24lambda_u2431.setForeground((Color)new JBColor(7041664, 10330280));
        jPanel2.add((Component)jBLabel);
        JPanel timeInfoPanel = jPanel;
        JComponent $this$executeToolCall_u24lambda_u2435_u24lambda_u2433 = $this$executeToolCall_u24lambda_u2435_u24lambda_u2432 = new JTextArea(result);
        boolean bl3 = false;
        ((JTextArea)$this$executeToolCall_u24lambda_u2435_u24lambda_u2433).setLineWrap(true);
        ((JTextArea)$this$executeToolCall_u24lambda_u2435_u24lambda_u2433).setWrapStyleWord(true);
        ((JTextComponent)$this$executeToolCall_u24lambda_u2435_u24lambda_u2433).setEditable(false);
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2433.setBorder(JBUI.Borders.empty((int)4));
        JComponent textArea = $this$executeToolCall_u24lambda_u2435_u24lambda_u2432;
        JBScrollPane $this$executeToolCall_u24lambda_u2435_u24lambda_u2434 = jBScrollPane = new JBScrollPane((Component)textArea);
        boolean bl4 = false;
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2434.setBorder(BorderFactory.createEmptyBorder());
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2434.setVerticalScrollBarPolicy(20);
        $this$executeToolCall_u24lambda_u2435_u24lambda_u2434.setPreferredSize(new Dimension(0, 150));
        JBScrollPane resultScrollPane = jBScrollPane;
        $resultPanel.add((Component)timeInfoPanel, "North");
        $resultPanel.add((Component)resultScrollPane, "Center");
        $resultPanel.setVisible(true);
        $resultPanel.revalidate();
        $resultPanel.repaint();
    }
}

