/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.ui;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevSnippetFile;
import cc.unitmesh.devti.mcp.ui.model.McpChatConfig;
import cc.unitmesh.devti.sketch.ui.code.CodeHighlightSketchKt;
import cc.unitmesh.devti.sketch.ui.code.EditorUtil;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.java.accessibility.util.AWTEventMonitor;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/mcp/ui/McpChatConfigDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;", "allTools", "", "", "", "Lio/modelcontextprotocol/kotlin/sdk/Tool;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;Ljava/util/Map;)V", "temperatureSlider", "Ljavax/swing/JSlider;", "toolCheckboxes", "", "Lcom/intellij/ui/components/JBCheckBox;", "markdownEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "createCenterPanel", "Ljavax/swing/JComponent;", "getConfig", "core"})
@SourceDebugExtension(value={"SMAP\nMcpChatConfigDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpChatConfigDialog.kt\ncc/unitmesh/devti/mcp/ui/McpChatConfigDialog\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n215#2,2:113\n215#2:118\n216#2:121\n1747#3,3:115\n1855#3,2:119\n*S KotlinDebug\n*F\n+ 1 McpChatConfigDialog.kt\ncc/unitmesh/devti/mcp/ui/McpChatConfigDialog\n*L\n37#1:113,2\n76#1:118\n76#1:121\n82#1:115,3\n77#1:119,2\n*E\n"})
public final class McpChatConfigDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final McpChatConfig config;
    @NotNull
    private final Map<String, List<Tool>> allTools;
    private JSlider temperatureSlider;
    @NotNull
    private final Map<String, JBCheckBox> toolCheckboxes;
    @Nullable
    private EditorEx markdownEditor;

    /*
     * WARNING - void declaration
     */
    public McpChatConfigDialog(@NotNull Project project, @NotNull McpChatConfig config, @NotNull Map<String, ? extends List<Tool>> allTools) {
        EditorEx editorEx;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(allTools, (String)"allTools");
        super(project);
        this.project = project;
        this.config = config;
        this.allTools = allTools;
        this.toolCheckboxes = new LinkedHashMap();
        this.setTitle(AutoDevBundle.message("mcp.chat.config.dialog.title", new Object[0]));
        Map<String, List<Tool>> $this$forEach$iv = this.allTools;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Tool>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Editor element$iv;
            editor = element$iv = iterator.next();
            boolean bl = false;
            String serverName = editor.getKey();
            List<Tool> tools = editor.getValue();
            this.config.getEnabledTools().addAll((Collection<Tool>)tools);
        }
        Language language = CodeFence.Companion.findLanguage("Markdown");
        String systemPrompt = this.config.createSystemPrompt();
        LightVirtualFile file = new LightVirtualFile(AutoDevSnippetFile.INSTANCE.naming("md"), language, (CharSequence)systemPrompt);
        McpChatConfigDialog mcpChatConfigDialog = this;
        try {
            McpChatConfigDialog mcpChatConfigDialog2 = mcpChatConfigDialog;
            Document document = CodeHighlightSketchKt.findDocument((VirtualFile)file);
            if (document == null) {
                throw new IllegalStateException("Document not found");
            }
            Document document2 = document;
            editor = EditorFactory.getInstance().createEditor(document2, this.project, EditorKind.MAIN_EDITOR);
            editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        }
        catch (Throwable throwable) {
            void e;
            McpChatConfigDialog mcpChatConfigDialog3 = mcpChatConfigDialog;
            throw e;
        }
        mcpChatConfigDialog2.markdownEditor = editorEx;
        if (this.markdownEditor != null) {
            EditorEx editorEx2 = this.markdownEditor;
            Intrinsics.checkNotNull((Object)editorEx2);
            EditorUtil.INSTANCE.configEditor(editorEx2, this.project, (VirtualFile)file, false);
        }
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Language language = CodeFence.Companion.findLanguage("markdown");
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14(this, arg_0)).withPreferredSize(500, 600);
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withPreferredSize(...)");
        return (JComponent)jBPanel;
    }

    @NotNull
    public final McpChatConfig getConfig() {
        this.config.setSystemPrompt(this.config.createSystemPrompt());
        return this.config;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$1(McpChatConfigDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[1];
        String string = "%.1f";
        Object[] objectArray2 = new Object[]{this$0.config.getTemperature()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        $this$row.label(AutoDevBundle.message("mcp.chat.config.dialog.temperature", objectArray));
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$14$lambda$4$lambda$3$lambda$2(McpChatConfigDialog this$0, ChangeEvent it) {
        JSlider jSlider = this$0.temperatureSlider;
        if (jSlider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"temperatureSlider");
            jSlider = null;
        }
        double value = (double)jSlider.getValue() / 10.0;
        this$0.config.setTemperature(value);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$14$lambda$4(McpChatConfigDialog this$0, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2414_u24lambda_u244_u24lambda_u243;
        JSlider jSlider;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JSlider jSlider2 = jSlider = new JSlider(0, 10, (int)(this$0.config.getTemperature() * (double)10));
        Row row = $this$row;
        boolean bl = false;
        this$0.temperatureSlider = $this$createCenterPanel_u24lambda_u2414_u24lambda_u244_u24lambda_u243;
        $this$createCenterPanel_u24lambda_u2414_u24lambda_u244_u24lambda_u243.setBackground(UIUtil.getPanelBackground());
        $this$createCenterPanel_u24lambda_u2414_u24lambda_u244_u24lambda_u243.addChangeListener(arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        row.cell((JComponent)jSlider);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6(Cell $this_apply, McpChatConfigDialog this$0, Tool $tool, ActionEvent it) {
        boolean bl = ((JBCheckBox)$this_apply.getComponent()).isSelected() ? this$0.config.getEnabledTools().add($tool) : this$0.config.getEnabledTools().remove($tool);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9$lambda$8(Tool $tool, String $serverName, McpChatConfigDialog this$0, Row $this$row) {
        boolean bl;
        JBCheckBox jBCheckBox;
        Cell $this$createCenterPanel_u24lambda_u2414_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247;
        block3: {
            void $this$any$iv;
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label($tool.getName() + " (" + $serverName + ")");
            $this$createCenterPanel_u24lambda_u2414_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247 = cell = $this$row.checkBox("");
            boolean bl2 = false;
            this$0.toolCheckboxes.put($tool.getName(), (JBCheckBox)$this$createCenterPanel_u24lambda_u2414_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.getComponent());
            Iterable iterable = this$0.config.getEnabledTools();
            jBCheckBox = (JBCheckBox)$this$createCenterPanel_u24lambda_u2414_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.getComponent();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Tool it = (Tool)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$tool.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        jBCheckBox.setSelected(bl4);
        AWTEventMonitor.addActionListener(arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6($this$createCenterPanel_u24lambda_u2414_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247, this$0, $tool, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$11(McpChatConfigDialog this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Map<String, List<Tool>> $this$forEach$iv = this$0.allTools;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Tool>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Tool>> element$iv;
            Map.Entry<String, List<Tool>> entry = element$iv = iterator.next();
            boolean bl = false;
            String serverName = entry.getKey();
            List<Tool> tools = entry.getValue();
            Iterable $this$forEach$iv2 = tools;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Tool tool = (Tool)element$iv2;
                boolean bl2 = false;
                Panel.row$default((Panel)$this$group, null, arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9$lambda$8(tool, serverName, this$0, arg_0), (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$13$lambda$12(JComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setPreferredSize((Dimension)JBUI.size((int)500, (int)320));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$13(McpChatConfigDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorEx editorEx = this$0.markdownEditor;
        Intrinsics.checkNotNull((Object)editorEx);
        JComponent jComponent = editorEx.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).resizableColumn().applyToComponent(McpChatConfigDialog::createCenterPanel$lambda$14$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14(McpChatConfigDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$4(this$0, arg_0), (int)1, null);
        Panel.group$default((Panel)$this$panel, (String)AutoDevBundle.message("mcp.chat.config.dialog.enabled.tools", new Object[0]), (boolean)false, arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$11(this$0, arg_0), (int)2, null).topGap(TopGap.MEDIUM);
        if (this$0.markdownEditor != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> McpChatConfigDialog.createCenterPanel$lambda$14$lambda$13(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }
}

