/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.devti.mcp.host.WaitArgs;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/WaitTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/WaitArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class WaitTool
extends AbstractMcpTool<WaitArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public WaitTool() {
        this.name = "wait";
        this.description = "Waits for a specified number of milliseconds (default: 5000ms = 5 seconds).\nOptionally accepts a milliseconds parameter to specify the wait duration.\nReturns \"ok\" after the wait completes.\nUse this tool when you need to pause before executing the next command.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull WaitArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        long waitTime = args.getMilliseconds() <= 0L ? 5000L : args.getMilliseconds();
        try {
            TimeUnit.MILLISECONDS.sleep(waitTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new Response(null, "Wait interrupted", 1, null);
        }
        return new Response("ok", null, 2, null);
    }
}

