/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.devti.mcp.host.SearchInFilesArgs;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/SearchInFilesContentTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/SearchInFilesArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class SearchInFilesContentTool
extends AbstractMcpTool<SearchInFilesArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public SearchInFilesContentTool() {
        this.name = "search_in_files_content";
        this.description = "\n        Searches for a text substring within all files in the project using IntelliJ's search engine.\n        Use this tool to find files containing specific text content.\n        Requires a searchText parameter specifying the text to find.\n        Returns a JSON array of objects containing file information:\n        - path: Path relative to project root\n        Returns an empty array ([]) if no matches are found.\n        Note: Only searches through text files within the project directory.\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull SearchInFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "Project directory not found", 1, null);
        }
        Object projectDir = object;
        String searchSubstring = args.getSearchText();
        CharSequence charSequence = searchSubstring;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new Response(null, "contentSubstring parameter is required and cannot be blank", 1, null);
        }
        FindModel findModel = FindManager.getInstance((Project)project).getFindInProjectModel().clone();
        Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"clone(...)");
        FindModel findModel2 = findModel;
        findModel2.setStringToFind(searchSubstring);
        findModel2.setCaseSensitive(false);
        findModel2.setWholeWordsOnly(false);
        findModel2.setRegularExpressions(false);
        findModel2.setProjectScope(true);
        Set results2 = new LinkedHashSet();
        Processor processor = arg_0 -> SearchInFilesContentTool.handle$lambda$0((Path)projectDir, results2, arg_0);
        FindInProjectUtil.findUsages((FindModel)findModel2, (Project)project, (Processor)processor, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
        String jsonResult = CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        return new Response(jsonResult, null, 2, null);
    }

    private static final boolean handle$lambda$0(Path $projectDir, Set $results, UsageInfo usageInfo) {
        VirtualFile virtualFile = usageInfo.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile;
        try {
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            String relativePath = ((Object)$projectDir.relativize(path)).toString();
            $results.add("{\"path\": \"" + relativePath + "\", \"name\": \"" + virtualFile2.getName() + "\"}");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }
}

