/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.ReplaceTextByPathToolArgs;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/ReplaceTextByPathTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/ReplaceTextByPathToolArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class ReplaceTextByPathTool
extends AbstractMcpTool<ReplaceTextByPathToolArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public ReplaceTextByPathTool() {
        this.name = "replace_file_text_by_path";
        this.description = "\n        Replaces the entire content of a specified file with new text, if the file is within the project.\n        Use this tool to modify file contents using a path relative to the project root.\n        Requires two parameters:\n        - pathInProject: The path to the target file, relative to project root\n        - text: The new content to write to the file\n        Returns one of these responses:\n        - \"ok\" if the file was successfully updated\n        - error \"project dir not found\" if project directory cannot be determined\n        - error \"file not found\" if the file doesn't exist\n        - error \"could not get document\" if the file content cannot be accessed\n        Note: Automatically saves the file after modification\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull ReplaceTextByPathToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "project dir not found", 1, null);
        }
        Object projectDir = object;
        Ref.ObjectRef document = new Ref.ObjectRef();
        String readResult = (String)ActionsKt.runReadAction(() -> ReplaceTextByPathTool.handle$lambda$0((Path)projectDir, args, project, document));
        if (!Intrinsics.areEqual((Object)readResult, (Object)"ok")) {
            return new Response(null, readResult, 1, null);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> ReplaceTextByPathTool.handle$lambda$1(document, args));
        return new Response("ok", null, 2, null);
    }

    private static final String handle$lambda$0(Path $projectDir, ReplaceTextByPathToolArgs $args, Project $project, Ref.ObjectRef $document) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(BuiltinMcpToolsKt.resolveRel($projectDir, $args.getPathInProject()));
        if (virtualFile == null) {
            return "file not found";
        }
        VirtualFile file = virtualFile;
        if (!GlobalSearchScope.allScope((Project)$project).contains(file)) {
            return "file not found";
        }
        $document.element = FileDocumentManager.getInstance().getDocument(file);
        if ($document.element == null) {
            return "could not get document";
        }
        return "ok";
    }

    private static final void handle$lambda$1(Ref.ObjectRef $document, ReplaceTextByPathToolArgs $args) {
        Object object = $document.element;
        Intrinsics.checkNotNull((Object)object);
        ((Document)object).setText((CharSequence)$args.getText());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Object object2 = $document.element;
        Intrinsics.checkNotNull((Object)object2);
        fileDocumentManager.saveDocument((Document)object2);
    }
}

