/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.OpenFileInEditorArgs;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/OpenFileInEditorTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/OpenFileInEditorArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class OpenFileInEditorTool
extends AbstractMcpTool<OpenFileInEditorArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public OpenFileInEditorTool() {
        this.name = "open_file_in_editor";
        this.description = "Opens the specified file in the JetBrains IDE editor.\nRequires a filePath parameter containing the path to the file to open.\nRequires two parameters:\n    - filePath: The path of file to open can be absolute or relative to the project root.\n    - text: The content to write into the new file\nReturns one of two possible responses:\n    - \"file is opened\" if the file was successfully created and populated\n    - \"file doesn't exist or can't be opened\" otherwise";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull OpenFileInEditorArgs args) {
        Response response;
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "can't find project dir", 1, null);
        }
        Object projectDir = object;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(args.getFilePath());
        if (virtualFile == null) {
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(BuiltinMcpToolsKt.resolveRel((Path)projectDir, args.getFilePath()));
        }
        if ((file = virtualFile) != null && file.exists()) {
            ActionsKt.invokeLater$default(null, () -> OpenFileInEditorTool.handle$lambda$0(project, file), (int)1, null);
            response = new Response("file is opened", null, 2, null);
        } else {
            response = new Response("file doesn't exist or can't be opened", null, 2, null);
        }
        return response;
    }

    private static final Unit handle$lambda$0(Project $project, VirtualFile $file) {
        FileEditorManager.getInstance((Project)$project).openFile($file, true);
        return Unit.INSTANCE;
    }
}

