/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.ListFilesInFolderArgs;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/ListFilesInFolderTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/ListFilesInFolderArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
@SourceDebugExtension(value={"SMAP\nBuiltinMcpTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/ListFilesInFolderTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,746:1\n1549#2:747\n1620#2,3:748\n*S KotlinDebug\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/ListFilesInFolderTool\n*L\n452#1:747\n452#1:748,3\n*E\n"})
public final class ListFilesInFolderTool
extends AbstractMcpTool<ListFilesInFolderArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public ListFilesInFolderTool() {
        this.name = "list_files_in_folder";
        this.description = "Lists all files and directories in the specified project folder.\nUse this tool to explore project structure and get contents of any directory.\nRequires a pathInProject parameter (use \"/\" for project root).\nReturns a JSON-formatted list of entries, where each entry contains:\n- name: The name of the file or directory\n- type: Either \"file\" or \"directory\"\n- path: Full path relative to project root\nReturns error if the specified path doesn't exist or is outside project scope.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull ListFilesInFolderArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "can't find project dir", 1, null);
        }
        Object projectDir = object;
        return (Response)ActionsKt.runReadAction(() -> ListFilesInFolderTool.handle$lambda$1((Path)projectDir, args));
    }

    /*
     * WARNING - void declaration
     */
    private static final Response handle$lambda$1(Path $projectDir, ListFilesInFolderArgs $args) {
        Response response;
        try {
            void $this$mapTo$iv$iv;
            Path targetDir = BuiltinMcpToolsKt.resolveRel($projectDir, $args.getPathInProject());
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(targetDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return new Response(null, "directory not found", 1, null);
            }
            Iterable $this$map$iv = PathsKt.listDirectoryEntries$default((Path)targetDir, null, (int)1, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                String type = Files.isDirectory((Path)entry, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? "directory" : "file";
                String relativePath = ((Object)$projectDir.relativize((Path)entry)).toString();
                collection.add("{\"name\": \"" + PathsKt.getName((Path)entry) + "\", \"type\": \"" + type + "\", \"path\": \"" + relativePath + "\"}");
            }
            List entries = (List)destination$iv$iv;
            response = new Response(CollectionsKt.joinToString$default((Iterable)entries, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null), null, 2, null);
        }
        catch (Exception e) {
            response = new Response(null, "Error listing directory: " + e.getMessage(), 1, null);
        }
        return response;
    }
}

