/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.gui.AutoDevToolWindowFactory;
import cc.unitmesh.devti.gui.chat.ChatCodingService;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.IssueArgs;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.devti.observer.agent.AgentStateService;
import cc.unitmesh.devti.observer.plan.PlanReviewActionKt;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import cc.unitmesh.devti.sketch.AutoSketchModeListener;
import cc.unitmesh.devti.sketch.SketchToolWindow;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/IssueEvaluateTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/IssueArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class IssueEvaluateTool
extends AbstractMcpTool<IssueArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public IssueEvaluateTool() {
        this.name = "issue_or_story_evaluate";
        this.description = "This tool is used to evaluate an issue or story in the context of the project.\nRequires a issue parameter containing the issue description.\nReturns a the plan about this issue.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull IssueArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String issue = args.getIssue();
        ActionsKt.runInEdt$default(null, () -> IssueEvaluateTool.handle$lambda$1(project, issue), (int)1, null);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable hintDisposable = disposable;
        CompletableFuture<String> future = new CompletableFuture<String>();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(hintDisposable);
        connection.subscribe(AutoSketchModeListener.Companion.getTOPIC(), (Object)new AutoSketchModeListener(project, future){
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletableFuture<String> $future;
            {
                this.$project = $project;
                this.$future = $future;
            }

            public void start() {
            }

            /*
             * WARNING - void declaration
             */
            public void done() {
                List<Message> messages = ((AgentStateService)this.$project.getService(AgentStateService.class)).getAllMessages();
                Ref.ObjectRef plan = new Ref.ObjectRef();
                plan.element = "";
                Object object = (Message)CollectionsKt.lastOrNull(messages);
                if (object != null && (object = ((Message)object).getContent()) != null) {
                    Object v1;
                    Object object2;
                    block6: {
                        void $this$firstOrNull$iv;
                        Object object3;
                        Object it = object3 = object;
                        boolean bl = false;
                        object2 = CodeFence.Companion.parseAll((String)it);
                        Ref.ObjectRef objectRef = plan;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            CodeFence it2 = (CodeFence)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it2.getOriginLanguage(), (Object)"plan")) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    CodeFence codeFence = v1;
                    objectRef.element = codeFence != null && (object2 = codeFence.getText()) != null ? object2 : "";
                }
                if (((CharSequence)plan.element).length() > 0) {
                    v2 = this.$future.complete((String)plan.element);
                } else {
                    List<Message> messages2 = ((AgentStateService)this.$project.getService(AgentStateService.class)).getAllMessages();
                    if (!((Collection)messages2).isEmpty()) {
                        String plan2 = PlanReviewActionKt.reviewPlan(this.$project, true);
                        v2 = this.$future.complete(plan2);
                    } else {
                        CompletableFuture<String> completableFuture = this.$future;
                        throw new Exception("Failure to analysis");
                    }
                }
            }
        });
        return new Response(future.get(), null, 2, null);
    }

    private static final Unit handle$lambda$1$lambda$0(String $issue, SketchToolWindow ui, ChatCodingService chatCodingService) {
        Intrinsics.checkNotNullParameter((Object)((Object)ui), (String)"ui");
        Intrinsics.checkNotNullParameter((Object)chatCodingService, (String)"<unused var>");
        ui.sendInput($issue);
        return Unit.INSTANCE;
    }

    private static final Unit handle$lambda$1(Project $project, String $issue) {
        AutoSketchMode.Companion.getInstance($project).setEnable(true);
        AutoDevToolWindowFactory.Companion.sendToSketchToolWindow($project, ChatActionType.SKETCH, (Function2<? super SketchToolWindow, ? super ChatCodingService, Unit>)((Function2)(arg_0, arg_1) -> IssueEvaluateTool.handle$lambda$1$lambda$0($issue, arg_0, arg_1)));
        return Unit.INSTANCE;
    }
}

