/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.PathInProject;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/GetFileTextByPathTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/PathInProject;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class GetFileTextByPathTool
extends AbstractMcpTool<PathInProject> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public GetFileTextByPathTool() {
        this.name = "get_file_text_by_path";
        this.description = "\n        Retrieves the text content of a file using its path relative to project root.\n        Use this tool to read file contents when you have the file's project-relative path.\n        Requires a pathInProject parameter specifying the file location from project root.\n        Returns one of these responses:\n        - The file's content if the file exists and belongs to the project\n        - error \"project dir not found\" if project directory cannot be determined\n        - error \"file not found\" if the file doesn't exist or is outside project scope\n        Note: Automatically refreshes the file system before reading\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull PathInProject args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "project dir not found", 1, null);
        }
        Object projectDir = object;
        Response text = (Response)ActionsKt.runReadAction(() -> GetFileTextByPathTool.handle$lambda$0((Path)projectDir, args, project));
        return text;
    }

    private static final Response handle$lambda$0(Path $projectDir, PathInProject $args, Project $project) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(BuiltinMcpToolsKt.resolveRel($projectDir, $args.getPathInProject()));
        if (virtualFile == null) {
            return new Response(null, "file not found", 1, null);
        }
        VirtualFile file = virtualFile;
        return GlobalSearchScope.allScope((Project)$project).contains(file) ? new Response(BuiltinMcpToolsKt.readText(file), null, 2, null) : new Response(null, "file not found", 1, null);
    }
}

