/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.NoArgs;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/GetAllOpenFilePathsTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
@SourceDebugExtension(value={"SMAP\nBuiltinMcpTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/GetAllOpenFilePathsTool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,746:1\n11383#2,9:747\n13309#2:756\n13310#2:758\n11392#2:759\n1#3:757\n*S KotlinDebug\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/GetAllOpenFilePathsTool\n*L\n129#1:747,9\n129#1:756\n129#1:758\n129#1:759\n129#1:757\n*E\n"})
public final class GetAllOpenFilePathsTool
extends AbstractMcpTool<NoArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public GetAllOpenFilePathsTool() {
        this.name = "get_all_open_file_paths";
        this.description = "Lists full path relative paths to project root of all currently open files in the JetBrains IDE editor.\nReturns a list of file paths that are currently open in editor tabs.\nReturns an empty list if no files are open.\n\nUse this tool to explore current open editors.\nReturns a list of file paths separated by newline symbol.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull NoArgs args) {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] openFiles;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        Path projectDir = virtualFile != null ? BuiltinMcpToolsKt.toNioPathOrNull(virtualFile) : null;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] $this$mapNotNull$iv = openFiles = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Path path = it.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            if (BuiltinMcpToolsKt.relativizeByProjectDir(path, projectDir) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filePaths = (List)destination$iv$iv;
        return new Response(CollectionsKt.joinToString$default((Iterable)filePaths, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 2, null);
    }
}

