/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.Query;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/FindFilesByNameSubstring;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/Query;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
@SourceDebugExtension(value={"SMAP\nBuiltinMcpTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/FindFilesByNameSubstring\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,746:1\n3792#2:747\n4307#2,2:748\n1360#3:750\n1446#3,5:751\n766#3:756\n857#3,2:757\n*S KotlinDebug\n*F\n+ 1 BuiltinMcpTools.kt\ncc/unitmesh/devti/mcp/host/FindFilesByNameSubstring\n*L\n311#1:747\n311#1:748,2\n312#1:750\n312#1:751,5\n315#1:756\n315#1:757,2\n*E\n"})
public final class FindFilesByNameSubstring
extends AbstractMcpTool<Query> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public FindFilesByNameSubstring() {
        this.name = "find_files_by_name_substring";
        this.description = "\n        Searches for all files in the project whose names contain the specified substring (case-insensitive).\n        Use this tool to locate files when you know part of the filename.\n        Requires a nameSubstring parameter for the search term.\n        Returns a JSON array of objects containing file information:\n        - path: Path relative to project root\n        - name: File name\n        Returns an empty array ([]) if no matching files are found.\n        Note: Only searches through files within the project directory, excluding libraries and external dependencies.\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull Query args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "project dir not found", 1, null);
        }
        Object projectDir = object;
        String string = args.getNameSubstring().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String searchSubstring = string;
        return (Response)ActionsKt.runReadAction(() -> FindFilesByNameSubstring.handle$lambda$4(project, searchSubstring, (Path)projectDir));
    }

    private static final CharSequence handle$lambda$4$lambda$3(Path $projectDir, VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String relativePath = ((Object)$projectDir.relativize(path)).toString();
        return "{\"path\": \"" + relativePath + "\", \"name\": \"" + file.getName() + "\"}";
    }

    private static final Response handle$lambda$4(Project $project, String $searchSubstring, Path $projectDir) {
        Object $this$flatMapTo$iv$iv;
        boolean bl;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = FilenameIndex.getAllFilenames((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAllFilenames(...)");
        Object $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)$searchSubstring, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            String it = (String)t;
            boolean bl2 = false;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)it, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)$project));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)t;
            boolean bl2 = false;
            try {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Path path = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                $projectDir.relativize(path);
                bl = true;
            }
            catch (IllegalArgumentException e) {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(t);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string = null;
        String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> FindFilesByNameSubstring.handle$lambda$4$lambda$3($projectDir, arg_0), (int)24, null);
        return new Response(string2, string, n, defaultConstructorMarker);
    }
}

