/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.CreateTestForFileArgs;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.devti.provider.AutoTestService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/CreateTestForFileTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/CreateTestForFileArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class CreateTestForFileTool
extends AbstractMcpTool<CreateTestForFileArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public CreateTestForFileTool() {
        this.name = "create_test_for_file";
        this.description = "This tool is used to create a test for a file.\nRequires a file_name parameter containing the file name.\nReturns a the test code for this file.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull CreateTestForFileArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String fileName = args.getFileName();
        VirtualFile virtualFile = project.getBaseDir().findFileByRelativePath(fileName);
        if (virtualFile == null) {
            return new Response(null, "File not found", 1, null);
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile2 == null) {
            return new Response(null, "Current IDE don't support this file type", 1, null);
        }
        PsiFile psiFile3 = psiFile2;
        AutoTestService autoTestService = AutoTestService.Companion.context((PsiElement)psiFile3);
        if (autoTestService == null) {
            return new Response(null, "AutoDev don't support this file type", 1, null);
        }
        AutoTestService context = autoTestService;
        String string = context.runFileAsync(project, file, (PsiElement)psiFile3);
        if (string == null) {
            return new Response(null, "Failed to create test for file", 1, null);
        }
        String result = string;
        return new Response(result, null, 2, null);
    }
}

