/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.host;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.BuiltinMcpToolsKt;
import cc.unitmesh.devti.mcp.host.CreateNewFileWithTextArgs;
import cc.unitmesh.devti.mcp.host.Response;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/mcp/host/CreateNewFileWithTextTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/CreateNewFileWithTextArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "core"})
public final class CreateNewFileWithTextTool
extends AbstractMcpTool<CreateNewFileWithTextArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public CreateNewFileWithTextTool() {
        this.name = "create_new_file_with_text";
        this.description = "\n        Creates a new file at the specified path within the project directory and populates it with the provided text.\n        Use this tool to generate new files in your project structure.\n        Requires two parameters:\n            - pathInProject: The relative path where the file should be created\n            - text: The content to write into the new file\n        Returns one of two possible responses:\n            - \"ok\" if the file was successfully created and populated\n            - \"can't find project dir\" if the project directory cannot be determined\n        Note: Creates any necessary parent directories automatically\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull CreateNewFileWithTextArgs args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = BuiltinMcpToolsKt.toNioPathOrNull(object)) == null) {
            return new Response(null, "can't find project dir", 1, null);
        }
        Object projectDir = object;
        Path path = BuiltinMcpToolsKt.resolveRel((Path)projectDir, args.getPathInProject());
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(BuiltinMcpToolsKt.createParentDirectories(path, new FileAttribute[0]), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        String text = args.getText();
        PathsKt.writeText$default((Path)path, (CharSequence)BuiltinMcpToolsKt.access$unescape(text), null, (OpenOption[])new OpenOption[0], (int)2, null);
        LocalFileSystem.getInstance().refreshAndFindFileByNioFile(path);
        return new Response("ok", null, 2, null);
    }
}

