/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.editor;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.a2a.A2AClientConsumer;
import cc.unitmesh.devti.a2a.ui.A2AAgentListPanel;
import cc.unitmesh.devti.llm2.model.LlmConfig;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.custom.CustomLLMProvider;
import cc.unitmesh.devti.mcp.editor.McpPreviewEditor;
import cc.unitmesh.devti.mcp.ui.McpChatConfigDialog;
import cc.unitmesh.devti.mcp.ui.McpChatResultPanel;
import cc.unitmesh.devti.mcp.ui.McpToolListPanel;
import cc.unitmesh.devti.mcp.ui.model.McpChatConfig;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import cc.unitmesh.devti.util.AutoDevCoroutineScope;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import io.a2a.spec.AgentCard;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0002J\u0006\u00103\u001a\u000200J\u0006\u00104\u001a\u000200J\b\u00105\u001a\u000200H\u0002J\b\u00106\u001a\u00020\u001fH\u0002J\b\u00107\u001a\u00020\u001fH\u0002J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u000200H\u0002J\b\u0010:\u001a\u000200H\u0002J\u0014\u0010;\u001a\u0002002\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0002J\b\u0010>\u001a\u000200H\u0002J\b\u0010?\u001a\u000200H\u0002J\b\u0010@\u001a\u000200H\u0002J\u0006\u0010A\u001a\u000200J\b\u0010B\u001a\u000200H\u0002J\b\u0010C\u001a\u000200H\u0002J\u000e\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020\u0014J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020\u001fH\u0016J\u0010\u0010I\u001a\u0002002\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020MH\u0016J\b\u0010O\u001a\u00020\u0006H\u0016J\n\u0010P\u001a\u0004\u0018\u00010GH\u0016J\u0010\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u0002002\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010U\u001a\u000200H\u0016JN\u0010V\u001a\u000e\u0018\u0001HW\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\bX\"\u0010\b\u0000\u0010W*\n Z*\u0004\u0018\u00010Y0Y2 \b\u0001\u0010[\u001a\u001a\u0012\f\u0012\n Z*\u0004\u0018\u0001HWHW0\\\u00a2\u0006\u0002\b]\u00a2\u0006\u0002\bXH\u0097\u0001\u00a2\u0006\u0002\u0010^JX\u0010_\u001a\u000200\"\u0010\b\u0000\u0010W*\n Z*\u0004\u0018\u00010Y0Y2 \b\u0001\u0010[\u001a\u001a\u0012\f\u0012\n Z*\u0004\u0018\u0001HWHW0\\\u00a2\u0006\u0002\b]\u00a2\u0006\u0002\bX2\u0014\b\u0001\u0010`\u001a\u000e\u0018\u0001HW\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\bXH\u0096\u0001\u00a2\u0006\u0002\u0010aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcc/unitmesh/devti/mcp/editor/McpPreviewEditor;", "Lcom/intellij/openapi/util/UserDataHolder;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/Nullable;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "mainEditor", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/openapi/editor/Editor;", "mainPanel", "Ljavax/swing/JPanel;", "currentProtocol", "Lcc/unitmesh/devti/mcp/editor/McpPreviewEditor$ProtocolType;", "protocolToggleButton", "Ljavax/swing/JButton;", "toolListPanel", "Lcc/unitmesh/devti/mcp/ui/McpToolListPanel;", "chatbotSelector", "Ljavax/swing/JComboBox;", "", "chatInput", "Lcom/intellij/ui/components/JBTextField;", "testButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "configButton", "resultPanel", "Lcc/unitmesh/devti/mcp/ui/McpChatResultPanel;", "config", "Lcc/unitmesh/devti/mcp/ui/model/McpChatConfig;", "agentListPanel", "Lcc/unitmesh/devti/a2a/ui/A2AAgentListPanel;", "borderColor", "Lcom/intellij/ui/JBColor;", "searchField", "Lcom/intellij/ui/SearchTextField;", "loadContent", "", "loadTools", "loadAgents", "refreshMcpTool", "refreshA2AAgents", "createUI", "getHeaderTitle", "getToggleButtonText", "getSearchPlaceholder", "toggleProtocol", "updateHeaderTitle", "updateContentPanel", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "updateSearchPlaceholder", "filterContent", "showConfigDialog", "sendMessage", "sendMcpMessage", "sendA2AMessage", "setMainEditor", "editor", "getComponent", "Ljavax/swing/JComponent;", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "getFile", "getPreferredFocusedComponent", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "getUserData", "T", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "p0", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "p1", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "ProtocolType", "core"})
@SourceDebugExtension(value={"SMAP\nMcpPreviewEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpPreviewEditor.kt\ncc/unitmesh/devti/mcp/editor/McpPreviewEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,457:1\n1549#2:458\n1620#2,3:459\n288#2,2:490\n37#3,2:462\n4098#4,11:464\n4098#4,11:475\n125#5:486\n152#5,3:487\n*S KotlinDebug\n*F\n+ 1 McpPreviewEditor.kt\ncc/unitmesh/devti/mcp/editor/McpPreviewEditor\n*L\n188#1:458\n188#1:459,3\n361#1:490,2\n188#1:462,2\n307#1:464,11\n309#1:475,11\n353#1:486\n353#1:487,3\n*E\n"})
public class McpPreviewEditor
implements UserDataHolder,
FileEditor {
    private final /* synthetic */ UserDataHolderBase $$delegate_0;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @Nullable
    private final PsiFile psiFile;
    @NotNull
    private MutableStateFlow<Editor> mainEditor;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private ProtocolType currentProtocol;
    private JButton protocolToggleButton;
    private McpToolListPanel toolListPanel;
    private JComboBox<String> chatbotSelector;
    private JBTextField chatInput;
    private ActionButton testButton;
    private JButton configButton;
    private McpChatResultPanel resultPanel;
    @NotNull
    private final McpChatConfig config;
    private A2AAgentListPanel agentListPanel;
    @NotNull
    private final JBColor borderColor;
    private SearchTextField searchField;

    public McpPreviewEditor(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.$$delegate_0 = new UserDataHolderBase();
        this.project = project;
        this.virtualFile = virtualFile;
        this.psiFile = PsiManager.getInstance((Project)this.project).findFile(this.virtualFile);
        this.mainEditor = StateFlowKt.MutableStateFlow(null);
        this.mainPanel = new JPanel(new BorderLayout());
        this.currentProtocol = ProtocolType.MCP;
        this.config = new McpChatConfig(0.0, null, null, 7, null);
        this.borderColor = new JBColor(15067115, 3948353);
        this.createUI();
        this.loadContent();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    private final void loadContent() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1: {
                this.loadTools();
                break;
            }
            case 2: {
                this.loadAgents();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void loadTools() {
        String content = (String)ActionsKt.runReadAction(() -> McpPreviewEditor.loadTools$lambda$0(this));
        McpToolListPanel mcpToolListPanel = this.toolListPanel;
        if (mcpToolListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
            mcpToolListPanel = null;
        }
        McpToolListPanel.loadTools$default(mcpToolListPanel, content, null, 2, null);
    }

    private final void loadAgents() {
        String content = (String)ActionsKt.runReadAction(() -> McpPreviewEditor.loadAgents$lambda$1(this));
        A2AAgentListPanel a2AAgentListPanel = this.agentListPanel;
        if (a2AAgentListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
            a2AAgentListPanel = null;
        }
        A2AAgentListPanel.loadAgents$default(a2AAgentListPanel, content, null, 2, null);
    }

    public final void refreshMcpTool() {
        this.loadTools();
    }

    public final void refreshA2AAgents() {
        this.loadAgents();
    }

    /*
     * WARNING - void declaration
     */
    private final void createUI() {
        JSplitPane jSplitPane;
        Presentation $this$createUI_u24lambda_u2421;
        JPanel $this$createUI_u24lambda_u2417;
        JButton $this$toTypedArray$iv;
        Object[] objectArray;
        BorderLayoutPanel $this$createUI_u24lambda_u2411;
        DialogPanel dialogPanel = BuilderKt.panel(arg_0 -> McpPreviewEditor.createUI$lambda$7(this, arg_0));
        Object $this$createUI_u24lambda_u248 = dialogPanel;
        boolean bl = false;
        $this$createUI_u24lambda_u248.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)this.borderColor));
        DialogPanel headerPanel2 = dialogPanel;
        Object $this$createUI_u24lambda_u249 = $this$createUI_u24lambda_u248 = new JPanel(new BorderLayout());
        boolean bl2 = false;
        ((JComponent)$this$createUI_u24lambda_u249).setBackground(UIUtil.getPanelBackground());
        ((JComponent)$this$createUI_u24lambda_u249).setBorder((Border)JBUI.Borders.empty());
        Object contentWrapper = $this$createUI_u24lambda_u248;
        this.toolListPanel = new McpToolListPanel(this.project);
        this.agentListPanel = new A2AAgentListPanel(this.project);
        Object $this$createUI_u24lambda_u2410 = $this$createUI_u24lambda_u249 = new JBScrollPane();
        boolean bl3 = false;
        $this$createUI_u24lambda_u2410.setBorder(BorderFactory.createEmptyBorder());
        $this$createUI_u24lambda_u2410.setBackground(UIUtil.getPanelBackground());
        Object contentScrollPane = $this$createUI_u24lambda_u249;
        this.updateContentPanel((JBScrollPane)contentScrollPane);
        $this$createUI_u24lambda_u2410 = $this$createUI_u24lambda_u249 = new McpChatResultPanel(this.project, this.config);
        Object object = this;
        boolean bl4 = false;
        $this$createUI_u24lambda_u2411.setBackground(UIUtil.getPanelBackground());
        $this$createUI_u24lambda_u2411.setVisible(false);
        ((McpPreviewEditor)object).resultPanel = $this$createUI_u24lambda_u249;
        ((Container)contentWrapper).add((Component)contentScrollPane, "Center");
        BorderLayoutPanel $this$createUI_u24lambda_u2412 = $this$createUI_u24lambda_u2411 = new BorderLayoutPanel();
        boolean bl5 = false;
        $this$createUI_u24lambda_u2412.setBackground(UIUtil.getPanelBackground());
        $this$createUI_u24lambda_u2412.setBorder((Border)new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)this.borderColor), JBUI.Borders.empty((int)4)));
        BorderLayoutPanel bottomPanel = $this$createUI_u24lambda_u2411;
        $this$createUI_u24lambda_u2412 = new BorderLayoutPanel();
        Object $this$createUI_u24lambda_u2413 = $this$createUI_u24lambda_u2412;
        boolean bl6 = false;
        $this$createUI_u24lambda_u2413.setBackground(UIUtil.getPanelBackground());
        $this$createUI_u24lambda_u2413.setBorder((Border)new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)this.borderColor), (Border)JBUI.Borders.empty()));
        BorderLayoutPanel chatbotPanel = $this$createUI_u24lambda_u2412;
        Object $this$createUI_u24lambda_u2414 = $this$createUI_u24lambda_u2413 = new JPanel(new FlowLayout(0, 4, 0));
        boolean bl7 = false;
        ((JComponent)$this$createUI_u24lambda_u2414).setBackground(UIUtil.getPanelBackground());
        Object selectorPanel = $this$createUI_u24lambda_u2413;
        JBLabel chatbotLabel = new JBLabel(AutoDevBundle.message("mcp.preview.editor.model.label", new Object[0]));
        List<LlmConfig> llmConfigs = LlmConfig.Companion.load();
        if (llmConfigs.isEmpty()) {
            Object[] objectArray2 = new String[]{"Default"};
            objectArray = objectArray2;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = llmConfigs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LlmConfig llmConfig = (LlmConfig)item$iv$iv;
                object = destination$iv$iv;
                boolean bl8 = false;
                object.add(it.getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            JButton thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
        }
        Object[] modelNames = objectArray;
        this.chatbotSelector = (JComboBox)new ComboBox(modelNames);
        JButton $i$f$toTypedArray = $this$toTypedArray$iv = new JButton(AutoDevBundle.message("mcp.preview.editor.configure.button", new Object[0]));
        object = this;
        boolean bl9 = false;
        ((AbstractButton)((Object)$this$createUI_u24lambda_u2417)).setFocusPainted(false);
        ((AbstractButton)((Object)$this$createUI_u24lambda_u2417)).addActionListener(arg_0 -> McpPreviewEditor.createUI$lambda$17$lambda$16(this, arg_0));
        ((McpPreviewEditor)object).configButton = $this$toTypedArray$iv;
        ((Container)selectorPanel).add((Component)chatbotLabel);
        JComboBox<String> jComboBox = this.chatbotSelector;
        if (jComboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatbotSelector");
            jComboBox = null;
        }
        ((Container)selectorPanel).add(jComboBox);
        JPanel $this$createUI_u24lambda_u2418 = $this$createUI_u24lambda_u2417 = new JPanel(new FlowLayout(2, 4, 0));
        boolean bl10 = false;
        $this$createUI_u24lambda_u2418.setBackground(UIUtil.getPanelBackground());
        JButton jButton = this.configButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configButton");
            jButton = null;
        }
        $this$createUI_u24lambda_u2418.add(jButton);
        JPanel configPanel = $this$createUI_u24lambda_u2417;
        chatbotPanel.addToLeft((Component)selectorPanel);
        chatbotPanel.addToRight((Component)configPanel);
        JPanel $this$createUI_u24lambda_u2419 = $this$createUI_u24lambda_u2418 = new BorderLayoutPanel();
        boolean bl11 = false;
        $this$createUI_u24lambda_u2419.setBackground(UIUtil.getPanelBackground());
        $this$createUI_u24lambda_u2419.setBorder((Border)JBUI.Borders.empty());
        JPanel inputPanel2 = $this$createUI_u24lambda_u2418;
        $this$createUI_u24lambda_u2419 = $this$createUI_u24lambda_u2418 = new JBTextField();
        object = this;
        boolean bl12 = false;
        $this$createUI_u24lambda_u2421.setBorder((Border)new CompoundBorder(BorderFactory.createLineBorder((Color)this.borderColor), JBUI.Borders.empty((int)4)));
        $this$createUI_u24lambda_u2421.addActionListener(arg_0 -> McpPreviewEditor.createUI$lambda$21$lambda$20(this, arg_0));
        ((McpPreviewEditor)object).chatInput = $this$createUI_u24lambda_u2418;
        $this$createUI_u24lambda_u2421 = new Presentation("Test");
        Object $this$createUI_u24lambda_u2422 = $this$createUI_u24lambda_u2421;
        boolean bl13 = false;
        $this$createUI_u24lambda_u2422.setIcon(AutoDevIcons.SEND);
        $this$createUI_u24lambda_u2422.setDescription("Test Called tools");
        Presentation sendPresentation = $this$createUI_u24lambda_u2421;
        this.testButton = new ActionButton((AnAction)DumbAwareAction.create(arg_0 -> McpPreviewEditor.createUI$lambda$24(arg_0 -> McpPreviewEditor.createUI$lambda$23(this, arg_0), arg_0)), sendPresentation, "McpSendAction", new Dimension(JBUI.scale((int)30), JBUI.scale((int)30)));
        Object $this$createUI_u24lambda_u2425 = $this$createUI_u24lambda_u2422 = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl14 = false;
        ((JComponent)$this$createUI_u24lambda_u2425).setBackground(UIUtil.getPanelBackground());
        ((JComponent)$this$createUI_u24lambda_u2425).setOpaque(false);
        ActionButton actionButton = this.testButton;
        if (actionButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testButton");
            actionButton = null;
        }
        ((Container)$this$createUI_u24lambda_u2425).add((Component)actionButton);
        Object sendButtonPanel = $this$createUI_u24lambda_u2422;
        JBTextField jBTextField = this.chatInput;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField = null;
        }
        inputPanel2.addToCenter((Component)jBTextField);
        inputPanel2.addToRight((Component)sendButtonPanel);
        Object $this$createUI_u24lambda_u2426 = $this$createUI_u24lambda_u2425 = new JPanel(new BorderLayout());
        boolean bl15 = false;
        ((JComponent)$this$createUI_u24lambda_u2426).setBackground(UIUtil.getPanelBackground());
        ((Container)$this$createUI_u24lambda_u2426).add((Component)chatbotPanel, "North");
        ((Container)$this$createUI_u24lambda_u2426).add((Component)inputPanel2, "South");
        Object chatControlsPanel = $this$createUI_u24lambda_u2425;
        McpChatResultPanel mcpChatResultPanel = this.resultPanel;
        if (mcpChatResultPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel = null;
        }
        bottomPanel.add((Component)mcpChatResultPanel, (Object)"Center");
        bottomPanel.add((Component)chatControlsPanel, (Object)"South");
        JSplitPane $this$createUI_u24lambda_u2427 = jSplitPane = new JSplitPane(0);
        boolean bl16 = false;
        $this$createUI_u24lambda_u2427.setTopComponent((Component)contentWrapper);
        $this$createUI_u24lambda_u2427.setBottomComponent((Component)bottomPanel);
        $this$createUI_u24lambda_u2427.setResizeWeight(0.8);
        $this$createUI_u24lambda_u2427.setContinuousLayout(true);
        $this$createUI_u24lambda_u2427.setBorder(BorderFactory.createEmptyBorder());
        $this$createUI_u24lambda_u2427.setDividerSize(JBUI.scale((int)5));
        JSplitPane splitPane = jSplitPane;
        this.mainPanel.add((Component)headerPanel2, "North");
        this.mainPanel.add((Component)splitPane, "Center");
    }

    private final String getHeaderTitle() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1 -> AutoDevBundle.message("mcp.preview.editor.title", new Object[0]);
            case 2 -> "A2A Agent Preview";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getToggleButtonText() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1 -> "Switch to A2A";
            case 2 -> "Switch to MCP";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getSearchPlaceholder() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1 -> AutoDevBundle.message("mcp.preview.editor.search.placeholder", new Object[0]);
            case 2 -> "Search agents...";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void toggleProtocol() {
        this.currentProtocol = switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1 -> ProtocolType.A2A;
            case 2 -> ProtocolType.MCP;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.updateHeaderTitle();
        McpPreviewEditor.updateContentPanel$default(this, null, 1, null);
        this.updateSearchPlaceholder();
        this.loadContent();
    }

    private final void updateHeaderTitle() {
        JButton jButton = this.protocolToggleButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"protocolToggleButton");
            jButton = null;
        }
        jButton.setText(this.getToggleButtonText());
    }

    private final void updateContentPanel(JBScrollPane scrollPane) {
        block11: {
            JBScrollPane targetScrollPane;
            JBScrollPane jBScrollPane = scrollPane;
            if (jBScrollPane == null) {
                JPanel jPanel;
                Component[] $this$filterIsInstanceTo$iv$iv;
                Component[] $this$filterIsInstance$iv;
                Component[] componentArray = this.mainPanel.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] objectArray = componentArray;
                boolean $i$f$filterIsInstance = false;
                void var8_4 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Component element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JSplitPane)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                JSplitPane jSplitPane = (JSplitPane)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                Component[] componentArray2 = jSplitPane != null ? jSplitPane.getTopComponent() : null;
                JPanel jPanel2 = jPanel = componentArray2 instanceof JPanel ? (JPanel)componentArray2 : null;
                if (jPanel != null && (componentArray2 = jPanel.getComponents()) != null) {
                    $this$filterIsInstance$iv = componentArray2;
                    $i$f$filterIsInstance = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterIsInstanceTo = false;
                    for (Component element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JBScrollPane)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    jBScrollPane = (JBScrollPane)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                } else {
                    jBScrollPane = null;
                }
            }
            JBScrollPane jBScrollPane2 = targetScrollPane = jBScrollPane;
            if (jBScrollPane2 == null) break block11;
            JBScrollPane sp = jBScrollPane2;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
                case 1: {
                    McpToolListPanel mcpToolListPanel = this.toolListPanel;
                    if (mcpToolListPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
                        mcpToolListPanel = null;
                    }
                    sp.setViewportView((Component)mcpToolListPanel);
                    break;
                }
                case 2: {
                    A2AAgentListPanel a2AAgentListPanel = this.agentListPanel;
                    if (a2AAgentListPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
                        a2AAgentListPanel = null;
                    }
                    sp.setViewportView((Component)a2AAgentListPanel);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            sp.revalidate();
            sp.repaint();
        }
    }

    static /* synthetic */ void updateContentPanel$default(McpPreviewEditor mcpPreviewEditor, JBScrollPane jBScrollPane, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateContentPanel");
        }
        if ((n & 1) != 0) {
            jBScrollPane = null;
        }
        mcpPreviewEditor.updateContentPanel(jBScrollPane);
    }

    private final void updateSearchPlaceholder() {
        SearchTextField searchTextField = this.searchField;
        if (searchTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchField");
            searchTextField = null;
        }
        searchTextField.getTextEditor().getEmptyText().setText(this.getSearchPlaceholder());
    }

    private final void filterContent() {
        SearchTextField searchTextField = this.searchField;
        if (searchTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchField");
            searchTextField = null;
        }
        String string = searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String searchText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1: {
                McpToolListPanel mcpToolListPanel = this.toolListPanel;
                if (mcpToolListPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
                    mcpToolListPanel = null;
                }
                mcpToolListPanel.filterTools(searchText);
                break;
            }
            case 2: {
                A2AAgentListPanel a2AAgentListPanel = this.agentListPanel;
                if (a2AAgentListPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
                    a2AAgentListPanel = null;
                }
                a2AAgentListPanel.filterAgents(searchText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void showConfigDialog() {
        McpChatConfigDialog dialog2;
        McpToolListPanel mcpToolListPanel = this.toolListPanel;
        if (mcpToolListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
            mcpToolListPanel = null;
        }
        if ((dialog2 = new McpChatConfigDialog(this.project, this.config, mcpToolListPanel.getTools())).showAndGet()) {
            this.config.setTemperature(dialog2.getConfig().getTemperature());
            this.config.setEnabledTools(dialog2.getConfig().getEnabledTools());
            this.config.setSystemPrompt(dialog2.getConfig().getSystemPrompt());
        }
    }

    public final void sendMessage() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentProtocol.ordinal()]) {
            case 1: {
                this.sendMcpMessage();
                break;
            }
            case 2: {
                this.sendA2AMessage();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendMcpMessage() {
        LlmConfig llmConfig;
        Object v5;
        block13: {
            JBTextField jBTextField;
            if (this.config.getEnabledTools().isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map<String, List<Tool>> allTools;
                McpToolListPanel mcpToolListPanel = this.toolListPanel;
                if (mcpToolListPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
                    mcpToolListPanel = null;
                }
                Map<String, List<Tool>> map = allTools = mcpToolListPanel.getTools();
                McpChatConfig mcpChatConfig = this.config;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((List)it.getValue());
                }
                mcpChatConfig.setEnabledTools(CollectionsKt.toMutableList((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
            }
            if ((jBTextField = this.chatInput) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
                jBTextField = null;
            }
            String string = jBTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                AutoDevNotifications.INSTANCE.warn(this.project, AutoDevBundle.message("mcp.preview.editor.empty.message.warning", new Object[0]));
                return;
            }
            Iterable $this$firstOrNull$iv = LlmConfig.Companion.load();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LlmConfig it = (LlmConfig)element$iv;
                boolean bl = false;
                String string2 = it.getName();
                JComboBox<String> jComboBox = this.chatbotSelector;
                if (jComboBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chatbotSelector");
                    jComboBox = null;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)jComboBox.getSelectedItem())) continue;
                v5 = element$iv;
                break block13;
            }
            v5 = null;
        }
        if ((llmConfig = (LlmConfig)v5) == null) {
            llmConfig = LlmConfig.Companion.default();
        }
        LlmConfig llmConfig2 = llmConfig;
        CustomLLMProvider llmProvider = new CustomLLMProvider(this.project, llmConfig2);
        JBTextField jBTextField = this.chatInput;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
        JBTextField jBTextField2 = this.chatInput;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField2 = null;
        }
        jBTextField2.setText("");
        StringBuilder result = new StringBuilder();
        String systemPrompt = this.config.createSystemPrompt();
        Flow stream2 = LLMProvider.DefaultImpls.stream$default(llmProvider, message, systemPrompt, false, false, 12, null);
        McpChatResultPanel mcpChatResultPanel = this.resultPanel;
        if (mcpChatResultPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel = null;
        }
        mcpChatResultPanel.reset();
        McpChatResultPanel mcpChatResultPanel2 = this.resultPanel;
        if (mcpChatResultPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel2 = null;
        }
        mcpChatResultPanel2.setText(AutoDevBundle.message("mcp.preview.editor.loading.response", new Object[0]));
        McpChatResultPanel mcpChatResultPanel3 = this.resultPanel;
        if (mcpChatResultPanel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel3 = null;
        }
        mcpChatResultPanel3.setVisible(true);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope(this.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<String>)stream2, this, result, null){
            int label;
            final /* synthetic */ Flow<String> $stream;
            final /* synthetic */ McpPreviewEditor this$0;
            final /* synthetic */ StringBuilder $result;
            {
                this.$stream = $stream;
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FlowKt.cancellable(this.$stream).collect(new FlowCollector(this.$result, this.this$0){
                            final /* synthetic */ StringBuilder $result;
                            final /* synthetic */ McpPreviewEditor this$0;
                            {
                                this.$result = $result;
                                this.this$0 = $receiver;
                            }

                            public final Object emit(String chunk, Continuation<? super Unit> $completion) {
                                this.$result.append(chunk);
                                SwingUtilities.invokeLater(() -> sendMcpMessage.1.emit$lambda$0(this.this$0, this.$result));
                                return Unit.INSTANCE;
                            }

                            private static final void emit$lambda$0(McpPreviewEditor this$0, StringBuilder $result) {
                                McpChatResultPanel mcpChatResultPanel = McpPreviewEditor.access$getResultPanel$p(this$0);
                                if (mcpChatResultPanel == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
                                    mcpChatResultPanel = null;
                                }
                                String string = $result.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                mcpChatResultPanel.setText(string);
                            }
                        }, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = McpPreviewEditor.access$getResultPanel$p(this.this$0)) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
                            v1 = null;
                        }
                        v2 = this.$result.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                        v1.parseAndShowTools(v2);
                        McpPreviewEditor.access$getMainPanel$p(this.this$0).revalidate();
                        McpPreviewEditor.access$getMainPanel$p(this.this$0).repaint();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void sendA2AMessage() {
        McpChatResultPanel mcpChatResultPanel;
        String agentName;
        Map<String, List<AgentCard>> agents;
        JBTextField jBTextField = this.chatInput;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            AutoDevNotifications.INSTANCE.warn(this.project, "Please enter a message to send.");
            return;
        }
        JBTextField jBTextField2 = this.chatInput;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField2 = null;
        }
        String message = jBTextField2.getText();
        A2AAgentListPanel a2AAgentListPanel = this.agentListPanel;
        if (a2AAgentListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
            a2AAgentListPanel = null;
        }
        if ((agents = a2AAgentListPanel.getAgents()).isEmpty()) {
            AutoDevNotifications.INSTANCE.warn(this.project, "No A2A agents available. Please check your configuration.");
            return;
        }
        AgentCard firstAgent = (AgentCard)CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)agents.values()));
        if (firstAgent == null) {
            AutoDevNotifications.INSTANCE.warn(this.project, "No A2A agents found.");
            return;
        }
        String string2 = firstAgent.name();
        if (string2 == null) {
            string2 = agentName = "Unknown Agent";
        }
        if ((mcpChatResultPanel = this.resultPanel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel = null;
        }
        mcpChatResultPanel.setVisible(true);
        McpChatResultPanel mcpChatResultPanel2 = this.resultPanel;
        if (mcpChatResultPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
            mcpChatResultPanel2 = null;
        }
        mcpChatResultPanel2.setText("Sending message to " + agentName + "...");
        BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope(this.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, agentName, message, null){
            int label;
            final /* synthetic */ McpPreviewEditor this$0;
            final /* synthetic */ String $agentName;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$agentName = $agentName;
                this.$message = $message;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            A2AAgentListPanel a2AAgentListPanel = McpPreviewEditor.access$getAgentListPanel$p(this.this$0);
                            if (a2AAgentListPanel == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
                                a2AAgentListPanel = null;
                            }
                            A2AClientConsumer a2aClient = a2AAgentListPanel.getA2AClientConsumer();
                            String string = this.$message;
                            Intrinsics.checkNotNull((Object)string);
                            String response = a2aClient.sendMessage(this.$agentName, string);
                            SwingUtilities.invokeLater(() -> sendA2AMessage.1.invokeSuspend$lambda$0(this.this$0, response));
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(() -> sendA2AMessage.1.invokeSuspend$lambda$1(this.this$0, e));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(McpPreviewEditor this$0, String $response) {
                McpChatResultPanel mcpChatResultPanel = McpPreviewEditor.access$getResultPanel$p(this$0);
                if (mcpChatResultPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
                    mcpChatResultPanel = null;
                }
                mcpChatResultPanel.setText($response);
                McpPreviewEditor.access$getMainPanel$p(this$0).revalidate();
                McpPreviewEditor.access$getMainPanel$p(this$0).repaint();
            }

            private static final void invokeSuspend$lambda$1(McpPreviewEditor this$0, Exception $e) {
                McpChatResultPanel mcpChatResultPanel = McpPreviewEditor.access$getResultPanel$p(this$0);
                if (mcpChatResultPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resultPanel");
                    mcpChatResultPanel = null;
                }
                mcpChatResultPanel.setText("Error sending message: " + $e.getMessage());
                AutoDevNotifications.INSTANCE.error(this$0.getProject(), "Failed to send A2A message: " + $e.getMessage());
            }
        }), (int)3, null);
    }

    public final void setMainEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(this.mainEditor.getValue() == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.mainEditor.setValue((Object)editor);
    }

    @NotNull
    public JComponent getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public String getName() {
        return "MCP Preview";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.virtualFile;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.chatInput;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatInput");
            jBTextField = null;
        }
        return (JComponent)jBTextField;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void dispose() {
        McpToolListPanel mcpToolListPanel = this.toolListPanel;
        if (mcpToolListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolListPanel");
            mcpToolListPanel = null;
        }
        mcpToolListPanel.dispose();
        A2AAgentListPanel a2AAgentListPanel = this.agentListPanel;
        if (a2AAgentListPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agentListPanel");
            a2AAgentListPanel = null;
        }
        a2AAgentListPanel.dispose();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        return (T)this.$$delegate_0.getUserData(p0);
    }

    public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.$$delegate_0.putUserData(p0, p1);
    }

    private static final String loadTools$lambda$0(McpPreviewEditor this$0) {
        return SingleFileDiffSketchKt.readText(this$0.virtualFile);
    }

    private static final String loadAgents$lambda$1(McpPreviewEditor this$0) {
        return SingleFileDiffSketchKt.readText(this$0.virtualFile);
    }

    private static final void createUI$lambda$7$lambda$6$lambda$4$lambda$3(McpPreviewEditor this$0, ActionEvent it) {
        this$0.toggleProtocol();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createUI$lambda$7$lambda$6(McpPreviewEditor this$0, Row $this$row) {
        void $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u245;
        Object $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u244;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBLabel $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u242 = object = new JBLabel(this$0.getHeaderTitle());
        boolean bl = false;
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u242.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u242.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u242.setOpaque(true);
        JBLabel label = object;
        $this$row.cell((JComponent)label).align(Align.FILL).resizableColumn();
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u242 = object = new JButton(this$0.getToggleButtonText());
        McpPreviewEditor mcpPreviewEditor = this$0;
        boolean bl2 = false;
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u244.addActionListener(arg_0 -> McpPreviewEditor.createUI$lambda$7$lambda$6$lambda$4$lambda$3(this$0, arg_0));
        mcpPreviewEditor.protocolToggleButton = object;
        JButton jButton = this$0.protocolToggleButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"protocolToggleButton");
            jButton = null;
        }
        $this$row.cell((JComponent)jButton);
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u244 = object = new SearchTextField();
        mcpPreviewEditor = this$0;
        boolean bl3 = false;
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u245.getTextEditor().getEmptyText().setText(this$0.getSearchPlaceholder());
        $this$createUI_u24lambda_u247_u24lambda_u246_u24lambda_u245.getTextEditor().getDocument().addDocumentListener(new DocumentListener(this$0){
            final /* synthetic */ McpPreviewEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                McpPreviewEditor.access$filterContent(this.this$0);
            }

            public void removeUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                McpPreviewEditor.access$filterContent(this.this$0);
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                McpPreviewEditor.access$filterContent(this.this$0);
            }
        });
        mcpPreviewEditor.searchField = object;
        SearchTextField searchTextField = this$0.searchField;
        if (searchTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchField");
            searchTextField = null;
        }
        $this$row.cell((JComponent)searchTextField).align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit createUI$lambda$7(McpPreviewEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpPreviewEditor.createUI$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createUI$lambda$17$lambda$16(McpPreviewEditor this$0, ActionEvent it) {
        this$0.showConfigDialog();
    }

    private static final void createUI$lambda$21$lambda$20(McpPreviewEditor this$0, ActionEvent it) {
        this$0.sendMessage();
    }

    private static final Unit createUI$lambda$23(McpPreviewEditor this$0, AnActionEvent it) {
        this$0.sendMessage();
        return Unit.INSTANCE;
    }

    private static final void createUI$lambda$24(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ McpChatResultPanel access$getResultPanel$p(McpPreviewEditor $this) {
        return $this.resultPanel;
    }

    public static final /* synthetic */ JPanel access$getMainPanel$p(McpPreviewEditor $this) {
        return $this.mainPanel;
    }

    public static final /* synthetic */ A2AAgentListPanel access$getAgentListPanel$p(McpPreviewEditor $this) {
        return $this.agentListPanel;
    }

    public static final /* synthetic */ void access$filterContent(McpPreviewEditor $this) {
        $this.filterContent();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/mcp/editor/McpPreviewEditor$ProtocolType;", "", "<init>", "(Ljava/lang/String;I)V", "MCP", "A2A", "core"})
    private static final class ProtocolType
    extends Enum<ProtocolType> {
        public static final /* enum */ ProtocolType MCP = new ProtocolType();
        public static final /* enum */ ProtocolType A2A = new ProtocolType();
        private static final /* synthetic */ ProtocolType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProtocolType[] values() {
            return (ProtocolType[])$VALUES.clone();
        }

        public static ProtocolType valueOf(String value) {
            return Enum.valueOf(ProtocolType.class, value);
        }

        @NotNull
        public static EnumEntries<ProtocolType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = protocolTypeArray = new ProtocolType[]{ProtocolType.MCP, ProtocolType.A2A};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtocolType.values().length];
            try {
                nArray[ProtocolType.MCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtocolType.A2A.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

