/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp.client;

import cc.unitmesh.devti.mcp.client.CustomMcpServerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"resolveCommand", "", "command", "core"})
@SourceDebugExtension(value={"SMAP\nCommandResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandResolver.kt\ncc/unitmesh/devti/mcp/client/CommandResolverKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n11#2:60\n11#2:63\n1855#3,2:61\n*S KotlinDebug\n*F\n+ 1 CommandResolver.kt\ncc/unitmesh/devti/mcp/client/CommandResolverKt\n*L\n18#1:60\n55#1:63\n31#1:61,2\n*E\n"})
public final class CommandResolverKt {
    @NotNull
    public static final String resolveCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (SystemInfo.isWindows) {
            try {
                String[] stringArray = new String[]{"where", command};
                ProcessBuilder pb = new ProcessBuilder(stringArray);
                Process process2 = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                String resolved = reader.readLine();
                CharSequence charSequence = resolved;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    return ((Object)StringsKt.trim((CharSequence)resolved)).toString();
                }
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(CustomMcpServerManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to resolve command using where: " + e);
            }
        } else {
            String path;
            String element$iv;
            Object object;
            Object $this$forEach$iv;
            String homeDir = System.getProperty("user.home");
            if (Intrinsics.areEqual((Object)command, (Object)"npx")) {
                Object[] reader = new String[]{"/opt/homebrew/bin/npx", "/usr/local/bin/npx", "/usr/bin/npx", homeDir + "/.volta/bin/npx", homeDir + "/.nvm/current/bin/npx", homeDir + "/.npm-global/bin/npx"};
                List knownPaths = CollectionsKt.listOf((Object[])reader);
                $this$forEach$iv = knownPaths;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    path = element$iv = object.next();
                    boolean bl = false;
                    if (!new File(path).exists()) continue;
                    return path;
                }
            }
            try {
                String string;
                String currentPath;
                $this$forEach$iv = new String[]{"which", command};
                ProcessBuilder pb = new ProcessBuilder((String[])$this$forEach$iv);
                String string2 = System.getenv("PATH");
                if (string2 == null) {
                    string2 = currentPath = "";
                }
                if (Intrinsics.areEqual((Object)command, (Object)"npx")) {
                    object = new String[]{"/opt/homebrew/bin", "/opt/homebrew/sbin", "/usr/local/bin", homeDir + "/.volta/bin", homeDir + "/.nvm/current/bin", homeDir + "/.npm-global/bin"};
                    string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])object), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
                } else {
                    string = "";
                }
                String additionalPaths = string;
                Map<String, String> map = pb.environment();
                Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
                object = map;
                element$iv = "PATH";
                path = !StringsKt.isBlank((CharSequence)additionalPaths) ? additionalPaths + ":" + currentPath : currentPath;
                object.put(element$iv, path);
                Process process3 = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process3.getInputStream()));
                String resolved = reader.readLine();
                CharSequence charSequence = resolved;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    return ((Object)StringsKt.trim((CharSequence)resolved)).toString();
                }
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(CustomMcpServerManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to resolve command using which: " + e);
            }
        }
        return command;
    }
}

