/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.mcp;

import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/mcp/MCPServerStartupValidator;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "GROUP_ID", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "isNpxInstalled", "", "checkNpxWindows", "checkNpxUnix", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
@SourceDebugExtension(value={"SMAP\nMCPServerStartupValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MCPServerStartupValidator.kt\ncc/unitmesh/devti/mcp/MCPServerStartupValidator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n11#2:157\n*S KotlinDebug\n*F\n+ 1 MCPServerStartupValidator.kt\ncc/unitmesh/devti/mcp/MCPServerStartupValidator\n*L\n23#1:157\n*E\n"})
public final class MCPServerStartupValidator
implements ProjectActivity {
    @NotNull
    private final String GROUP_ID;
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(MCPServerStartupValidator::logger_delegate$lambda$0);

    public MCPServerStartupValidator() {
        this.GROUP_ID = "UnitMesh.MCPServer";
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    public final boolean isNpxInstalled() {
        boolean bl;
        try {
            boolean bl2;
            this.getLogger().info("Starting npx installation check");
            if (SystemInfo.isWindows) {
                this.getLogger().info("Detected Windows OS, using 'where' command");
                bl2 = this.checkNpxWindows();
            } else {
                this.getLogger().info("Detected non-Windows OS, checking known locations");
                bl2 = this.checkNpxUnix();
            }
            bl = bl2;
        }
        catch (Exception e) {
            this.getLogger().error("Failed to check npx installation", (Throwable)e);
            this.getLogger().error("Exception details - Class: " + e.getClass().getName() + ", Message: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNpxWindows() {
        String[] stringArray = new String[]{"where", "npx"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        this.getLogger().info("Windows - Environment PATH: " + commandLine.getEnvironment().get("PATH"));
        OSProcessHandler handler = new OSProcessHandler(commandLine);
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(output, error){
            final /* synthetic */ StringBuilder $output;
            final /* synthetic */ StringBuilder $error;
            {
                this.$output = $output;
                this.$error = $error;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Key<?> key = outputType;
                if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
                    this.$output.append(event.getText());
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDERR)) {
                    this.$error.append(event.getText());
                }
            }
        });
        handler.startNotify();
        boolean completed = handler.waitFor(5000L);
        this.getLogger().info("Windows - where npx completed with success: " + completed);
        if (!StringsKt.isBlank((CharSequence)output)) {
            this.getLogger().info("Windows - Output: " + output);
        }
        if (!StringsKt.isBlank((CharSequence)error)) {
            this.getLogger().warn("Windows - Error: " + error);
        }
        if (!completed) return false;
        Integer n = handler.getExitCode();
        if (n == null) return false;
        if (n != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNpxUnix() {
        Object v0;
        String path;
        String[] stringArray;
        String homeDir;
        block5: {
            homeDir = System.getProperty("user.home");
            Object[] objectArray = new String[]{"/opt/homebrew/bin/npx", "/usr/local/bin/npx", "/usr/bin/npx", homeDir + "/.volta/bin/npx", homeDir + "/.nvm/current/bin/npx", homeDir + "/.npm-global/bin/npx"};
            List knownPaths = CollectionsKt.listOf((Object[])objectArray);
            this.getLogger().info("Unix - Checking known npx locations: " + CollectionsKt.joinToString$default((Iterable)knownPaths, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            stringArray = (String[])knownPaths;
            for (Object t : stringArray) {
                File file;
                path = (String)t;
                boolean bl = false;
                File it = file = new File(path);
                boolean bl2 = false;
                this.getLogger().info("Unix - Checking path: " + path + " exists: " + it.exists());
                if (!file.exists()) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        String existingPath = v0;
        if (existingPath != null) {
            this.getLogger().info("Unix - Found npx at: " + existingPath);
            return true;
        }
        this.getLogger().info("Unix - No npx found in known locations, trying which command");
        stringArray = new String[]{"which", "npx"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        String string = System.getenv("PATH");
        if (string == null) {
            string = "";
        }
        String currentPath = string;
        Object[] objectArray = new String[]{"/opt/homebrew/bin", "/opt/homebrew/sbin", "/usr/local/bin", homeDir + "/.volta/bin", homeDir + "/.nvm/current/bin", homeDir + "/.npm-global/bin"};
        String additionalPaths = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
        Map map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map map2 = map;
        path = "PATH";
        String bl = additionalPaths + ":" + currentPath;
        map2.put(path, bl);
        this.getLogger().info("Unix - Modified PATH for which command: " + commandLine.getEnvironment().get("PATH"));
        OSProcessHandler oSProcessHandler = new OSProcessHandler(commandLine);
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(output, error){
            final /* synthetic */ StringBuilder $output;
            final /* synthetic */ StringBuilder $error;
            {
                this.$output = $output;
                this.$error = $error;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Key<?> key = outputType;
                if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
                    this.$output.append(event.getText());
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDERR)) {
                    this.$error.append(event.getText());
                }
            }
        });
        oSProcessHandler.startNotify();
        boolean completed = oSProcessHandler.waitFor(5000L);
        this.getLogger().info("Unix - which npx completed with success: " + completed);
        this.getLogger().info("Unix - which npx completed with code: " + oSProcessHandler.getExitCode());
        if (!StringsKt.isBlank((CharSequence)output)) {
            this.getLogger().info("Unix - Output: " + output);
        }
        if (!StringsKt.isBlank((CharSequence)error)) {
            this.getLogger().warn("Unix - Error: " + error);
        }
        if (!completed) return false;
        Integer n = oSProcessHandler.getExitCode();
        if (n == null) return false;
        if (n != 0) return false;
        return true;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(this.GROUP_ID);
        if (!((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(project).getState()).getEnableExportAsMcpServer()) {
            this.getLogger().info("MCP Server is disabled, skipping validation");
            return Unit.INSTANCE;
        }
        boolean npxInstalled = this.isNpxInstalled();
        if (!npxInstalled) {
            Notification notification = notificationGroup.createNotification("Node is not installed", "MCP Server Proxy requires Node.js to be installed", NotificationType.INFORMATION);
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)"Open Installation Instruction", MCPServerStartupValidator::execute$lambda$3));
            notification.notify(project);
        }
        return Unit.INSTANCE;
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MCPServerStartupValidator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final void execute$lambda$3() {
        BrowserUtil.open((String)"https://nodejs.org/en/download/package-manager");
    }
}

