/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llms.tokenizer;

import cc.unitmesh.devti.llms.tokenizer.Tokenizer;
import com.intellij.openapi.components.Service;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.IntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/llms/tokenizer/TokenizerImpl;", "Lcc/unitmesh/devti/llms/tokenizer/Tokenizer;", "<init>", "()V", "maxTokenLength", "", "registry", "Lcom/knuddels/jtokkit/api/EncodingRegistry;", "encoding", "Lcom/knuddels/jtokkit/api/Encoding;", "getMaxLength", "count", "string", "", "tokenize", "Lcom/knuddels/jtokkit/api/IntArrayList;", "chunk", "core"})
public final class TokenizerImpl
implements Tokenizer {
    private final int maxTokenLength;
    @Nullable
    private EncodingRegistry registry;
    @Nullable
    private Encoding encoding;

    public TokenizerImpl() {
        EncodingRegistry encodingRegistry;
        TokenizerImpl tokenizerImpl;
        this.maxTokenLength = 16384;
        TokenizerImpl tokenizerImpl2 = this;
        try {
            tokenizerImpl = tokenizerImpl2;
            encodingRegistry = Encodings.newDefaultEncodingRegistry();
        }
        catch (Exception e) {
            tokenizerImpl = tokenizerImpl2;
            encodingRegistry = null;
        }
        tokenizerImpl.registry = encodingRegistry;
        EncodingRegistry encodingRegistry2 = this.registry;
        this.encoding = encodingRegistry2 != null ? encodingRegistry2.getEncoding(EncodingType.CL100K_BASE) : null;
    }

    @Override
    public int getMaxLength() {
        return this.maxTokenLength;
    }

    @Override
    public int count(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Encoding encoding = this.encoding;
        return encoding != null ? encoding.countTokens(string) : 0;
    }

    @Override
    @Nullable
    public IntArrayList tokenize(@NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Encoding encoding = this.encoding;
        return encoding != null && (encoding = encoding.encode(chunk, this.maxTokenLength)) != null ? encoding.getTokens() : null;
    }
}

